/*
 *  Copyright (C) 2010, Chris Moeller,
 *  All rights reserved.
 *  Optimizations by Gumboot
 *  Additional work by Burt P.
 *  Original code reverse engineered from HDCD decoder library by Christopher Key,
 *  which was likely reverse engineered from Windows Media Player.
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The names of its contributors may not be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * HDCD is High Definition Compatible Digital
 * http://wiki.hydrogenaud.io/index.php?title=High_Definition_Compatible_Digital
 *
 * More information about HDCD-encoded audio CDs:
 * http://www.audiomisc.co.uk/HFN/HDCD/Enigma.html
 * http://www.audiomisc.co.uk/HFN/HDCD/Examined.html
 */

/**
 * @file
 * HDCD decoding filter
 */

#include "libavutil/opt.h"
#include "libavutil/avassert.h"
#include "avfilter.h"
#include "internal.h"
#include "audio.h"

#define PEAK_EXT_LEVEL 0x5981 /* + sizeof(peaktab)-1 = 0x8000  */
static const uint32_t peaktab[0x2680] = {
    0x2cc08300, 0x2cc10600, 0x2cc18900, 0x2cc20c00, 0x2cc28f00, 0x2cc31200, 0x2cc39500, 0x2cc41800, 0x2cc49b00, 0x2cc51e00, 0x2cc5a100, 0x2cc62400, 0x2cc6a700, 0x2cc72a00, 0x2cc7ad00, 0x2cc83000,
    0x2cc8b300, 0x2cc93600, 0x2cc9b900, 0x2cca3c00, 0x2ccabf00, 0x2ccb4200, 0x2ccbc500, 0x2ccc4800, 0x2ccccb00, 0x2ccd4e00, 0x2ccdd100, 0x2cce5400, 0x2cced700, 0x2ccf5a00, 0x2ccfdd00, 0x2cd06000,
    0x2cd0e300, 0x2cd16600, 0x2cd1e900, 0x2cd26c00, 0x2cd2ef00, 0x2cd37200, 0x2cd3f500, 0x2cd47800, 0x2cd4fb00, 0x2cd57e00, 0x2cd60100, 0x2cd68400, 0x2cd70700, 0x2cd78a00, 0x2cd80d00, 0x2cd89000,
    0x2cd91300, 0x2cd99600, 0x2cda1900, 0x2cda9c00, 0x2cdb1f00, 0x2cdba200, 0x2cdc2500, 0x2cdca800, 0x2cdd2b00, 0x2cddae00, 0x2cde3100, 0x2cdeb400, 0x2cdf3700, 0x2cdfba00, 0x2ce03d00, 0x2ce0c000,
    0x2ce14300, 0x2ce1c600, 0x2ce24900, 0x2ce2cc00, 0x2ce34f00, 0x2ce3d200, 0x2ce45500, 0x2ce4d800, 0x2ce55b00, 0x2ce5de00, 0x2ce66100, 0x2ce6e400, 0x2ce76700, 0x2ce7ea00, 0x2ce86d00, 0x2ce8f000,
    0x2ce97300, 0x2ce9f600, 0x2cea7900, 0x2ceafc00, 0x2ceb7f00, 0x2cec0200, 0x2cec8500, 0x2ced0800, 0x2ced8b00, 0x2cee0e00, 0x2cee9100, 0x2cef1400, 0x2cef9700, 0x2cf01a00, 0x2cf09d00, 0x2cf12000,
    0x2cf1a300, 0x2cf22600, 0x2cf2a900, 0x2cf32c00, 0x2cf3af00, 0x2cf43200, 0x2cf4b500, 0x2cf53800, 0x2cf5bb00, 0x2cf63e00, 0x2cf6c100, 0x2cf74400, 0x2cf7c700, 0x2cf84a00, 0x2cf8cd00, 0x2cf95000,
    0x2cf9d300, 0x2cfa5600, 0x2cfad900, 0x2cfb5c00, 0x2cfbdf00, 0x2cfc6200, 0x2cfce500, 0x2cfd6800, 0x2cfdeb00, 0x2cfe6e00, 0x2cfef100, 0x2cff7400, 0x2cfff700, 0x2d007a00, 0x2d00fd00, 0x2d018000,
    0x2d020300, 0x2d028600, 0x2d030900, 0x2d038c00, 0x2d040f00, 0x2d049200, 0x2d051500, 0x2d059800, 0x2d061b00, 0x2d069e00, 0x2d072100, 0x2d07a400, 0x2d082700, 0x2d08aa00, 0x2d092d00, 0x2d09b000,
    0x2d0a3300, 0x2d0ab600, 0x2d0b3900, 0x2d0bbc00, 0x2d0c3f00, 0x2d0cc200, 0x2d0d4500, 0x2d0dc800, 0x2d0e4b00, 0x2d0ece00, 0x2d0f5100, 0x2d0fd400, 0x2d105700, 0x2d10da00, 0x2d115d00, 0x2d11e000,
    0x2d126300, 0x2d12e600, 0x2d136900, 0x2d13ec00, 0x2d146f00, 0x2d14f200, 0x2d157500, 0x2d15f800, 0x2d167b00, 0x2d16fe00, 0x2d178100, 0x2d180400, 0x2d188700, 0x2d190a00, 0x2d198d00, 0x2d1a1000,
    0x2d1a9300, 0x2d1b1600, 0x2d1b9900, 0x2d1c1c00, 0x2d1c9f00, 0x2d1d2200, 0x2d1da500, 0x2d1e2800, 0x2d1eab00, 0x2d1f2e00, 0x2d1fb100, 0x2d203400, 0x2d20b700, 0x2d213a00, 0x2d21bd00, 0x2d224000,
    0x2d22c300, 0x2d234600, 0x2d23c900, 0x2d244c00, 0x2d24cf00, 0x2d255200, 0x2d25d500, 0x2d265800, 0x2d26db00, 0x2d275e00, 0x2d27e100, 0x2d286400, 0x2d28e700, 0x2d296a00, 0x2d29ed00, 0x2d2a7000,
    0x2d2af300, 0x2d2b7600, 0x2d2bf900, 0x2d2c7c00, 0x2d2cff00, 0x2d2d8200, 0x2d2e0500, 0x2d2e8800, 0x2d2f0b00, 0x2d2f8e00, 0x2d301100, 0x2d309400, 0x2d311700, 0x2d319a00, 0x2d321d00, 0x2d32a000,
    0x2d332300, 0x2d33a600, 0x2d342900, 0x2d34ac00, 0x2d352f00, 0x2d35b200, 0x2d363500, 0x2d36b800, 0x2d373b00, 0x2d37be00, 0x2d384100, 0x2d38c400, 0x2d394700, 0x2d39ca00, 0x2d3a4d00, 0x2d3ad000,
    0x2d3b5300, 0x2d3bd600, 0x2d3c5900, 0x2d3cdc00, 0x2d3d5f00, 0x2d3de200, 0x2d3e6500, 0x2d3ee800, 0x2d3f6b00, 0x2d3fee00, 0x2d407100, 0x2d40f400, 0x2d417700, 0x2d41fa00, 0x2d427d00, 0x2d430000,
    0x2d438300, 0x2d440600, 0x2d448900, 0x2d450c00, 0x2d458f00, 0x2d461200, 0x2d469500, 0x2d471800, 0x2d479b00, 0x2d481e00, 0x2d48a100, 0x2d492400, 0x2d49a700, 0x2d4a2a00, 0x2d4aad00, 0x2d4b3000,
    0x2d4bb300, 0x2d4c3600, 0x2d4cb900, 0x2d4d3c00, 0x2d4dbf00, 0x2d4e4200, 0x2d4ec500, 0x2d4f4800, 0x2d4fcb00, 0x2d504e00, 0x2d50d100, 0x2d515400, 0x2d51d700, 0x2d525a00, 0x2d52dd00, 0x2d536000,
    0x2d53e300, 0x2d546600, 0x2d54e900, 0x2d556c00, 0x2d55ef00, 0x2d567200, 0x2d56f500, 0x2d577800, 0x2d57fb00, 0x2d587e00, 0x2d590100, 0x2d598400, 0x2d5a0700, 0x2d5a8a00, 0x2d5b0d00, 0x2d5b9000,
    0x2d5c1300, 0x2d5c9600, 0x2d5d1900, 0x2d5d9c00, 0x2d5e1f00, 0x2d5ea200, 0x2d5f2500, 0x2d5fa800, 0x2d602b00, 0x2d60ae00, 0x2d613100, 0x2d61b400, 0x2d623700, 0x2d62ba00, 0x2d633d00, 0x2d63c000,
    0x2d644300, 0x2d64c600, 0x2d654900, 0x2d65cc00, 0x2d664f00, 0x2d66d200, 0x2d675500, 0x2d67d800, 0x2d685b00, 0x2d68de00, 0x2d696100, 0x2d69e400, 0x2d6a6700, 0x2d6aea00, 0x2d6b6d00, 0x2d6bf000,
    0x2d6c7300, 0x2d6cf600, 0x2d6d7900, 0x2d6dfc00, 0x2d6e7f00, 0x2d6f0200, 0x2d6f8500, 0x2d700800, 0x2d708b00, 0x2d710e00, 0x2d719100, 0x2d721400, 0x2d729700, 0x2d731a00, 0x2d739d00, 0x2d742000,
    0x2d74a300, 0x2d752600, 0x2d75a900, 0x2d762c00, 0x2d76af00, 0x2d773200, 0x2d77b500, 0x2d783800, 0x2d78bb00, 0x2d793e00, 0x2d79c100, 0x2d7a4400, 0x2d7ac700, 0x2d7b4a00, 0x2d7bcd00, 0x2d7c5000,
    0x2d7cd300, 0x2d7d5600, 0x2d7dd900, 0x2d7e5c00, 0x2d7edf00, 0x2d7f6200, 0x2d7fe500, 0x2d806800, 0x2d80eb00, 0x2d816e00, 0x2d81f100, 0x2d827400, 0x2d82f700, 0x2d837a00, 0x2d83fd00, 0x2d848000,
    0x2d850300, 0x2d858600, 0x2d860900, 0x2d868c00, 0x2d870f00, 0x2d879200, 0x2d881500, 0x2d889800, 0x2d891b00, 0x2d899e00, 0x2d8a2100, 0x2d8aa400, 0x2d8b2700, 0x2d8baa00, 0x2d8c2d00, 0x2d8cb000,
    0x2d8d3300, 0x2d8db600, 0x2d8e3900, 0x2d8ebc00, 0x2d8f3f00, 0x2d8fc200, 0x2d904500, 0x2d90c800, 0x2d914b00, 0x2d91ce00, 0x2d925100, 0x2d92d400, 0x2d935700, 0x2d93da00, 0x2d945d00, 0x2d94e000,
    0x2d956300, 0x2d95e600, 0x2d966900, 0x2d96ec00, 0x2d976f00, 0x2d97f200, 0x2d987500, 0x2d98f800, 0x2d997b00, 0x2d99fe00, 0x2d9a8100, 0x2d9b0400, 0x2d9b8700, 0x2d9c0a00, 0x2d9c8d00, 0x2d9d1000,
    0x2d9d9300, 0x2d9e1600, 0x2d9e9900, 0x2d9f1c00, 0x2d9f9f00, 0x2da02200, 0x2da0a500, 0x2da12800, 0x2da1ab00, 0x2da22e00, 0x2da2b100, 0x2da33400, 0x2da3b700, 0x2da43a00, 0x2da4bd00, 0x2da54000,
    0x2da5c300, 0x2da64600, 0x2da6c900, 0x2da74c00, 0x2da7cf00, 0x2da85200, 0x2da8d500, 0x2da95800, 0x2da9db00, 0x2daa5e00, 0x2daae100, 0x2dab6400, 0x2dabe700, 0x2dac6a00, 0x2daced00, 0x2dad7000,
    0x2dadf300, 0x2dae7600, 0x2daef900, 0x2daf7c00, 0x2dafff00, 0x2db08200, 0x2db10500, 0x2db18800, 0x2db20b00, 0x2db28e00, 0x2db31100, 0x2db39400, 0x2db41700, 0x2db49a00, 0x2db51d00, 0x2db5a000,
    0x2db62300, 0x2db6a600, 0x2db72900, 0x2db7ac00, 0x2db82f00, 0x2db8b200, 0x2db93500, 0x2db9b800, 0x2dba3b00, 0x2dbabe00, 0x2dbb4100, 0x2dbbc400, 0x2dbc4700, 0x2dbcca00, 0x2dbd4d00, 0x2dbdd000,
    0x2dbe5300, 0x2dbed600, 0x2dbf5900, 0x2dbfdc00, 0x2dc05f00, 0x2dc0e200, 0x2dc16500, 0x2dc1e800, 0x2dc26b00, 0x2dc2ee00, 0x2dc37100, 0x2dc3f400, 0x2dc47700, 0x2dc4fa00, 0x2dc57d00, 0x2dc60000,
    0x2dc68700, 0x2dc70e00, 0x2dc79500, 0x2dc81c00, 0x2dc8a300, 0x2dc92a00, 0x2dc9b100, 0x2dca3800, 0x2dcabf00, 0x2dcb4600, 0x2dcbcd00, 0x2dcc5400, 0x2dccdb00, 0x2dcd6200, 0x2dcde900, 0x2dce7000,
    0x2dcef700, 0x2dcf7e00, 0x2dd00500, 0x2dd08c00, 0x2dd11300, 0x2dd19a00, 0x2dd22100, 0x2dd2a800, 0x2dd32f00, 0x2dd3b600, 0x2dd43d00, 0x2dd4c400, 0x2dd54b00, 0x2dd5d200, 0x2dd65900, 0x2dd6e000,
    0x2dd76700, 0x2dd7ee00, 0x2dd87500, 0x2dd8fc00, 0x2dd98300, 0x2dda0a00, 0x2dda9100, 0x2ddb1800, 0x2ddb9f00, 0x2ddc2600, 0x2ddcad00, 0x2ddd3400, 0x2dddbb00, 0x2dde4200, 0x2ddec900, 0x2ddf5000,
    0x2ddfd700, 0x2de05e00, 0x2de0e500, 0x2de16c00, 0x2de1f300, 0x2de27a00, 0x2de30100, 0x2de38800, 0x2de40f00, 0x2de49600, 0x2de51d00, 0x2de5a400, 0x2de62b00, 0x2de6b200, 0x2de73900, 0x2de7c000,
    0x2de84700, 0x2de8ce00, 0x2de95500, 0x2de9dc00, 0x2dea6300, 0x2deaea00, 0x2deb7100, 0x2debf800, 0x2dec7f00, 0x2ded0600, 0x2ded8d00, 0x2dee1400, 0x2dee9b00, 0x2def2200, 0x2defa900, 0x2df03000,
    0x2df0b700, 0x2df13e00, 0x2df1c500, 0x2df24c00, 0x2df2d300, 0x2df35a00, 0x2df3e100, 0x2df46800, 0x2df4ef00, 0x2df57600, 0x2df5fd00, 0x2df68400, 0x2df70b00, 0x2df79200, 0x2df81900, 0x2df8a000,
    0x2df92700, 0x2df9ae00, 0x2dfa3500, 0x2dfabc00, 0x2dfb4300, 0x2dfbca00, 0x2dfc5100, 0x2dfcd800, 0x2dfd5f00, 0x2dfde600, 0x2dfe6d00, 0x2dfef400, 0x2dff7b00, 0x2e000200, 0x2e008900, 0x2e011000,
    0x2e019700, 0x2e021e00, 0x2e02a500, 0x2e032c00, 0x2e03b300, 0x2e043a00, 0x2e04c100, 0x2e054800, 0x2e05cf00, 0x2e065600, 0x2e06dd00, 0x2e076400, 0x2e07eb00, 0x2e087200, 0x2e08f900, 0x2e098000,
    0x2e0a0700, 0x2e0a8e00, 0x2e0b1500, 0x2e0b9c00, 0x2e0c2300, 0x2e0caa00, 0x2e0d3100, 0x2e0db800, 0x2e0e3f00, 0x2e0ec600, 0x2e0f4d00, 0x2e0fd400, 0x2e105b00, 0x2e10e200, 0x2e116900, 0x2e11f000,
    0x2e127700, 0x2e12fe00, 0x2e138500, 0x2e140c00, 0x2e149300, 0x2e151a00, 0x2e15a100, 0x2e162800, 0x2e16af00, 0x2e173600, 0x2e17bd00, 0x2e184400, 0x2e18cb00, 0x2e195200, 0x2e19d900, 0x2e1a6000,
    0x2e1ae700, 0x2e1b6e00, 0x2e1bf500, 0x2e1c7c00, 0x2e1d0300, 0x2e1d8a00, 0x2e1e1100, 0x2e1e9800, 0x2e1f1f00, 0x2e1fa600, 0x2e202d00, 0x2e20b400, 0x2e213b00, 0x2e21c200, 0x2e224900, 0x2e22d000,
    0x2e235700, 0x2e23de00, 0x2e246500, 0x2e24ec00, 0x2e257300, 0x2e25fa00, 0x2e268100, 0x2e270800, 0x2e278f00, 0x2e281600, 0x2e289d00, 0x2e292400, 0x2e29ab00, 0x2e2a3200, 0x2e2ab900, 0x2e2b4000,
    0x2e2bc700, 0x2e2c4e00, 0x2e2cd500, 0x2e2d5c00, 0x2e2de300, 0x2e2e6a00, 0x2e2ef100, 0x2e2f7800, 0x2e2fff00, 0x2e308600, 0x2e310d00, 0x2e319400, 0x2e321b00, 0x2e32a200, 0x2e332900, 0x2e33b000,
    0x2e343700, 0x2e34be00, 0x2e354500, 0x2e35cc00, 0x2e365300, 0x2e36da00, 0x2e376100, 0x2e37e800, 0x2e386f00, 0x2e38f600, 0x2e397d00, 0x2e3a0400, 0x2e3a8b00, 0x2e3b1200, 0x2e3b9900, 0x2e3c2000,
    0x2e3ca700, 0x2e3d2e00, 0x2e3db500, 0x2e3e3c00, 0x2e3ec300, 0x2e3f4a00, 0x2e3fd100, 0x2e405800, 0x2e40df00, 0x2e416600, 0x2e41ed00, 0x2e427400, 0x2e42fb00, 0x2e438200, 0x2e440900, 0x2e449000,
    0x2e451700, 0x2e459e00, 0x2e462500, 0x2e46ac00, 0x2e473300, 0x2e47ba00, 0x2e484100, 0x2e48c800, 0x2e494f00, 0x2e49d600, 0x2e4a5d00, 0x2e4ae400, 0x2e4b6b00, 0x2e4bf200, 0x2e4c7900, 0x2e4d0000,
    0x2e4d8700, 0x2e4e0e00, 0x2e4e9500, 0x2e4f1c00, 0x2e4fa300, 0x2e502a00, 0x2e50b100, 0x2e513800, 0x2e51bf00, 0x2e524600, 0x2e52cd00, 0x2e535400, 0x2e53db00, 0x2e546200, 0x2e54e900, 0x2e557000,
    0x2e55f700, 0x2e567e00, 0x2e570500, 0x2e578c00, 0x2e581300, 0x2e589a00, 0x2e592100, 0x2e59a800, 0x2e5a2f00, 0x2e5ab600, 0x2e5b3d00, 0x2e5bc400, 0x2e5c4b00, 0x2e5cd200, 0x2e5d5900, 0x2e5de000,
    0x2e5e6700, 0x2e5eee00, 0x2e5f7500, 0x2e5ffc00, 0x2e608300, 0x2e610a00, 0x2e619100, 0x2e621800, 0x2e629f00, 0x2e632600, 0x2e63ad00, 0x2e643400, 0x2e64bb00, 0x2e654200, 0x2e65c900, 0x2e665000,
    0x2e66d700, 0x2e675e00, 0x2e67e500, 0x2e686c00, 0x2e68f300, 0x2e697a00, 0x2e6a0100, 0x2e6a8800, 0x2e6b0f00, 0x2e6b9600, 0x2e6c1d00, 0x2e6ca400, 0x2e6d2b00, 0x2e6db200, 0x2e6e3900, 0x2e6ec000,
    0x2e6f4700, 0x2e6fce00, 0x2e705500, 0x2e70dc00, 0x2e716300, 0x2e71ea00, 0x2e727100, 0x2e72f800, 0x2e737f00, 0x2e740600, 0x2e748d00, 0x2e751400, 0x2e759b00, 0x2e762200, 0x2e76a900, 0x2e773000,
    0x2e77b700, 0x2e783e00, 0x2e78c500, 0x2e794c00, 0x2e79d300, 0x2e7a5a00, 0x2e7ae100, 0x2e7b6800, 0x2e7bef00, 0x2e7c7600, 0x2e7cfd00, 0x2e7d8400, 0x2e7e0b00, 0x2e7e9200, 0x2e7f1900, 0x2e7fa000,
    0x2e802700, 0x2e80ae00, 0x2e813500, 0x2e81bc00, 0x2e824300, 0x2e82ca00, 0x2e835100, 0x2e83d800, 0x2e845f00, 0x2e84e600, 0x2e856d00, 0x2e85f400, 0x2e867b00, 0x2e870200, 0x2e878900, 0x2e881000,
    0x2e889700, 0x2e891e00, 0x2e89a500, 0x2e8a2c00, 0x2e8ab300, 0x2e8b3a00, 0x2e8bc100, 0x2e8c4800, 0x2e8ccf00, 0x2e8d5600, 0x2e8ddd00, 0x2e8e6400, 0x2e8eeb00, 0x2e8f7200, 0x2e8ff900, 0x2e908000,
    0x2e910700, 0x2e918e00, 0x2e921500, 0x2e929c00, 0x2e932300, 0x2e93aa00, 0x2e943100, 0x2e94b800, 0x2e953f00, 0x2e95c600, 0x2e964d00, 0x2e96d400, 0x2e975b00, 0x2e97e200, 0x2e986900, 0x2e98f000,
    0x2e997700, 0x2e99fe00, 0x2e9a8500, 0x2e9b0c00, 0x2e9b9300, 0x2e9c1a00, 0x2e9ca100, 0x2e9d2800, 0x2e9daf00, 0x2e9e3600, 0x2e9ebd00, 0x2e9f4400, 0x2e9fcb00, 0x2ea05200, 0x2ea0d900, 0x2ea16000,
    0x2ea1e700, 0x2ea26e00, 0x2ea2f500, 0x2ea37c00, 0x2ea40300, 0x2ea48a00, 0x2ea51100, 0x2ea59800, 0x2ea61f00, 0x2ea6a600, 0x2ea72d00, 0x2ea7b400, 0x2ea83b00, 0x2ea8c200, 0x2ea94900, 0x2ea9d000,
    0x2eaa5700, 0x2eaade00, 0x2eab6500, 0x2eabec00, 0x2eac7300, 0x2eacfa00, 0x2ead8100, 0x2eae0800, 0x2eae8f00, 0x2eaf1600, 0x2eaf9d00, 0x2eb02400, 0x2eb0ab00, 0x2eb13200, 0x2eb1b900, 0x2eb24000,
    0x2eb2c700, 0x2eb34e00, 0x2eb3d500, 0x2eb45c00, 0x2eb4e300, 0x2eb56a00, 0x2eb5f100, 0x2eb67800, 0x2eb6ff00, 0x2eb78600, 0x2eb80d00, 0x2eb89400, 0x2eb91b00, 0x2eb9a200, 0x2eba2900, 0x2ebab000,
    0x2ebb3700, 0x2ebbbe00, 0x2ebc4500, 0x2ebccc00, 0x2ebd5300, 0x2ebdda00, 0x2ebe6100, 0x2ebee800, 0x2ebf6f00, 0x2ebff600, 0x2ec07d00, 0x2ec10400, 0x2ec18b00, 0x2ec21200, 0x2ec29900, 0x2ec32000,
    0x2ec3a700, 0x2ec42e00, 0x2ec4b500, 0x2ec53c00, 0x2ec5c300, 0x2ec64a00, 0x2ec6d100, 0x2ec75800, 0x2ec7df00, 0x2ec86600, 0x2ec8ed00, 0x2ec97400, 0x2ec9fb00, 0x2eca8200, 0x2ecb0900, 0x2ecb9000,
    0x2ecc1700, 0x2ecc9e00, 0x2ecd2500, 0x2ecdac00, 0x2ece3300, 0x2eceba00, 0x2ecf4100, 0x2ecfc800, 0x2ed04f00, 0x2ed0d600, 0x2ed15d00, 0x2ed1e400, 0x2ed26b00, 0x2ed2f200, 0x2ed37900, 0x2ed40000,
    0x2ed48700, 0x2ed50e00, 0x2ed59500, 0x2ed61c00, 0x2ed6a300, 0x2ed72a00, 0x2ed7b100, 0x2ed83800, 0x2ed8bf00, 0x2ed94600, 0x2ed9cd00, 0x2eda5400, 0x2edadb00, 0x2edb6200, 0x2edbe900, 0x2edc7000,
    0x2edcf700, 0x2edd7e00, 0x2ede0500, 0x2ede8c00, 0x2edf1300, 0x2edf9a00, 0x2ee02100, 0x2ee0a800, 0x2ee12f00, 0x2ee1b600, 0x2ee23d00, 0x2ee2c400, 0x2ee34b00, 0x2ee3d200, 0x2ee45900, 0x2ee4e000,
    0x2ee56700, 0x2ee5ee00, 0x2ee67500, 0x2ee6fc00, 0x2ee78300, 0x2ee80a00, 0x2ee89100, 0x2ee91800, 0x2ee99f00, 0x2eea2600, 0x2eeaad00, 0x2eeb3400, 0x2eebbb00, 0x2eec4200, 0x2eecc900, 0x2eed5000,
    0x2eedd700, 0x2eee5e00, 0x2eeee500, 0x2eef6c00, 0x2eeff300, 0x2ef07a00, 0x2ef10100, 0x2ef18800, 0x2ef20f00, 0x2ef29600, 0x2ef31d00, 0x2ef3a400, 0x2ef42b00, 0x2ef4b200, 0x2ef53900, 0x2ef5c000,
    0x2ef64700, 0x2ef6ce00, 0x2ef75500, 0x2ef7dc00, 0x2ef86300, 0x2ef8ea00, 0x2ef97100, 0x2ef9f800, 0x2efa7f00, 0x2efb0600, 0x2efb8d00, 0x2efc1400, 0x2efc9b00, 0x2efd2200, 0x2efda900, 0x2efe3000,
    0x2efeb700, 0x2eff3e00, 0x2effc500, 0x2f004c00, 0x2f00d300, 0x2f015a00, 0x2f01e100, 0x2f026800, 0x2f02ef00, 0x2f037600, 0x2f03fd00, 0x2f048400, 0x2f050b00, 0x2f059200, 0x2f061900, 0x2f06a000,
    0x2f072700, 0x2f07ae00, 0x2f083500, 0x2f08bc00, 0x2f094300, 0x2f09ca00, 0x2f0a5100, 0x2f0ad800, 0x2f0b5f00, 0x2f0be600, 0x2f0c6d00, 0x2f0cf400, 0x2f0d7b00, 0x2f0e0200, 0x2f0e8900, 0x2f0f1000,
    0x2f0f9700, 0x2f101e00, 0x2f10a500, 0x2f112c00, 0x2f11b300, 0x2f123a00, 0x2f12c100, 0x2f134800, 0x2f13cf00, 0x2f145600, 0x2f14dd00, 0x2f156400, 0x2f15eb00, 0x2f167200, 0x2f16f900, 0x2f178000,
    0x2f180700, 0x2f188e00, 0x2f191500, 0x2f199c00, 0x2f1a2300, 0x2f1aaa00, 0x2f1b3100, 0x2f1bb800, 0x2f1c3f00, 0x2f1cc600, 0x2f1d4d00, 0x2f1dd400, 0x2f1e5b00, 0x2f1ee200, 0x2f1f6900, 0x2f1ff000,
    0x2f207700, 0x2f20fe00, 0x2f218500, 0x2f220c00, 0x2f229300, 0x2f231a00, 0x2f23a100, 0x2f242800, 0x2f24af00, 0x2f253600, 0x2f25bd00, 0x2f264400, 0x2f26cb00, 0x2f275200, 0x2f27d900, 0x2f286000,
    0x2f28e700, 0x2f296e00, 0x2f29f500, 0x2f2a7c00, 0x2f2b0300, 0x2f2b8a00, 0x2f2c1100, 0x2f2c9800, 0x2f2d1f00, 0x2f2da600, 0x2f2e2d00, 0x2f2eb400, 0x2f2f3b00, 0x2f2fc200, 0x2f304900, 0x2f30d000,
    0x2f315700, 0x2f31de00, 0x2f326500, 0x2f32ec00, 0x2f337300, 0x2f33fa00, 0x2f348100, 0x2f350800, 0x2f358f00, 0x2f361600, 0x2f369d00, 0x2f372400, 0x2f37ab00, 0x2f383200, 0x2f38b900, 0x2f394000,
    0x2f39c700, 0x2f3a4e00, 0x2f3ad500, 0x2f3b5c00, 0x2f3be300, 0x2f3c6a00, 0x2f3cf100, 0x2f3d7800, 0x2f3dff00, 0x2f3e8600, 0x2f3f0d00, 0x2f3f9400, 0x2f401b00, 0x2f40a200, 0x2f412900, 0x2f41b000,
    0x2f423700, 0x2f42be00, 0x2f434500, 0x2f43cc00, 0x2f445300, 0x2f44da00, 0x2f456100, 0x2f45e800, 0x2f466f00, 0x2f46f600, 0x2f477d00, 0x2f480400, 0x2f488b00, 0x2f491200, 0x2f499900, 0x2f4a2000,
    0x2f4aa700, 0x2f4b2e00, 0x2f4bb500, 0x2f4c3c00, 0x2f4cc300, 0x2f4d4a00, 0x2f4dd100, 0x2f4e5800, 0x2f4edf00, 0x2f4f6600, 0x2f4fed00, 0x2f507400, 0x2f50fb00, 0x2f518200, 0x2f520900, 0x2f529000,
    0x2f531700, 0x2f539e00, 0x2f542500, 0x2f54ac00, 0x2f553300, 0x2f55ba00, 0x2f564100, 0x2f56c800, 0x2f574f00, 0x2f57d600, 0x2f585d00, 0x2f58e400, 0x2f596b00, 0x2f59f200, 0x2f5a7900, 0x2f5b0000,
    0x2f5b8700, 0x2f5c0e00, 0x2f5c9500, 0x2f5d1c00, 0x2f5da300, 0x2f5e2a00, 0x2f5eb100, 0x2f5f3800, 0x2f5fbf00, 0x2f604600, 0x2f60cd00, 0x2f615400, 0x2f61db00, 0x2f626200, 0x2f62e900, 0x2f637000,
    0x2f63f700, 0x2f647e00, 0x2f650500, 0x2f658c00, 0x2f661300, 0x2f669a00, 0x2f672100, 0x2f67a800, 0x2f682f00, 0x2f68b600, 0x2f693d00, 0x2f69c400, 0x2f6a4b00, 0x2f6ad200, 0x2f6b5900, 0x2f6be000,
    0x2f6c6700, 0x2f6cee00, 0x2f6d7500, 0x2f6dfc00, 0x2f6e8300, 0x2f6f0a00, 0x2f6f9100, 0x2f701800, 0x2f709f00, 0x2f712600, 0x2f71ad00, 0x2f723400, 0x2f72bb00, 0x2f734200, 0x2f73c900, 0x2f745000,
    0x2f74d700, 0x2f755e00, 0x2f75e500, 0x2f766c00, 0x2f76f300, 0x2f777a00, 0x2f780100, 0x2f788800, 0x2f790f00, 0x2f799600, 0x2f7a1d00, 0x2f7aa400, 0x2f7b2b00, 0x2f7bb200, 0x2f7c3900, 0x2f7cc000,
    0x2f7d4700, 0x2f7dce00, 0x2f7e5500, 0x2f7edc00, 0x2f7f6300, 0x2f7fea00, 0x2f807100, 0x2f80f800, 0x2f817f00, 0x2f820600, 0x2f828d00, 0x2f831400, 0x2f839b00, 0x2f842200, 0x2f84a900, 0x2f853000,
    0x2f85b700, 0x2f863e00, 0x2f86c500, 0x2f874c00, 0x2f87d300, 0x2f885a00, 0x2f88e100, 0x2f896800, 0x2f89ef00, 0x2f8a7600, 0x2f8afd00, 0x2f8b8400, 0x2f8c0b00, 0x2f8c9200, 0x2f8d1900, 0x2f8da000,
    0x2f8e2700, 0x2f8eae00, 0x2f8f3500, 0x2f8fbc00, 0x2f904300, 0x2f90ca00, 0x2f915100, 0x2f91d800, 0x2f925f00, 0x2f92e600, 0x2f936d00, 0x2f93f400, 0x2f947b00, 0x2f950200, 0x2f958900, 0x2f961000,
    0x2f969700, 0x2f971e00, 0x2f97a500, 0x2f982c00, 0x2f98b300, 0x2f993a00, 0x2f99c100, 0x2f9a4800, 0x2f9acf00, 0x2f9b5600, 0x2f9bdd00, 0x2f9c6400, 0x2f9ceb00, 0x2f9d7200, 0x2f9df900, 0x2f9e8000,
    0x2f9f0700, 0x2f9f8e00, 0x2fa01500, 0x2fa09c00, 0x2fa12300, 0x2fa1aa00, 0x2fa23100, 0x2fa2b800, 0x2fa33f00, 0x2fa3c600, 0x2fa44d00, 0x2fa4d400, 0x2fa55b00, 0x2fa5e200, 0x2fa66900, 0x2fa6f000,
    0x2fa77700, 0x2fa7fe00, 0x2fa88500, 0x2fa90c00, 0x2fa99300, 0x2faa1a00, 0x2faaa100, 0x2fab2800, 0x2fabaf00, 0x2fac3600, 0x2facbd00, 0x2fad4400, 0x2fadcb00, 0x2fae5200, 0x2faed900, 0x2faf6000,
    0x2fafe700, 0x2fb06e00, 0x2fb0f500, 0x2fb17c00, 0x2fb20300, 0x2fb28a00, 0x2fb31100, 0x2fb39800, 0x2fb41f00, 0x2fb4a600, 0x2fb52d00, 0x2fb5b400, 0x2fb63b00, 0x2fb6c200, 0x2fb74900, 0x2fb7d000,
    0x2fb85700, 0x2fb8de00, 0x2fb96500, 0x2fb9ec00, 0x2fba7300, 0x2fbafa00, 0x2fbb8100, 0x2fbc0800, 0x2fbc8f00, 0x2fbd1600, 0x2fbd9d00, 0x2fbe2400, 0x2fbeab00, 0x2fbf3200, 0x2fbfb900, 0x2fc04000,
    0x2fc0c700, 0x2fc14e00, 0x2fc1d500, 0x2fc25c00, 0x2fc2e300, 0x2fc36a00, 0x2fc3f100, 0x2fc47800, 0x2fc4ff00, 0x2fc58600, 0x2fc60d00, 0x2fc69400, 0x2fc71b00, 0x2fc7a200, 0x2fc82900, 0x2fc8b000,
    0x2fc93700, 0x2fc9be00, 0x2fca4500, 0x2fcacc00, 0x2fcb5300, 0x2fcbda00, 0x2fcc6100, 0x2fcce800, 0x2fcd6f00, 0x2fcdf600, 0x2fce7d00, 0x2fcf0400, 0x2fcf8b00, 0x2fd01200, 0x2fd09900, 0x2fd12000,
    0x2fd1a700, 0x2fd22e00, 0x2fd2b500, 0x2fd33c00, 0x2fd3c300, 0x2fd44a00, 0x2fd4d100, 0x2fd55800, 0x2fd5df00, 0x2fd66600, 0x2fd6ed00, 0x2fd77400, 0x2fd7fb00, 0x2fd88200, 0x2fd90900, 0x2fd99000,
    0x2fda1700, 0x2fda9e00, 0x2fdb2500, 0x2fdbac00, 0x2fdc3300, 0x2fdcba00, 0x2fdd4100, 0x2fddc800, 0x2fde4f00, 0x2fded600, 0x2fdf5d00, 0x2fdfe400, 0x2fe06b00, 0x2fe0f200, 0x2fe17900, 0x2fe20000,
    0x2fe29600, 0x2fe32c00, 0x2fe3c200, 0x2fe45800, 0x2fe4ee00, 0x2fe58400, 0x2fe61a00, 0x2fe6b000, 0x2fe74600, 0x2fe7dc00, 0x2fe87200, 0x2fe90800, 0x2fe99e00, 0x2fea3400, 0x2feaca00, 0x2feb6000,
    0x2febf600, 0x2fec8c00, 0x2fed2200, 0x2fedb800, 0x2fee4e00, 0x2feee400, 0x2fef7a00, 0x2ff01000, 0x2ff0a600, 0x2ff13c00, 0x2ff1d200, 0x2ff26800, 0x2ff2fe00, 0x2ff39400, 0x2ff42a00, 0x2ff4c000,
    0x2ff55600, 0x2ff5ec00, 0x2ff68200, 0x2ff71800, 0x2ff7ae00, 0x2ff84400, 0x2ff8da00, 0x2ff97000, 0x2ffa0600, 0x2ffa9c00, 0x2ffb3200, 0x2ffbc800, 0x2ffc5e00, 0x2ffcf400, 0x2ffd8a00, 0x2ffe2000,
    0x2ffeb600, 0x2fff4c00, 0x2fffe200, 0x30007800, 0x30010e00, 0x3001a400, 0x30023a00, 0x3002d000, 0x30036600, 0x3003fc00, 0x30049200, 0x30052800, 0x3005be00, 0x30065400, 0x3006ea00, 0x30078000,
    0x30081600, 0x3008ac00, 0x30094200, 0x3009d800, 0x300a6e00, 0x300b0400, 0x300b9a00, 0x300c3000, 0x300cc600, 0x300d5c00, 0x300df200, 0x300e8800, 0x300f1e00, 0x300fb400, 0x30104a00, 0x3010e000,
    0x30117600, 0x30120c00, 0x3012a200, 0x30133800, 0x3013ce00, 0x30146400, 0x3014fa00, 0x30159000, 0x30162600, 0x3016bc00, 0x30175200, 0x3017e800, 0x30187e00, 0x30191400, 0x3019aa00, 0x301a4000,
    0x301ad600, 0x301b6c00, 0x301c0200, 0x301c9800, 0x301d2e00, 0x301dc400, 0x301e5a00, 0x301ef000, 0x301f8600, 0x30201c00, 0x3020b200, 0x30214800, 0x3021de00, 0x30227400, 0x30230a00, 0x3023a000,
    0x30243600, 0x3024cc00, 0x30256200, 0x3025f800, 0x30268e00, 0x30272400, 0x3027ba00, 0x30285000, 0x3028e600, 0x30297c00, 0x302a1200, 0x302aa800, 0x302b3e00, 0x302bd400, 0x302c6a00, 0x302d0000,
    0x302d9600, 0x302e2c00, 0x302ec200, 0x302f5800, 0x302fee00, 0x30308400, 0x30311a00, 0x3031b000, 0x30324600, 0x3032dc00, 0x30337200, 0x30340800, 0x30349e00, 0x30353400, 0x3035ca00, 0x30366000,
    0x3036f600, 0x30378c00, 0x30382200, 0x3038b800, 0x30394e00, 0x3039e400, 0x303a7a00, 0x303b1000, 0x303ba600, 0x303c3c00, 0x303cd200, 0x303d6800, 0x303dfe00, 0x303e9400, 0x303f2a00, 0x303fc000,
    0x30405600, 0x3040ec00, 0x30418200, 0x30421800, 0x3042ae00, 0x30434400, 0x3043da00, 0x30447000, 0x30450600, 0x30459c00, 0x30463200, 0x3046c800, 0x30475e00, 0x3047f400, 0x30488a00, 0x30492000,
    0x3049b600, 0x304a4c00, 0x304ae200, 0x304b7800, 0x304c0e00, 0x304ca400, 0x304d3a00, 0x304dd000, 0x304e6600, 0x304efc00, 0x304f9200, 0x30502800, 0x3050be00, 0x30515400, 0x3051ea00, 0x30528000,
    0x30531600, 0x3053ac00, 0x30544200, 0x3054d800, 0x30556e00, 0x30560400, 0x30569a00, 0x30573000, 0x3057c600, 0x30585c00, 0x3058f200, 0x30598800, 0x305a1e00, 0x305ab400, 0x305b4a00, 0x305be000,
    0x305c7600, 0x305d0c00, 0x305da200, 0x305e3800, 0x305ece00, 0x305f6400, 0x305ffa00, 0x30609000, 0x30612600, 0x3061bc00, 0x30625200, 0x3062e800, 0x30637e00, 0x30641400, 0x3064aa00, 0x30654000,
    0x3065d600, 0x30666c00, 0x30670200, 0x30679800, 0x30682e00, 0x3068c400, 0x30695a00, 0x3069f000, 0x306a8600, 0x306b1c00, 0x306bb200, 0x306c4800, 0x306cde00, 0x306d7400, 0x306e0a00, 0x306ea000,
    0x306f3600, 0x306fcc00, 0x30706200, 0x3070f800, 0x30718e00, 0x30722400, 0x3072ba00, 0x30735000, 0x3073e600, 0x30747c00, 0x30751200, 0x3075a800, 0x30763e00, 0x3076d400, 0x30776a00, 0x30780000,
    0x30789600, 0x30792c00, 0x3079c200, 0x307a5800, 0x307aee00, 0x307b8400, 0x307c1a00, 0x307cb000, 0x307d4600, 0x307ddc00, 0x307e7200, 0x307f0800, 0x307f9e00, 0x30803400, 0x3080ca00, 0x30816000,
    0x3081f600, 0x30828c00, 0x30832200, 0x3083b800, 0x30844e00, 0x3084e400, 0x30857a00, 0x30861000, 0x3086a600, 0x30873c00, 0x3087d200, 0x30886800, 0x3088fe00, 0x30899400, 0x308a2a00, 0x308ac000,
    0x308b5600, 0x308bec00, 0x308c8200, 0x308d1800, 0x308dae00, 0x308e4400, 0x308eda00, 0x308f7000, 0x30900600, 0x30909c00, 0x30913200, 0x3091c800, 0x30925e00, 0x3092f400, 0x30938a00, 0x30942000,
    0x3094b600, 0x30954c00, 0x3095e200, 0x30967800, 0x30970e00, 0x3097a400, 0x30983a00, 0x3098d000, 0x30996600, 0x3099fc00, 0x309a9200, 0x309b2800, 0x309bbe00, 0x309c5400, 0x309cea00, 0x309d8000,
    0x309e1600, 0x309eac00, 0x309f4200, 0x309fd800, 0x30a06e00, 0x30a10400, 0x30a19a00, 0x30a23000, 0x30a2c600, 0x30a35c00, 0x30a3f200, 0x30a48800, 0x30a51e00, 0x30a5b400, 0x30a64a00, 0x30a6e000,
    0x30a77600, 0x30a80c00, 0x30a8a200, 0x30a93800, 0x30a9ce00, 0x30aa6400, 0x30aafa00, 0x30ab9000, 0x30ac2600, 0x30acbc00, 0x30ad5200, 0x30ade800, 0x30ae7e00, 0x30af1400, 0x30afaa00, 0x30b04000,
    0x30b0d600, 0x30b16c00, 0x30b20200, 0x30b29800, 0x30b32e00, 0x30b3c400, 0x30b45a00, 0x30b4f000, 0x30b58600, 0x30b61c00, 0x30b6b200, 0x30b74800, 0x30b7de00, 0x30b87400, 0x30b90a00, 0x30b9a000,
    0x30ba3600, 0x30bacc00, 0x30bb6200, 0x30bbf800, 0x30bc8e00, 0x30bd2400, 0x30bdba00, 0x30be5000, 0x30bee600, 0x30bf7c00, 0x30c01200, 0x30c0a800, 0x30c13e00, 0x30c1d400, 0x30c26a00, 0x30c30000,
    0x30c39600, 0x30c42c00, 0x30c4c200, 0x30c55800, 0x30c5ee00, 0x30c68400, 0x30c71a00, 0x30c7b000, 0x30c84600, 0x30c8dc00, 0x30c97200, 0x30ca0800, 0x30ca9e00, 0x30cb3400, 0x30cbca00, 0x30cc6000,
    0x30ccf600, 0x30cd8c00, 0x30ce2200, 0x30ceb800, 0x30cf4e00, 0x30cfe400, 0x30d07a00, 0x30d11000, 0x30d1a600, 0x30d23c00, 0x30d2d200, 0x30d36800, 0x30d3fe00, 0x30d49400, 0x30d52a00, 0x30d5c000,
    0x30d65600, 0x30d6ec00, 0x30d78200, 0x30d81800, 0x30d8ae00, 0x30d94400, 0x30d9da00, 0x30da7000, 0x30db0600, 0x30db9c00, 0x30dc3200, 0x30dcc800, 0x30dd5e00, 0x30ddf400, 0x30de8a00, 0x30df2000,
    0x30dfb600, 0x30e04c00, 0x30e0e200, 0x30e17800, 0x30e20e00, 0x30e2a400, 0x30e33a00, 0x30e3d000, 0x30e46600, 0x30e4fc00, 0x30e59200, 0x30e62800, 0x30e6be00, 0x30e75400, 0x30e7ea00, 0x30e88000,
    0x30e91600, 0x30e9ac00, 0x30ea4200, 0x30ead800, 0x30eb6e00, 0x30ec0400, 0x30ec9a00, 0x30ed3000, 0x30edc600, 0x30ee5c00, 0x30eef200, 0x30ef8800, 0x30f01e00, 0x30f0b400, 0x30f14a00, 0x30f1e000,
    0x30f27600, 0x30f30c00, 0x30f3a200, 0x30f43800, 0x30f4ce00, 0x30f56400, 0x30f5fa00, 0x30f69000, 0x30f72600, 0x30f7bc00, 0x30f85200, 0x30f8e800, 0x30f97e00, 0x30fa1400, 0x30faaa00, 0x30fb4000,
    0x30fbd600, 0x30fc6c00, 0x30fd0200, 0x30fd9800, 0x30fe2e00, 0x30fec400, 0x30ff5a00, 0x30fff000, 0x31008600, 0x31011c00, 0x3101b200, 0x31024800, 0x3102de00, 0x31037400, 0x31040a00, 0x3104a000,
    0x31053600, 0x3105cc00, 0x31066200, 0x3106f800, 0x31078e00, 0x31082400, 0x3108ba00, 0x31095000, 0x3109e600, 0x310a7c00, 0x310b1200, 0x310ba800, 0x310c3e00, 0x310cd400, 0x310d6a00, 0x310e0000,
    0x310e9600, 0x310f2c00, 0x310fc200, 0x31105800, 0x3110ee00, 0x31118400, 0x31121a00, 0x3112b000, 0x31134600, 0x3113dc00, 0x31147200, 0x31150800, 0x31159e00, 0x31163400, 0x3116ca00, 0x31176000,
    0x3117f600, 0x31188c00, 0x31192200, 0x3119b800, 0x311a4e00, 0x311ae400, 0x311b7a00, 0x311c1000, 0x311ca600, 0x311d3c00, 0x311dd200, 0x311e6800, 0x311efe00, 0x311f9400, 0x31202a00, 0x3120c000,
    0x31215600, 0x3121ec00, 0x31228200, 0x31231800, 0x3123ae00, 0x31244400, 0x3124da00, 0x31257000, 0x31260600, 0x31269c00, 0x31273200, 0x3127c800, 0x31285e00, 0x3128f400, 0x31298a00, 0x312a2000,
    0x312ab600, 0x312b4c00, 0x312be200, 0x312c7800, 0x312d0e00, 0x312da400, 0x312e3a00, 0x312ed000, 0x312f6600, 0x312ffc00, 0x31309200, 0x31312800, 0x3131be00, 0x31325400, 0x3132ea00, 0x31338000,
    0x31341600, 0x3134ac00, 0x31354200, 0x3135d800, 0x31366e00, 0x31370400, 0x31379a00, 0x31383000, 0x3138c600, 0x31395c00, 0x3139f200, 0x313a8800, 0x313b1e00, 0x313bb400, 0x313c4a00, 0x313ce000,
    0x313d7600, 0x313e0c00, 0x313ea200, 0x313f3800, 0x313fce00, 0x31406300, 0x3140f900, 0x31418f00, 0x31422500, 0x3142bb00, 0x31435100, 0x3143e700, 0x31447d00, 0x31451300, 0x3145a900, 0x31463f00,
    0x3146d500, 0x31476b00, 0x31480100, 0x31489700, 0x31492d00, 0x3149c300, 0x314a5900, 0x314aef00, 0x314b8500, 0x314c1b00, 0x314cb100, 0x314d4700, 0x314ddd00, 0x314e7300, 0x314f0900, 0x314f9f00,
    0x31503500, 0x3150cb00, 0x31516100, 0x3151f700, 0x31528d00, 0x31532300, 0x3153b900, 0x31544f00, 0x3154e500, 0x31557b00, 0x31561100, 0x3156a700, 0x31573d00, 0x3157d300, 0x31586900, 0x3158ff00,
    0x31599500, 0x315a2b00, 0x315ac100, 0x315b5700, 0x315bed00, 0x315c8300, 0x315d1900, 0x315daf00, 0x315e4500, 0x315edb00, 0x315f7100, 0x31600700, 0x31609d00, 0x31613300, 0x3161c900, 0x31625f00,
    0x3162f500, 0x31638b00, 0x31642100, 0x3164b700, 0x31654d00, 0x3165e300, 0x31667900, 0x31670f00, 0x3167a500, 0x31683b00, 0x3168d100, 0x31696700, 0x3169fd00, 0x316a9300, 0x316b2900, 0x316bbf00,
    0x316c5500, 0x316ceb00, 0x316d8100, 0x316e1700, 0x316ead00, 0x316f4300, 0x316fd900, 0x31706f00, 0x31710500, 0x31719b00, 0x31723100, 0x3172c700, 0x31735d00, 0x3173f300, 0x31748900, 0x31751f00,
    0x3175b500, 0x31764b00, 0x3176e100, 0x31777700, 0x31780d00, 0x3178a300, 0x31793900, 0x3179cf00, 0x317a6500, 0x317afb00, 0x317b9100, 0x317c2700, 0x317cbd00, 0x317d5300, 0x317de900, 0x317e7f00,
    0x317f1500, 0x317fab00, 0x31804100, 0x3180d700, 0x31816d00, 0x31820300, 0x31829900, 0x31832f00, 0x3183c500, 0x31845b00, 0x3184f100, 0x31858700, 0x31861d00, 0x3186b300, 0x31874900, 0x3187df00,
    0x31887500, 0x31890b00, 0x3189a100, 0x318a3700, 0x318acd00, 0x318b6300, 0x318bf900, 0x318c8f00, 0x318d2500, 0x318dbb00, 0x318e5100, 0x318ee700, 0x318f7d00, 0x31901300, 0x3190a900, 0x31913f00,
    0x3191d500, 0x31926b00, 0x31930100, 0x31939700, 0x31942d00, 0x3194c300, 0x31955900, 0x3195ef00, 0x31968500, 0x31971b00, 0x3197b100, 0x31984700, 0x3198dd00, 0x31997300, 0x319a0900, 0x319a9f00,
    0x319b3500, 0x319bcb00, 0x319c6100, 0x319cf700, 0x319d8d00, 0x319e2300, 0x319eb900, 0x319f4f00, 0x319fe500, 0x31a07b00, 0x31a11100, 0x31a1a700, 0x31a23d00, 0x31a2d300, 0x31a36900, 0x31a3ff00,
    0x31a49500, 0x31a52b00, 0x31a5c100, 0x31a65700, 0x31a6ed00, 0x31a78300, 0x31a81900, 0x31a8af00, 0x31a94500, 0x31a9db00, 0x31aa7100, 0x31ab0700, 0x31ab9d00, 0x31ac3300, 0x31acc900, 0x31ad5f00,
    0x31adf500, 0x31ae8b00, 0x31af2100, 0x31afb700, 0x31b04d00, 0x31b0e300, 0x31b17900, 0x31b20f00, 0x31b2a500, 0x31b33b00, 0x31b3d100, 0x31b46700, 0x31b4fd00, 0x31b59300, 0x31b62900, 0x31b6bf00,
    0x31b75500, 0x31b7eb00, 0x31b88100, 0x31b91700, 0x31b9ad00, 0x31ba4300, 0x31bad900, 0x31bb6f00, 0x31bc0500, 0x31bc9b00, 0x31bd3100, 0x31bdc700, 0x31be5d00, 0x31bef300, 0x31bf8900, 0x31c01f00,
    0x31c0b500, 0x31c14b00, 0x31c1e100, 0x31c27700, 0x31c30d00, 0x31c3a300, 0x31c43900, 0x31c4cf00, 0x31c56500, 0x31c5fb00, 0x31c69100, 0x31c72700, 0x31c7bd00, 0x31c85300, 0x31c8e900, 0x31c97f00,
    0x31ca1500, 0x31caab00, 0x31cb4100, 0x31cbd700, 0x31cc6d00, 0x31cd0300, 0x31cd9900, 0x31ce2f00, 0x31cec500, 0x31cf5b00, 0x31cff100, 0x31d08700, 0x31d11d00, 0x31d1b300, 0x31d24900, 0x31d2df00,
    0x31d37500, 0x31d40b00, 0x31d4a100, 0x31d53700, 0x31d5cd00, 0x31d66300, 0x31d6f900, 0x31d78f00, 0x31d82500, 0x31d8bb00, 0x31d95100, 0x31d9e700, 0x31da7d00, 0x31db1300, 0x31dba900, 0x31dc3f00,
    0x31dcd500, 0x31dd6b00, 0x31de0100, 0x31de9700, 0x31df2d00, 0x31dfc300, 0x31e05900, 0x31e0ef00, 0x31e18500, 0x31e21b00, 0x31e2b100, 0x31e34700, 0x31e3dd00, 0x31e47300, 0x31e50900, 0x31e59f00,
    0x31e63500, 0x31e6cb00, 0x31e76100, 0x31e7f700, 0x31e88d00, 0x31e92300, 0x31e9b900, 0x31ea4f00, 0x31eae500, 0x31eb7b00, 0x31ec1100, 0x31eca700, 0x31ed3d00, 0x31edd300, 0x31ee6900, 0x31eeff00,
    0x31ef9500, 0x31f02b00, 0x31f0c100, 0x31f15700, 0x31f1ed00, 0x31f28300, 0x31f31900, 0x31f3af00, 0x31f44500, 0x31f4db00, 0x31f57100, 0x31f60700, 0x31f69d00, 0x31f73300, 0x31f7c900, 0x31f85f00,
    0x31f8f500, 0x31f98b00, 0x31fa2100, 0x31fab700, 0x31fb4d00, 0x31fbe300, 0x31fc7900, 0x31fd0f00, 0x31fda500, 0x31fe3b00, 0x31fed100, 0x31ff6700, 0x31fffd00, 0x32009300, 0x32012900, 0x3201bf00,
    0x32025500, 0x3202eb00, 0x32038100, 0x32041700, 0x3204ad00, 0x32054300, 0x3205d900, 0x32066f00, 0x32070500, 0x32079b00, 0x32083100, 0x3208c700, 0x32095d00, 0x3209f300, 0x320a8900, 0x320b1f00,
    0x320bb500, 0x320c4b00, 0x320ce100, 0x320d7700, 0x320e0d00, 0x320ea300, 0x320f3900, 0x320fcf00, 0x32106500, 0x3210fb00, 0x32119100, 0x32122700, 0x3212bd00, 0x32135300, 0x3213e900, 0x32147f00,
    0x32151500, 0x3215ab00, 0x32164100, 0x3216d700, 0x32176d00, 0x32180300, 0x32189900, 0x32192f00, 0x3219c500, 0x321a5b00, 0x321af100, 0x321b8700, 0x321c1d00, 0x321cb300, 0x321d4900, 0x321ddf00,
    0x321e7500, 0x321f0b00, 0x321fa100, 0x32203700, 0x3220cd00, 0x32216300, 0x3221f900, 0x32228f00, 0x32232500, 0x3223bb00, 0x32245100, 0x3224e700, 0x32257d00, 0x32261300, 0x3226a900, 0x32273f00,
    0x3227d500, 0x32286b00, 0x32290100, 0x32299700, 0x322a2d00, 0x322ac300, 0x322b5900, 0x322bef00, 0x322c8500, 0x322d1b00, 0x322db100, 0x322e4700, 0x322edd00, 0x322f7300, 0x32300900, 0x32309f00,
    0x32313500, 0x3231cb00, 0x32326100, 0x3232f700, 0x32338d00, 0x32342300, 0x3234b900, 0x32354f00, 0x3235e500, 0x32367b00, 0x32371100, 0x3237a700, 0x32383d00, 0x3238d300, 0x32396900, 0x3239ff00,
    0x323aa400, 0x323b4900, 0x323bee00, 0x323c9300, 0x323d3800, 0x323ddd00, 0x323e8200, 0x323f2700, 0x323fcc00, 0x32407100, 0x32411600, 0x3241bb00, 0x32426000, 0x32430500, 0x3243aa00, 0x32444f00,
    0x3244f400, 0x32459900, 0x32463e00, 0x3246e300, 0x32478800, 0x32482d00, 0x3248d200, 0x32497700, 0x324a1c00, 0x324ac100, 0x324b6600, 0x324c0b00, 0x324cb000, 0x324d5500, 0x324dfa00, 0x324e9f00,
    0x324f4400, 0x324fe900, 0x32508e00, 0x32513300, 0x3251d800, 0x32527d00, 0x32532200, 0x3253c700, 0x32546c00, 0x32551100, 0x3255b600, 0x32565b00, 0x32570000, 0x3257a500, 0x32584a00, 0x3258ef00,
    0x32599400, 0x325a3900, 0x325ade00, 0x325b8300, 0x325c2800, 0x325ccd00, 0x325d7200, 0x325e1700, 0x325ebc00, 0x325f6100, 0x32600600, 0x3260ab00, 0x32615000, 0x3261f500, 0x32629a00, 0x32633f00,
    0x3263e400, 0x32648900, 0x32652e00, 0x3265d300, 0x32667800, 0x32671d00, 0x3267c200, 0x32686700, 0x32690c00, 0x3269b100, 0x326a5600, 0x326afb00, 0x326ba000, 0x326c4500, 0x326cea00, 0x326d8f00,
    0x326e3400, 0x326ed900, 0x326f7e00, 0x32702300, 0x3270c800, 0x32716d00, 0x32721200, 0x3272b700, 0x32735c00, 0x32740100, 0x3274a600, 0x32754b00, 0x3275f000, 0x32769500, 0x32773a00, 0x3277df00,
    0x32788400, 0x32792900, 0x3279ce00, 0x327a7300, 0x327b1800, 0x327bbd00, 0x327c6200, 0x327d0700, 0x327dac00, 0x327e5100, 0x327ef600, 0x327f9b00, 0x32804000, 0x3280e500, 0x32818a00, 0x32822f00,
    0x3282d400, 0x32837900, 0x32841e00, 0x3284c300, 0x32856800, 0x32860d00, 0x3286b200, 0x32875700, 0x3287fc00, 0x3288a100, 0x32894600, 0x3289eb00, 0x328a9000, 0x328b3500, 0x328bda00, 0x328c7f00,
    0x328d2400, 0x328dc900, 0x328e6e00, 0x328f1300, 0x328fb800, 0x32905d00, 0x32910200, 0x3291a700, 0x32924c00, 0x3292f100, 0x32939600, 0x32943b00, 0x3294e000, 0x32958500, 0x32962a00, 0x3296cf00,
    0x32977400, 0x32981900, 0x3298be00, 0x32996300, 0x329a0800, 0x329aad00, 0x329b5200, 0x329bf700, 0x329c9c00, 0x329d4100, 0x329de600, 0x329e8b00, 0x329f3000, 0x329fd500, 0x32a07a00, 0x32a11f00,
    0x32a1c400, 0x32a26900, 0x32a30e00, 0x32a3b300, 0x32a45800, 0x32a4fd00, 0x32a5a200, 0x32a64700, 0x32a6ec00, 0x32a79100, 0x32a83600, 0x32a8db00, 0x32a98000, 0x32aa2500, 0x32aaca00, 0x32ab6f00,
    0x32ac1400, 0x32acb900, 0x32ad5e00, 0x32ae0300, 0x32aea800, 0x32af4d00, 0x32aff200, 0x32b09700, 0x32b13c00, 0x32b1e100, 0x32b28600, 0x32b32b00, 0x32b3d000, 0x32b47500, 0x32b51a00, 0x32b5bf00,
    0x32b66400, 0x32b70900, 0x32b7ae00, 0x32b85300, 0x32b8f800, 0x32b99d00, 0x32ba4200, 0x32bae700, 0x32bb8c00, 0x32bc3100, 0x32bcd600, 0x32bd7b00, 0x32be2000, 0x32bec500, 0x32bf6a00, 0x32c00f00,
    0x32c0b400, 0x32c15900, 0x32c1fe00, 0x32c2a300, 0x32c34800, 0x32c3ed00, 0x32c49200, 0x32c53700, 0x32c5dc00, 0x32c68100, 0x32c72600, 0x32c7cb00, 0x32c87000, 0x32c91500, 0x32c9ba00, 0x32ca5f00,
    0x32cb0400, 0x32cba900, 0x32cc4e00, 0x32ccf300, 0x32cd9800, 0x32ce3d00, 0x32cee200, 0x32cf8700, 0x32d02c00, 0x32d0d100, 0x32d17600, 0x32d21b00, 0x32d2c000, 0x32d36500, 0x32d40a00, 0x32d4af00,
    0x32d55400, 0x32d5f900, 0x32d69e00, 0x32d74300, 0x32d7e800, 0x32d88d00, 0x32d93200, 0x32d9d700, 0x32da7c00, 0x32db2100, 0x32dbc600, 0x32dc6b00, 0x32dd1000, 0x32ddb500, 0x32de5a00, 0x32deff00,
    0x32dfa400, 0x32e04900, 0x32e0ee00, 0x32e19300, 0x32e23800, 0x32e2dd00, 0x32e38200, 0x32e42700, 0x32e4cc00, 0x32e57100, 0x32e61600, 0x32e6bb00, 0x32e76000, 0x32e80500, 0x32e8aa00, 0x32e94f00,
    0x32e9f400, 0x32ea9900, 0x32eb3e00, 0x32ebe300, 0x32ec8800, 0x32ed2d00, 0x32edd200, 0x32ee7700, 0x32ef1c00, 0x32efc100, 0x32f06600, 0x32f10b00, 0x32f1b000, 0x32f25500, 0x32f2fa00, 0x32f39f00,
    0x32f44400, 0x32f4e900, 0x32f58e00, 0x32f63300, 0x32f6d800, 0x32f77d00, 0x32f82200, 0x32f8c700, 0x32f96c00, 0x32fa1100, 0x32fab600, 0x32fb5b00, 0x32fc0000, 0x32fca500, 0x32fd4a00, 0x32fdef00,
    0x32fe9400, 0x32ff3900, 0x32ffde00, 0x33008300, 0x33012800, 0x3301cd00, 0x33027200, 0x33031700, 0x3303bc00, 0x33046100, 0x33050600, 0x3305ab00, 0x33065000, 0x3306f500, 0x33079a00, 0x33083f00,
    0x3308e400, 0x33098900, 0x330a2e00, 0x330ad300, 0x330b7800, 0x330c1d00, 0x330cc200, 0x330d6700, 0x330e0c00, 0x330eb100, 0x330f5600, 0x330ffb00, 0x3310a000, 0x33114500, 0x3311ea00, 0x33128f00,
    0x33133400, 0x3313d900, 0x33147e00, 0x33152300, 0x3315c800, 0x33166d00, 0x33171200, 0x3317b700, 0x33185c00, 0x33190100, 0x3319a600, 0x331a4b00, 0x331af000, 0x331b9500, 0x331c3a00, 0x331cdf00,
    0x331d8400, 0x331e2900, 0x331ece00, 0x331f7300, 0x33201800, 0x3320bd00, 0x33216200, 0x33220700, 0x3322ac00, 0x33235100, 0x3323f600, 0x33249b00, 0x33254000, 0x3325e500, 0x33268a00, 0x33272f00,
    0x3327d400, 0x33287900, 0x33291e00, 0x3329c300, 0x332a6800, 0x332b0d00, 0x332bb200, 0x332c5700, 0x332cfc00, 0x332da100, 0x332e4600, 0x332eeb00, 0x332f9000, 0x33303500, 0x3330da00, 0x33317f00,
    0x33322400, 0x3332c900, 0x33336e00, 0x33341300, 0x3334b800, 0x33355d00, 0x33360200, 0x3336a700, 0x33374c00, 0x3337f100, 0x33389600, 0x33393b00, 0x3339e000, 0x333a8500, 0x333b2a00, 0x333bcf00,
    0x333c7400, 0x333d1900, 0x333dbe00, 0x333e6300, 0x333f0800, 0x333fad00, 0x33405200, 0x3340f700, 0x33419c00, 0x33424100, 0x3342e600, 0x33438b00, 0x33443000, 0x3344d500, 0x33457a00, 0x33461f00,
    0x3346c400, 0x33476900, 0x33480e00, 0x3348b300, 0x33495800, 0x3349fd00, 0x334aa200, 0x334b4700, 0x334bec00, 0x334c9100, 0x334d3600, 0x334ddb00, 0x334e8000, 0x334f2500, 0x334fca00, 0x33506f00,
    0x33511400, 0x3351b900, 0x33525e00, 0x33530300, 0x3353a800, 0x33544d00, 0x3354f200, 0x33559700, 0x33563c00, 0x3356e100, 0x33578600, 0x33582b00, 0x3358d000, 0x33597500, 0x335a1a00, 0x335abf00,
    0x335b6400, 0x335c0900, 0x335cae00, 0x335d5300, 0x335df800, 0x335e9d00, 0x335f4200, 0x335fe700, 0x33608c00, 0x33613100, 0x3361d600, 0x33627b00, 0x33632000, 0x3363c500, 0x33646a00, 0x33650f00,
    0x3365b400, 0x33665900, 0x3366fe00, 0x3367a300, 0x33684800, 0x3368ed00, 0x33699200, 0x336a3700, 0x336adc00, 0x336b8100, 0x336c2600, 0x336ccb00, 0x336d7000, 0x336e1500, 0x336eba00, 0x336f5f00,
    0x33700400, 0x3370a900, 0x33714e00, 0x3371f300, 0x33729800, 0x33733d00, 0x3373e200, 0x33748700, 0x33752c00, 0x3375d100, 0x33767600, 0x33771b00, 0x3377c000, 0x33786500, 0x33790a00, 0x3379af00,
    0x337a5400, 0x337af900, 0x337b9e00, 0x337c4300, 0x337ce800, 0x337d8d00, 0x337e3200, 0x337ed700, 0x337f7c00, 0x33802100, 0x3380c600, 0x33816b00, 0x33821000, 0x3382b500, 0x33835a00, 0x3383ff00,
    0x3384a700, 0x33854f00, 0x3385f700, 0x33869f00, 0x33874700, 0x3387ef00, 0x33889700, 0x33893f00, 0x3389e700, 0x338a8f00, 0x338b3700, 0x338bdf00, 0x338c8700, 0x338d2f00, 0x338dd700, 0x338e7f00,
    0x338f2700, 0x338fcf00, 0x33907700, 0x33911f00, 0x3391c700, 0x33926f00, 0x33931700, 0x3393bf00, 0x33946700, 0x33950f00, 0x3395b700, 0x33965f00, 0x33970700, 0x3397af00, 0x33985700, 0x3398ff00,
    0x3399a700, 0x339a4f00, 0x339af700, 0x339b9f00, 0x339c4700, 0x339cef00, 0x339d9700, 0x339e3f00, 0x339ee700, 0x339f8f00, 0x33a03700, 0x33a0df00, 0x33a18700, 0x33a22f00, 0x33a2d700, 0x33a37f00,
    0x33a42700, 0x33a4cf00, 0x33a57700, 0x33a61f00, 0x33a6c700, 0x33a76f00, 0x33a81700, 0x33a8bf00, 0x33a96700, 0x33aa0f00, 0x33aab700, 0x33ab5f00, 0x33ac0700, 0x33acaf00, 0x33ad5700, 0x33adff00,
    0x33aea700, 0x33af4f00, 0x33aff700, 0x33b09f00, 0x33b14700, 0x33b1ef00, 0x33b29700, 0x33b33f00, 0x33b3e700, 0x33b48f00, 0x33b53700, 0x33b5df00, 0x33b68700, 0x33b72f00, 0x33b7d700, 0x33b87f00,
    0x33b92700, 0x33b9cf00, 0x33ba7700, 0x33bb1f00, 0x33bbc700, 0x33bc6f00, 0x33bd1700, 0x33bdbf00, 0x33be6700, 0x33bf0f00, 0x33bfb700, 0x33c05f00, 0x33c10700, 0x33c1af00, 0x33c25700, 0x33c2ff00,
    0x33c3a700, 0x33c44f00, 0x33c4f700, 0x33c59f00, 0x33c64700, 0x33c6ef00, 0x33c79700, 0x33c83f00, 0x33c8e700, 0x33c98f00, 0x33ca3700, 0x33cadf00, 0x33cb8700, 0x33cc2f00, 0x33ccd700, 0x33cd7f00,
    0x33ce2700, 0x33cecf00, 0x33cf7700, 0x33d01f00, 0x33d0c700, 0x33d16f00, 0x33d21700, 0x33d2bf00, 0x33d36700, 0x33d40f00, 0x33d4b700, 0x33d55f00, 0x33d60700, 0x33d6af00, 0x33d75700, 0x33d80000,
    0x33d8a800, 0x33d95000, 0x33d9f800, 0x33daa000, 0x33db4800, 0x33dbf000, 0x33dc9800, 0x33dd4000, 0x33dde800, 0x33de9000, 0x33df3800, 0x33dfe000, 0x33e08800, 0x33e13000, 0x33e1d800, 0x33e28000,
    0x33e32800, 0x33e3d000, 0x33e47800, 0x33e52000, 0x33e5c800, 0x33e67000, 0x33e71800, 0x33e7c000, 0x33e86800, 0x33e91000, 0x33e9b800, 0x33ea6000, 0x33eb0800, 0x33ebb000, 0x33ec5800, 0x33ed0000,
    0x33eda800, 0x33ee5000, 0x33eef800, 0x33efa000, 0x33f04800, 0x33f0f000, 0x33f19800, 0x33f24000, 0x33f2e800, 0x33f39000, 0x33f43800, 0x33f4e000, 0x33f58800, 0x33f63000, 0x33f6d800, 0x33f78000,
    0x33f82800, 0x33f8d000, 0x33f97800, 0x33fa2000, 0x33fac800, 0x33fb7000, 0x33fc1800, 0x33fcc000, 0x33fd6800, 0x33fe1000, 0x33feb800, 0x33ff6000, 0x34000800, 0x3400b000, 0x34015800, 0x34020000,
    0x3402a800, 0x34035000, 0x3403f800, 0x3404a000, 0x34054800, 0x3405f000, 0x34069800, 0x34074000, 0x3407e800, 0x34089000, 0x34093800, 0x3409e000, 0x340a8800, 0x340b3000, 0x340bd800, 0x340c8000,
    0x340d2800, 0x340dd000, 0x340e7800, 0x340f2000, 0x340fc800, 0x34107000, 0x34111800, 0x3411c000, 0x34126800, 0x34131000, 0x3413b800, 0x34146000, 0x34150800, 0x3415b000, 0x34165800, 0x34170000,
    0x3417a800, 0x34185000, 0x3418f800, 0x3419a000, 0x341a4800, 0x341af000, 0x341b9800, 0x341c4000, 0x341ce800, 0x341d9000, 0x341e3800, 0x341ee000, 0x341f8800, 0x34203000, 0x3420d800, 0x34218000,
    0x34222800, 0x3422d000, 0x34237800, 0x34242000, 0x3424c800, 0x34257000, 0x34261800, 0x3426c000, 0x34276800, 0x34281000, 0x3428b800, 0x34296000, 0x342a0800, 0x342ab000, 0x342b5800, 0x342c0000,
    0x342ca800, 0x342d5000, 0x342df800, 0x342ea000, 0x342f4800, 0x342ff000, 0x34309800, 0x34314000, 0x3431e800, 0x34329000, 0x34333800, 0x3433e000, 0x34348800, 0x34353000, 0x3435d800, 0x34368000,
    0x34372800, 0x3437d000, 0x34387800, 0x34392000, 0x3439c800, 0x343a7000, 0x343b1800, 0x343bc000, 0x343c6800, 0x343d1000, 0x343db800, 0x343e6000, 0x343f0800, 0x343fb000, 0x34405800, 0x34410000,
    0x3441a800, 0x34425000, 0x3442f800, 0x3443a000, 0x34444800, 0x3444f000, 0x34459800, 0x34464000, 0x3446e800, 0x34479000, 0x34483800, 0x3448e000, 0x34498800, 0x344a3000, 0x344ad800, 0x344b8000,
    0x344c2800, 0x344cd000, 0x344d7800, 0x344e2000, 0x344ec800, 0x344f7000, 0x34501800, 0x3450c000, 0x34516800, 0x34521000, 0x3452b800, 0x34536000, 0x34540800, 0x3454b000, 0x34555800, 0x34560000,
    0x3456a800, 0x34575000, 0x3457f800, 0x3458a000, 0x34594800, 0x3459f000, 0x345a9800, 0x345b4000, 0x345be800, 0x345c9000, 0x345d3800, 0x345de000, 0x345e8800, 0x345f3000, 0x345fd800, 0x34608000,
    0x34612800, 0x3461d000, 0x34627800, 0x34632000, 0x3463c800, 0x34647000, 0x34651800, 0x3465c000, 0x34666800, 0x34671000, 0x3467b800, 0x34686000, 0x34690800, 0x3469b000, 0x346a5800, 0x346b0000,
    0x346ba800, 0x346c5000, 0x346cf800, 0x346da000, 0x346e4800, 0x346ef000, 0x346f9800, 0x34704000, 0x3470e800, 0x34719000, 0x34723800, 0x3472e000, 0x34738800, 0x34743000, 0x3474d800, 0x34758000,
    0x34762800, 0x3476d000, 0x34777800, 0x34782000, 0x3478c800, 0x34797000, 0x347a1800, 0x347ac000, 0x347b6800, 0x347c1000, 0x347cb800, 0x347d6000, 0x347e0800, 0x347eb000, 0x347f5800, 0x34800000,
    0x3480a800, 0x34815000, 0x3481f800, 0x3482a000, 0x34834800, 0x3483f000, 0x34849800, 0x34854000, 0x3485e800, 0x34869000, 0x34873800, 0x3487e000, 0x34888800, 0x34893000, 0x3489d800, 0x348a8000,
    0x348b2800, 0x348bd000, 0x348c7800, 0x348d2000, 0x348dc800, 0x348e7000, 0x348f1800, 0x348fc000, 0x34906800, 0x34911000, 0x3491b800, 0x34926000, 0x34930800, 0x3493b000, 0x34945800, 0x34950000,
    0x3495a800, 0x34965000, 0x3496f800, 0x3497a000, 0x34984800, 0x3498f000, 0x34999800, 0x349a4000, 0x349ae800, 0x349b9000, 0x349c3800, 0x349ce000, 0x349d8800, 0x349e3000, 0x349ed800, 0x349f8000,
    0x34a02800, 0x34a0d000, 0x34a17800, 0x34a22000, 0x34a2c800, 0x34a37000, 0x34a41800, 0x34a4c000, 0x34a56800, 0x34a61000, 0x34a6b800, 0x34a76000, 0x34a80800, 0x34a8b000, 0x34a95800, 0x34aa0000,
    0x34aaa800, 0x34ab5000, 0x34abf800, 0x34aca000, 0x34ad4800, 0x34adf000, 0x34ae9800, 0x34af4000, 0x34afe800, 0x34b09000, 0x34b13800, 0x34b1e000, 0x34b28800, 0x34b33000, 0x34b3d800, 0x34b48000,
    0x34b52800, 0x34b5d000, 0x34b67800, 0x34b72000, 0x34b7c800, 0x34b87000, 0x34b91800, 0x34b9c000, 0x34ba6800, 0x34bb1000, 0x34bbb800, 0x34bc6000, 0x34bd0800, 0x34bdb000, 0x34be5800, 0x34bf0000,
    0x34bfa800, 0x34c05000, 0x34c0f800, 0x34c1a000, 0x34c24800, 0x34c2f000, 0x34c39800, 0x34c44000, 0x34c4e800, 0x34c59000, 0x34c63800, 0x34c6e000, 0x34c78800, 0x34c83000, 0x34c8d800, 0x34c98000,
    0x34ca2800, 0x34cad000, 0x34cb7800, 0x34cc2000, 0x34ccc800, 0x34cd7000, 0x34ce1800, 0x34cec000, 0x34cf6800, 0x34d01000, 0x34d0b800, 0x34d16000, 0x34d20800, 0x34d2b000, 0x34d35800, 0x34d40000,
    0x34d4bb00, 0x34d57600, 0x34d63100, 0x34d6ec00, 0x34d7a700, 0x34d86200, 0x34d91d00, 0x34d9d800, 0x34da9300, 0x34db4e00, 0x34dc0900, 0x34dcc400, 0x34dd7f00, 0x34de3a00, 0x34def500, 0x34dfb000,
    0x34e06b00, 0x34e12600, 0x34e1e100, 0x34e29c00, 0x34e35700, 0x34e41200, 0x34e4cd00, 0x34e58800, 0x34e64300, 0x34e6fe00, 0x34e7b900, 0x34e87400, 0x34e92f00, 0x34e9ea00, 0x34eaa500, 0x34eb6000,
    0x34ec1b00, 0x34ecd600, 0x34ed9100, 0x34ee4c00, 0x34ef0700, 0x34efc200, 0x34f07d00, 0x34f13800, 0x34f1f300, 0x34f2ae00, 0x34f36900, 0x34f42400, 0x34f4df00, 0x34f59a00, 0x34f65500, 0x34f71000,
    0x34f7cb00, 0x34f88600, 0x34f94100, 0x34f9fc00, 0x34fab700, 0x34fb7200, 0x34fc2d00, 0x34fce800, 0x34fda300, 0x34fe5e00, 0x34ff1900, 0x34ffd400, 0x35008f00, 0x35014a00, 0x35020500, 0x3502c000,
    0x35037b00, 0x35043600, 0x3504f100, 0x3505ac00, 0x35066700, 0x35072200, 0x3507dd00, 0x35089800, 0x35095300, 0x350a0e00, 0x350ac900, 0x350b8400, 0x350c3f00, 0x350cfa00, 0x350db500, 0x350e7000,
    0x350f2b00, 0x350fe600, 0x3510a100, 0x35115c00, 0x35121700, 0x3512d200, 0x35138d00, 0x35144800, 0x35150300, 0x3515be00, 0x35167900, 0x35173400, 0x3517ef00, 0x3518aa00, 0x35196500, 0x351a2000,
    0x351adb00, 0x351b9600, 0x351c5100, 0x351d0c00, 0x351dc700, 0x351e8200, 0x351f3d00, 0x351ff800, 0x3520b300, 0x35216e00, 0x35222900, 0x3522e400, 0x35239f00, 0x35245a00, 0x35251500, 0x3525d000,
    0x35268b00, 0x35274600, 0x35280100, 0x3528bc00, 0x35297700, 0x352a3200, 0x352aed00, 0x352ba800, 0x352c6300, 0x352d1e00, 0x352dd900, 0x352e9400, 0x352f4f00, 0x35300a00, 0x3530c500, 0x35318000,
    0x35323b00, 0x3532f600, 0x3533b100, 0x35346c00, 0x35352700, 0x3535e200, 0x35369d00, 0x35375800, 0x35381300, 0x3538ce00, 0x35398900, 0x353a4400, 0x353aff00, 0x353bba00, 0x353c7500, 0x353d3000,
    0x353deb00, 0x353ea600, 0x353f6100, 0x35401c00, 0x3540d700, 0x35419200, 0x35424d00, 0x35430800, 0x3543c300, 0x35447e00, 0x35453900, 0x3545f400, 0x3546af00, 0x35476a00, 0x35482500, 0x3548e000,
    0x35499b00, 0x354a5600, 0x354b1100, 0x354bcc00, 0x354c8700, 0x354d4200, 0x354dfd00, 0x354eb800, 0x354f7300, 0x35502e00, 0x3550e900, 0x3551a400, 0x35525f00, 0x35531a00, 0x3553d500, 0x35549000,
    0x35554b00, 0x35560600, 0x3556c100, 0x35577c00, 0x35583700, 0x3558f200, 0x3559ad00, 0x355a6800, 0x355b2300, 0x355bde00, 0x355c9900, 0x355d5400, 0x355e0f00, 0x355eca00, 0x355f8500, 0x35604000,
    0x3560fb00, 0x3561b600, 0x35627100, 0x35632c00, 0x3563e700, 0x3564a200, 0x35655d00, 0x35661800, 0x3566d300, 0x35678e00, 0x35684900, 0x35690400, 0x3569bf00, 0x356a7a00, 0x356b3500, 0x356bf000,
    0x356cab00, 0x356d6600, 0x356e2100, 0x356edc00, 0x356f9700, 0x35705200, 0x35710d00, 0x3571c800, 0x35728300, 0x35733e00, 0x3573f900, 0x3574b400, 0x35756f00, 0x35762a00, 0x3576e500, 0x3577a000,
    0x35785b00, 0x35791600, 0x3579d100, 0x357a8c00, 0x357b4700, 0x357c0200, 0x357cbd00, 0x357d7800, 0x357e3300, 0x357eee00, 0x357fa900, 0x35806400, 0x35811f00, 0x3581da00, 0x35829500, 0x35835000,
    0x35840b00, 0x3584c600, 0x35858100, 0x35863c00, 0x3586f700, 0x3587b200, 0x35886d00, 0x35892800, 0x3589e300, 0x358a9e00, 0x358b5900, 0x358c1400, 0x358ccf00, 0x358d8a00, 0x358e4500, 0x358f0000,
    0x358fbb00, 0x35907600, 0x35913100, 0x3591ec00, 0x3592a700, 0x35936200, 0x35941d00, 0x3594d800, 0x35959300, 0x35964e00, 0x35970900, 0x3597c400, 0x35987f00, 0x35993a00, 0x3599f500, 0x359ab000,
    0x359b6b00, 0x359c2600, 0x359ce100, 0x359d9c00, 0x359e5700, 0x359f1200, 0x359fcd00, 0x35a08800, 0x35a14300, 0x35a1fe00, 0x35a2b900, 0x35a37400, 0x35a42f00, 0x35a4ea00, 0x35a5a500, 0x35a66000,
    0x35a71b00, 0x35a7d600, 0x35a89100, 0x35a94c00, 0x35aa0700, 0x35aac200, 0x35ab7d00, 0x35ac3800, 0x35acf300, 0x35adae00, 0x35ae6900, 0x35af2400, 0x35afdf00, 0x35b09a00, 0x35b15500, 0x35b21000,
    0x35b2cb00, 0x35b38600, 0x35b44100, 0x35b4fc00, 0x35b5b700, 0x35b67200, 0x35b72d00, 0x35b7e800, 0x35b8a300, 0x35b95e00, 0x35ba1900, 0x35bad400, 0x35bb8f00, 0x35bc4a00, 0x35bd0500, 0x35bdc000,
    0x35be7b00, 0x35bf3600, 0x35bff100, 0x35c0ac00, 0x35c16700, 0x35c22200, 0x35c2dd00, 0x35c39800, 0x35c45300, 0x35c50e00, 0x35c5c900, 0x35c68400, 0x35c73f00, 0x35c7fa00, 0x35c8b500, 0x35c97000,
    0x35ca2b00, 0x35cae600, 0x35cba100, 0x35cc5c00, 0x35cd1700, 0x35cdd200, 0x35ce8d00, 0x35cf4800, 0x35d00300, 0x35d0be00, 0x35d17900, 0x35d23400, 0x35d2ef00, 0x35d3aa00, 0x35d46500, 0x35d52000,
    0x35d5db00, 0x35d69600, 0x35d75100, 0x35d80c00, 0x35d8c700, 0x35d98200, 0x35da3d00, 0x35daf800, 0x35dbb300, 0x35dc6e00, 0x35dd2900, 0x35dde400, 0x35de9f00, 0x35df5a00, 0x35e01500, 0x35e0d000,
    0x35e18b00, 0x35e24600, 0x35e30100, 0x35e3bc00, 0x35e47700, 0x35e53200, 0x35e5ed00, 0x35e6a800, 0x35e76300, 0x35e81e00, 0x35e8d900, 0x35e99400, 0x35ea4f00, 0x35eb0a00, 0x35ebc500, 0x35ec8000,
    0x35ed3b00, 0x35edf600, 0x35eeb100, 0x35ef6c00, 0x35f02700, 0x35f0e200, 0x35f19d00, 0x35f25800, 0x35f31300, 0x35f3ce00, 0x35f48900, 0x35f54400, 0x35f5ff00, 0x35f6ba00, 0x35f77500, 0x35f83000,
    0x35f8eb00, 0x35f9a600, 0x35fa6100, 0x35fb1c00, 0x35fbd700, 0x35fc9200, 0x35fd4d00, 0x35fe0800, 0x35fec300, 0x35ff7e00, 0x36003900, 0x3600f400, 0x3601af00, 0x36026a00, 0x36032500, 0x3603e000,
    0x36049b00, 0x36055600, 0x36061100, 0x3606cc00, 0x36078700, 0x36084200, 0x3608fd00, 0x3609b800, 0x360a7300, 0x360b2e00, 0x360be900, 0x360ca400, 0x360d5f00, 0x360e1a00, 0x360ed500, 0x360f9000,
    0x36104b00, 0x36110600, 0x3611c100, 0x36127c00, 0x36133700, 0x3613f200, 0x3614ad00, 0x36156800, 0x36162300, 0x3616de00, 0x36179900, 0x36185400, 0x36190f00, 0x3619ca00, 0x361a8500, 0x361b4000,
    0x361bfb00, 0x361cb600, 0x361d7100, 0x361e2c00, 0x361ee700, 0x361fa200, 0x36205d00, 0x36211800, 0x3621d300, 0x36228e00, 0x36234900, 0x36240400, 0x3624bf00, 0x36257a00, 0x36263500, 0x3626f000,
    0x3627ab00, 0x36286600, 0x36292100, 0x3629dc00, 0x362a9700, 0x362b5200, 0x362c0d00, 0x362cc800, 0x362d8300, 0x362e3e00, 0x362ef900, 0x362fb400, 0x36306f00, 0x36312a00, 0x3631e500, 0x3632a000,
    0x36335b00, 0x36341600, 0x3634d100, 0x36358c00, 0x36364700, 0x36370200, 0x3637bd00, 0x36387800, 0x36393300, 0x3639ee00, 0x363aa900, 0x363b6400, 0x363c1f00, 0x363cda00, 0x363d9500, 0x363e5000,
    0x363f0b00, 0x363fc600, 0x36408100, 0x36413c00, 0x3641f700, 0x3642b200, 0x36436d00, 0x36442800, 0x3644e300, 0x36459e00, 0x36465900, 0x36471400, 0x3647cf00, 0x36488a00, 0x36494500, 0x364a0000,
    0x364ac000, 0x364b8000, 0x364c4000, 0x364d0000, 0x364dc000, 0x364e8000, 0x364f4000, 0x36500000, 0x3650c000, 0x36518000, 0x36524000, 0x36530000, 0x3653c000, 0x36548000, 0x36554000, 0x36560000,
    0x3656c000, 0x36578000, 0x36584000, 0x36590000, 0x3659c000, 0x365a8000, 0x365b4000, 0x365c0000, 0x365cc000, 0x365d8000, 0x365e4000, 0x365f0000, 0x365fc000, 0x36608000, 0x36614000, 0x36620000,
    0x3662c000, 0x36638000, 0x36644000, 0x36650000, 0x3665c000, 0x36668000, 0x36674000, 0x36680000, 0x3668c000, 0x36698000, 0x366a4000, 0x366b0000, 0x366bc000, 0x366c8000, 0x366d4000, 0x366e0000,
    0x366ec000, 0x366f8000, 0x36704000, 0x36710000, 0x3671c000, 0x36728000, 0x36734000, 0x36740000, 0x3674c000, 0x36758000, 0x36764000, 0x36770000, 0x3677c000, 0x36788000, 0x36794000, 0x367a0000,
    0x367ac000, 0x367b8000, 0x367c4000, 0x367d0000, 0x367dc000, 0x367e8000, 0x367f4000, 0x36800000, 0x3680c000, 0x36818000, 0x36824000, 0x36830000, 0x3683c000, 0x36848000, 0x36854000, 0x36860000,
    0x3686c000, 0x36878000, 0x36884000, 0x36890000, 0x3689c000, 0x368a8000, 0x368b4000, 0x368c0000, 0x368cc000, 0x368d8000, 0x368e4000, 0x368f0000, 0x368fc000, 0x36908000, 0x36914000, 0x36920000,
    0x3692c000, 0x36938000, 0x36944000, 0x36950000, 0x3695c000, 0x36968000, 0x36974000, 0x36980000, 0x3698c000, 0x36998000, 0x369a4000, 0x369b0000, 0x369bc000, 0x369c8000, 0x369d4000, 0x369e0000,
    0x369ec000, 0x369f8000, 0x36a04000, 0x36a10000, 0x36a1c000, 0x36a28000, 0x36a34000, 0x36a40000, 0x36a4c000, 0x36a58000, 0x36a64000, 0x36a70000, 0x36a7c000, 0x36a88000, 0x36a94000, 0x36aa0000,
    0x36aac000, 0x36ab8000, 0x36ac4000, 0x36ad0000, 0x36adc000, 0x36ae8000, 0x36af4000, 0x36b00000, 0x36b0c000, 0x36b18000, 0x36b24000, 0x36b30000, 0x36b3c000, 0x36b48000, 0x36b54000, 0x36b60000,
    0x36b6c000, 0x36b78000, 0x36b84000, 0x36b90000, 0x36b9c000, 0x36ba8000, 0x36bb4000, 0x36bc0000, 0x36bcc000, 0x36bd8000, 0x36be4000, 0x36bf0000, 0x36bfc000, 0x36c08000, 0x36c14000, 0x36c20000,
    0x36c2c000, 0x36c38000, 0x36c44000, 0x36c50000, 0x36c5c000, 0x36c68000, 0x36c74000, 0x36c80000, 0x36c8c000, 0x36c98000, 0x36ca4000, 0x36cb0000, 0x36cbc000, 0x36cc8000, 0x36cd4000, 0x36ce0000,
    0x36cec000, 0x36cf8000, 0x36d04000, 0x36d10000, 0x36d1c000, 0x36d28000, 0x36d34000, 0x36d40000, 0x36d4c000, 0x36d58000, 0x36d64000, 0x36d70000, 0x36d7c000, 0x36d88000, 0x36d94000, 0x36da0000,
    0x36dac000, 0x36db8000, 0x36dc4000, 0x36dd0000, 0x36ddc000, 0x36de8000, 0x36df4000, 0x36e00000, 0x36e0c000, 0x36e18000, 0x36e24000, 0x36e30000, 0x36e3c000, 0x36e48000, 0x36e54000, 0x36e60000,
    0x36e6c000, 0x36e78000, 0x36e84000, 0x36e90000, 0x36e9c000, 0x36ea8000, 0x36eb4000, 0x36ec0000, 0x36ecc000, 0x36ed8000, 0x36ee4000, 0x36ef0000, 0x36efc000, 0x36f08000, 0x36f14000, 0x36f20000,
    0x36f2c000, 0x36f38000, 0x36f44000, 0x36f50000, 0x36f5c000, 0x36f68000, 0x36f74000, 0x36f80000, 0x36f8c000, 0x36f98000, 0x36fa4000, 0x36fb0000, 0x36fbc000, 0x36fc8000, 0x36fd4000, 0x36fe0000,
    0x36fec000, 0x36ff8000, 0x37004000, 0x37010000, 0x3701c000, 0x37028000, 0x37034000, 0x37040000, 0x3704c000, 0x37058000, 0x37064000, 0x37070000, 0x3707c000, 0x37088000, 0x37094000, 0x370a0000,
    0x370ac000, 0x370b8000, 0x370c4000, 0x370d0000, 0x370dc000, 0x370e8000, 0x370f4000, 0x37100000, 0x3710c000, 0x37118000, 0x37124000, 0x37130000, 0x3713c000, 0x37148000, 0x37154000, 0x37160000,
    0x3716c000, 0x37178000, 0x37184000, 0x37190000, 0x3719c000, 0x371a8000, 0x371b4000, 0x371c0000, 0x371cc000, 0x371d8000, 0x371e4000, 0x371f0000, 0x371fc000, 0x37208000, 0x37214000, 0x37220000,
    0x3722c000, 0x37238000, 0x37244000, 0x37250000, 0x3725c000, 0x37268000, 0x37274000, 0x37280000, 0x3728c000, 0x37298000, 0x372a4000, 0x372b0000, 0x372bc000, 0x372c8000, 0x372d4000, 0x372e0000,
    0x372ec000, 0x372f8000, 0x37304000, 0x37310000, 0x3731c000, 0x37328000, 0x37334000, 0x37340000, 0x3734c000, 0x37358000, 0x37364000, 0x37370000, 0x3737c000, 0x37388000, 0x37394000, 0x373a0000,
    0x373ac000, 0x373b8000, 0x373c4000, 0x373d0000, 0x373dc000, 0x373e8000, 0x373f4000, 0x37400000, 0x3740c000, 0x37418000, 0x37424000, 0x37430000, 0x3743c000, 0x37448000, 0x37454000, 0x37460000,
    0x3746c000, 0x37478000, 0x37484000, 0x37490000, 0x3749c000, 0x374a8000, 0x374b4000, 0x374c0000, 0x374cc000, 0x374d8000, 0x374e4000, 0x374f0000, 0x374fc000, 0x37508000, 0x37514000, 0x37520000,
    0x3752c000, 0x37538000, 0x37544000, 0x37550000, 0x3755c000, 0x37568000, 0x37574000, 0x37580000, 0x3758c000, 0x37598000, 0x375a4000, 0x375b0000, 0x375bc000, 0x375c8000, 0x375d4000, 0x375e0000,
    0x375ec000, 0x375f8000, 0x37604000, 0x37610000, 0x3761c000, 0x37628000, 0x37634000, 0x37640000, 0x3764c000, 0x37658000, 0x37664000, 0x37670000, 0x3767c000, 0x37688000, 0x37694000, 0x376a0000,
    0x376ac000, 0x376b8000, 0x376c4000, 0x376d0000, 0x376dc000, 0x376e8000, 0x376f4000, 0x37700000, 0x3770c000, 0x37718000, 0x37724000, 0x37730000, 0x3773c000, 0x37748000, 0x37754000, 0x37760000,
    0x3776c000, 0x37778000, 0x37784000, 0x37790000, 0x3779c000, 0x377a8000, 0x377b4000, 0x377c0000, 0x377cc000, 0x377d8000, 0x377e4000, 0x377f0000, 0x377fc000, 0x37808000, 0x37814000, 0x37820000,
    0x3782c000, 0x37838000, 0x37844000, 0x37850000, 0x3785c000, 0x37868000, 0x37874000, 0x37880000, 0x3788c000, 0x37898000, 0x378a4000, 0x378b0000, 0x378bc000, 0x378c8000, 0x378d4000, 0x378e0000,
    0x378ec000, 0x378f8000, 0x37904000, 0x37910000, 0x3791c000, 0x37928000, 0x37934000, 0x37940000, 0x3794c000, 0x37958000, 0x37964000, 0x37970000, 0x3797c000, 0x37988000, 0x37994000, 0x379a0000,
    0x379ac000, 0x379b8000, 0x379c4000, 0x379d0000, 0x379dc000, 0x379e8000, 0x379f4000, 0x37a00000, 0x37a0c000, 0x37a18000, 0x37a24000, 0x37a30000, 0x37a3c000, 0x37a48000, 0x37a54000, 0x37a60000,
    0x37a6c000, 0x37a78000, 0x37a84000, 0x37a90000, 0x37a9c000, 0x37aa8000, 0x37ab4000, 0x37ac0000, 0x37acc000, 0x37ad8000, 0x37ae4000, 0x37af0000, 0x37afc000, 0x37b08000, 0x37b14000, 0x37b20000,
    0x37b2c000, 0x37b38000, 0x37b44000, 0x37b50000, 0x37b5c000, 0x37b68000, 0x37b74000, 0x37b80000, 0x37b8c000, 0x37b98000, 0x37ba4000, 0x37bb0000, 0x37bbc000, 0x37bc8000, 0x37bd4000, 0x37be0000,
    0x37bec000, 0x37bf8000, 0x37c04000, 0x37c10000, 0x37c1c000, 0x37c28000, 0x37c34000, 0x37c40000, 0x37c4c000, 0x37c58000, 0x37c64000, 0x37c70000, 0x37c7c000, 0x37c88000, 0x37c94000, 0x37ca0000,
    0x37cad800, 0x37cbb000, 0x37cc8800, 0x37cd6000, 0x37ce3800, 0x37cf1000, 0x37cfe800, 0x37d0c000, 0x37d19800, 0x37d27000, 0x37d34800, 0x37d42000, 0x37d4f800, 0x37d5d000, 0x37d6a800, 0x37d78000,
    0x37d85800, 0x37d93000, 0x37da0800, 0x37dae000, 0x37dbb800, 0x37dc9000, 0x37dd6800, 0x37de4000, 0x37df1800, 0x37dff000, 0x37e0c800, 0x37e1a000, 0x37e27800, 0x37e35000, 0x37e42800, 0x37e50000,
    0x37e5d800, 0x37e6b000, 0x37e78800, 0x37e86000, 0x37e93800, 0x37ea1000, 0x37eae800, 0x37ebc000, 0x37ec9800, 0x37ed7000, 0x37ee4800, 0x37ef2000, 0x37eff800, 0x37f0d000, 0x37f1a800, 0x37f28000,
    0x37f35800, 0x37f43000, 0x37f50800, 0x37f5e000, 0x37f6b800, 0x37f79000, 0x37f86800, 0x37f94000, 0x37fa1800, 0x37faf000, 0x37fbc800, 0x37fca000, 0x37fd7800, 0x37fe5000, 0x37ff2800, 0x38000000,
    0x3800d800, 0x3801b000, 0x38028800, 0x38036000, 0x38043800, 0x38051000, 0x3805e800, 0x3806c000, 0x38079800, 0x38087000, 0x38094800, 0x380a2000, 0x380af800, 0x380bd000, 0x380ca800, 0x380d8000,
    0x380e5800, 0x380f3000, 0x38100800, 0x3810e000, 0x3811b800, 0x38129000, 0x38136800, 0x38144000, 0x38151800, 0x3815f000, 0x3816c800, 0x3817a000, 0x38187800, 0x38195000, 0x381a2800, 0x381b0000,
    0x381bd800, 0x381cb000, 0x381d8800, 0x381e6000, 0x381f3800, 0x38201000, 0x3820e800, 0x3821c000, 0x38229800, 0x38237000, 0x38244800, 0x38252000, 0x3825f800, 0x3826d000, 0x3827a800, 0x38288000,
    0x38295800, 0x382a3000, 0x382b0800, 0x382be000, 0x382cb800, 0x382d9000, 0x382e6800, 0x382f4000, 0x38301800, 0x3830f000, 0x3831c800, 0x3832a000, 0x38337800, 0x38345000, 0x38352800, 0x38360000,
    0x3836d800, 0x3837b000, 0x38388800, 0x38396000, 0x383a3800, 0x383b1000, 0x383be800, 0x383cc000, 0x383d9800, 0x383e7000, 0x383f4800, 0x38402000, 0x3840f800, 0x3841d000, 0x3842a800, 0x38438000,
    0x38445800, 0x38453000, 0x38460800, 0x3846e000, 0x3847b800, 0x38489000, 0x38496800, 0x384a4000, 0x384b1800, 0x384bf000, 0x384cc800, 0x384da000, 0x384e7800, 0x384f5000, 0x38502800, 0x38510000,
    0x3851d800, 0x3852b000, 0x38538800, 0x38546000, 0x38553800, 0x38561000, 0x3856e800, 0x3857c000, 0x38589800, 0x38597000, 0x385a4800, 0x385b2000, 0x385bf800, 0x385cd000, 0x385da800, 0x385e8000,
    0x385f5800, 0x38603000, 0x38610800, 0x3861e000, 0x3862b800, 0x38639000, 0x38646800, 0x38654000, 0x38661800, 0x3866f000, 0x3867c800, 0x3868a000, 0x38697800, 0x386a5000, 0x386b2800, 0x386c0000,
    0x386cd700, 0x386daf00, 0x386e8700, 0x386f5f00, 0x38703700, 0x38710f00, 0x3871e700, 0x3872bf00, 0x38739700, 0x38746f00, 0x38754700, 0x38761f00, 0x3876f700, 0x3877cf00, 0x3878a700, 0x38797f00,
    0x387a5700, 0x387b2f00, 0x387c0700, 0x387cdf00, 0x387db700, 0x387e8f00, 0x387f6700, 0x38803f00, 0x38811700, 0x3881ef00, 0x3882c700, 0x38839f00, 0x38847700, 0x38854f00, 0x38862700, 0x3886ff00,
    0x3887d700, 0x3888af00, 0x38898700, 0x388a5f00, 0x388b3700, 0x388c0f00, 0x388ce700, 0x388dbf00, 0x388e9700, 0x388f6f00, 0x38904700, 0x38911f00, 0x3891f700, 0x3892cf00, 0x3893a700, 0x38947f00,
    0x38955700, 0x38962f00, 0x38970700, 0x3897df00, 0x3898b700, 0x38998f00, 0x389a6700, 0x389b3f00, 0x389c1700, 0x389cef00, 0x389dc700, 0x389e9f00, 0x389f7700, 0x38a04f00, 0x38a12700, 0x38a1ff00,
    0x38a2d700, 0x38a3af00, 0x38a48700, 0x38a55f00, 0x38a63700, 0x38a70f00, 0x38a7e700, 0x38a8bf00, 0x38a99700, 0x38aa6f00, 0x38ab4700, 0x38ac1f00, 0x38acf700, 0x38adcf00, 0x38aea700, 0x38af7f00,
    0x38b05700, 0x38b12f00, 0x38b20700, 0x38b2df00, 0x38b3b700, 0x38b48f00, 0x38b56700, 0x38b63f00, 0x38b71700, 0x38b7ef00, 0x38b8c700, 0x38b99f00, 0x38ba7700, 0x38bb4f00, 0x38bc2700, 0x38bcff00,
    0x38bdd700, 0x38beaf00, 0x38bf8700, 0x38c05f00, 0x38c13700, 0x38c20f00, 0x38c2e700, 0x38c3bf00, 0x38c49700, 0x38c56f00, 0x38c64700, 0x38c71f00, 0x38c7f700, 0x38c8cf00, 0x38c9a700, 0x38ca7f00,
    0x38cb5700, 0x38cc2f00, 0x38cd0700, 0x38cddf00, 0x38ceb700, 0x38cf8f00, 0x38d06700, 0x38d13f00, 0x38d21700, 0x38d2ef00, 0x38d3c700, 0x38d49f00, 0x38d57700, 0x38d64f00, 0x38d72700, 0x38d7ff00,
    0x38d8d700, 0x38d9af00, 0x38da8700, 0x38db5f00, 0x38dc3700, 0x38dd0f00, 0x38dde700, 0x38debf00, 0x38df9700, 0x38e06f00, 0x38e14700, 0x38e21f00, 0x38e2f700, 0x38e3cf00, 0x38e4a700, 0x38e57f00,
    0x38e65700, 0x38e72f00, 0x38e80700, 0x38e8df00, 0x38e9b700, 0x38ea8f00, 0x38eb6700, 0x38ec3f00, 0x38ed1700, 0x38edef00, 0x38eec700, 0x38ef9f00, 0x38f07700, 0x38f14f00, 0x38f22700, 0x38f2ff00,
    0x38f3d700, 0x38f4af00, 0x38f58700, 0x38f65f00, 0x38f73700, 0x38f80f00, 0x38f8e700, 0x38f9bf00, 0x38fa9700, 0x38fb6f00, 0x38fc4700, 0x38fd1f00, 0x38fdf700, 0x38fecf00, 0x38ffa700, 0x39007f00,
    0x39015700, 0x39022f00, 0x39030700, 0x3903df00, 0x3904b700, 0x39058f00, 0x39066700, 0x39073f00, 0x39081700, 0x3908ef00, 0x3909c700, 0x390a9f00, 0x390b7700, 0x390c4f00, 0x390d2700, 0x390dff00,
    0x390ed700, 0x390faf00, 0x39108700, 0x39115f00, 0x39123700, 0x39130f00, 0x3913e700, 0x3914bf00, 0x39159700, 0x39166f00, 0x39174700, 0x39181f00, 0x3918f700, 0x3919cf00, 0x391aa700, 0x391b7f00,
    0x391c5700, 0x391d2f00, 0x391e0700, 0x391edf00, 0x391fb700, 0x39208f00, 0x39216700, 0x39223f00, 0x39231700, 0x3923ef00, 0x3924c700, 0x39259f00, 0x39267700, 0x39274f00, 0x39282700, 0x3928ff00,
    0x3929d700, 0x392aaf00, 0x392b8700, 0x392c5f00, 0x392d3700, 0x392e0f00, 0x392ee700, 0x392fbf00, 0x39309700, 0x39316f00, 0x39324700, 0x39331f00, 0x3933f700, 0x3934cf00, 0x3935a700, 0x39367f00,
    0x39375700, 0x39382f00, 0x39390700, 0x3939df00, 0x393ab700, 0x393b8f00, 0x393c6700, 0x393d3f00, 0x393e1700, 0x393eef00, 0x393fc700, 0x39409f00, 0x39417700, 0x39424f00, 0x39432700, 0x3943ff00,
    0x3944d700, 0x3945af00, 0x39468700, 0x39475f00, 0x39483700, 0x39490f00, 0x3949e700, 0x394abf00, 0x394b9700, 0x394c6f00, 0x394d4700, 0x394e1f00, 0x394ef700, 0x394fcf00, 0x3950a700, 0x39517f00,
    0x39525700, 0x39532f00, 0x39540700, 0x3954df00, 0x3955b700, 0x39568f00, 0x39576700, 0x39583f00, 0x39591700, 0x3959ef00, 0x395ac700, 0x395b9f00, 0x395c7700, 0x395d4f00, 0x395e2700, 0x395eff00,
    0x395fd700, 0x3960af00, 0x39618700, 0x39625f00, 0x39633700, 0x39640f00, 0x3964e700, 0x3965bf00, 0x39669700, 0x39676f00, 0x39684700, 0x39691f00, 0x3969f700, 0x396acf00, 0x396ba700, 0x396c7f00,
    0x396d5700, 0x396e2f00, 0x396f0700, 0x396fdf00, 0x3970b700, 0x39718f00, 0x39726700, 0x39733f00, 0x39741700, 0x3974ef00, 0x3975c700, 0x39769f00, 0x39777700, 0x39784f00, 0x39792700, 0x3979ff00,
    0x397ae900, 0x397bd300, 0x397cbd00, 0x397da700, 0x397e9100, 0x397f7b00, 0x39806500, 0x39814f00, 0x39823900, 0x39832300, 0x39840d00, 0x3984f700, 0x3985e100, 0x3986cb00, 0x3987b500, 0x39889f00,
    0x39898900, 0x398a7300, 0x398b5d00, 0x398c4700, 0x398d3100, 0x398e1b00, 0x398f0500, 0x398fef00, 0x3990d900, 0x3991c300, 0x3992ad00, 0x39939700, 0x39948100, 0x39956b00, 0x39965500, 0x39973f00,
    0x39982900, 0x39991300, 0x3999fd00, 0x399ae700, 0x399bd100, 0x399cbb00, 0x399da500, 0x399e8f00, 0x399f7900, 0x39a06300, 0x39a14d00, 0x39a23700, 0x39a32100, 0x39a40b00, 0x39a4f500, 0x39a5df00,
    0x39a6c900, 0x39a7b300, 0x39a89d00, 0x39a98700, 0x39aa7100, 0x39ab5b00, 0x39ac4500, 0x39ad2f00, 0x39ae1900, 0x39af0300, 0x39afed00, 0x39b0d700, 0x39b1c100, 0x39b2ab00, 0x39b39500, 0x39b47f00,
    0x39b56900, 0x39b65300, 0x39b73d00, 0x39b82700, 0x39b91100, 0x39b9fb00, 0x39bae500, 0x39bbcf00, 0x39bcb900, 0x39bda300, 0x39be8d00, 0x39bf7700, 0x39c06100, 0x39c14b00, 0x39c23500, 0x39c31f00,
    0x39c40900, 0x39c4f300, 0x39c5dd00, 0x39c6c700, 0x39c7b100, 0x39c89b00, 0x39c98500, 0x39ca6f00, 0x39cb5900, 0x39cc4300, 0x39cd2d00, 0x39ce1700, 0x39cf0100, 0x39cfeb00, 0x39d0d500, 0x39d1bf00,
    0x39d2a900, 0x39d39300, 0x39d47d00, 0x39d56700, 0x39d65100, 0x39d73b00, 0x39d82500, 0x39d90f00, 0x39d9f900, 0x39dae300, 0x39dbcd00, 0x39dcb700, 0x39dda100, 0x39de8b00, 0x39df7500, 0x39e05f00,
    0x39e14900, 0x39e23300, 0x39e31d00, 0x39e40700, 0x39e4f100, 0x39e5db00, 0x39e6c500, 0x39e7af00, 0x39e89900, 0x39e98300, 0x39ea6d00, 0x39eb5700, 0x39ec4100, 0x39ed2b00, 0x39ee1500, 0x39eeff00,
    0x39efe900, 0x39f0d300, 0x39f1bd00, 0x39f2a700, 0x39f39100, 0x39f47b00, 0x39f56500, 0x39f64f00, 0x39f73900, 0x39f82300, 0x39f90d00, 0x39f9f700, 0x39fae100, 0x39fbcb00, 0x39fcb500, 0x39fd9f00,
    0x39fe8900, 0x39ff7300, 0x3a005d00, 0x3a014700, 0x3a023100, 0x3a031b00, 0x3a040500, 0x3a04ef00, 0x3a05d900, 0x3a06c300, 0x3a07ad00, 0x3a089700, 0x3a098100, 0x3a0a6b00, 0x3a0b5500, 0x3a0c3f00,
    0x3a0d2900, 0x3a0e1300, 0x3a0efd00, 0x3a0fe700, 0x3a10d100, 0x3a11bb00, 0x3a12a500, 0x3a138f00, 0x3a147900, 0x3a156300, 0x3a164d00, 0x3a173700, 0x3a182100, 0x3a190b00, 0x3a19f500, 0x3a1adf00,
    0x3a1bc900, 0x3a1cb300, 0x3a1d9d00, 0x3a1e8700, 0x3a1f7100, 0x3a205b00, 0x3a214500, 0x3a222f00, 0x3a231900, 0x3a240300, 0x3a24ed00, 0x3a25d700, 0x3a26c100, 0x3a27ab00, 0x3a289500, 0x3a297f00,
    0x3a2a6900, 0x3a2b5300, 0x3a2c3d00, 0x3a2d2700, 0x3a2e1100, 0x3a2efb00, 0x3a2fe500, 0x3a30cf00, 0x3a31b900, 0x3a32a300, 0x3a338d00, 0x3a347700, 0x3a356100, 0x3a364b00, 0x3a373500, 0x3a381f00,
    0x3a390900, 0x3a39f300, 0x3a3add00, 0x3a3bc700, 0x3a3cb100, 0x3a3d9b00, 0x3a3e8500, 0x3a3f6f00, 0x3a405900, 0x3a414300, 0x3a422d00, 0x3a431700, 0x3a440100, 0x3a44eb00, 0x3a45d500, 0x3a46bf00,
    0x3a47a900, 0x3a489300, 0x3a497d00, 0x3a4a6700, 0x3a4b5100, 0x3a4c3b00, 0x3a4d2500, 0x3a4e0f00, 0x3a4ef900, 0x3a4fe300, 0x3a50cd00, 0x3a51b700, 0x3a52a100, 0x3a538b00, 0x3a547500, 0x3a555f00,
    0x3a564900, 0x3a573300, 0x3a581d00, 0x3a590700, 0x3a59f100, 0x3a5adb00, 0x3a5bc500, 0x3a5caf00, 0x3a5d9900, 0x3a5e8300, 0x3a5f6d00, 0x3a605700, 0x3a614100, 0x3a622b00, 0x3a631500, 0x3a63ff00,
    0x3a64e900, 0x3a65d300, 0x3a66bd00, 0x3a67a700, 0x3a689100, 0x3a697b00, 0x3a6a6500, 0x3a6b4f00, 0x3a6c3900, 0x3a6d2300, 0x3a6e0d00, 0x3a6ef700, 0x3a6fe100, 0x3a70cb00, 0x3a71b500, 0x3a729f00,
    0x3a738900, 0x3a747300, 0x3a755d00, 0x3a764700, 0x3a773100, 0x3a781b00, 0x3a790500, 0x3a79ef00, 0x3a7ad900, 0x3a7bc300, 0x3a7cad00, 0x3a7d9700, 0x3a7e8100, 0x3a7f6b00, 0x3a805500, 0x3a813f00,
    0x3a822900, 0x3a831300, 0x3a83fd00, 0x3a84e700, 0x3a85d100, 0x3a86bb00, 0x3a87a500, 0x3a888f00, 0x3a897900, 0x3a8a6300, 0x3a8b4d00, 0x3a8c3700, 0x3a8d2100, 0x3a8e0b00, 0x3a8ef500, 0x3a8fdf00,
    0x3a90c900, 0x3a91b300, 0x3a929d00, 0x3a938700, 0x3a947100, 0x3a955b00, 0x3a964500, 0x3a972f00, 0x3a981900, 0x3a990300, 0x3a99ed00, 0x3a9ad700, 0x3a9bc100, 0x3a9cab00, 0x3a9d9500, 0x3a9e7f00,
    0x3a9f6900, 0x3aa05300, 0x3aa13d00, 0x3aa22700, 0x3aa31100, 0x3aa3fb00, 0x3aa4e500, 0x3aa5cf00, 0x3aa6b900, 0x3aa7a300, 0x3aa88d00, 0x3aa97700, 0x3aaa6100, 0x3aab4b00, 0x3aac3500, 0x3aad1f00,
    0x3aae0900, 0x3aaef300, 0x3aafdd00, 0x3ab0c700, 0x3ab1b100, 0x3ab29b00, 0x3ab38500, 0x3ab46f00, 0x3ab55900, 0x3ab64300, 0x3ab72d00, 0x3ab81700, 0x3ab90100, 0x3ab9eb00, 0x3abad500, 0x3abbbf00,
    0x3abca900, 0x3abd9300, 0x3abe7d00, 0x3abf6700, 0x3ac05100, 0x3ac13b00, 0x3ac22500, 0x3ac30f00, 0x3ac3f900, 0x3ac4e300, 0x3ac5cd00, 0x3ac6b700, 0x3ac7a100, 0x3ac88b00, 0x3ac97500, 0x3aca5f00,
    0x3acb4900, 0x3acc3300, 0x3acd1d00, 0x3ace0700, 0x3acef100, 0x3acfdb00, 0x3ad0c500, 0x3ad1af00, 0x3ad29900, 0x3ad38300, 0x3ad46d00, 0x3ad55700, 0x3ad64100, 0x3ad72b00, 0x3ad81500, 0x3ad8ff00,
    0x3ad9e900, 0x3adad300, 0x3adbbd00, 0x3adca700, 0x3add9100, 0x3ade7b00, 0x3adf6500, 0x3ae04f00, 0x3ae13900, 0x3ae22300, 0x3ae30d00, 0x3ae3f700, 0x3ae4e100, 0x3ae5cb00, 0x3ae6b500, 0x3ae79f00,
    0x3ae88900, 0x3ae97300, 0x3aea5d00, 0x3aeb4700, 0x3aec3100, 0x3aed1b00, 0x3aee0500, 0x3aeeef00, 0x3aefd900, 0x3af0c300, 0x3af1ad00, 0x3af29700, 0x3af38100, 0x3af46b00, 0x3af55500, 0x3af63f00,
    0x3af72900, 0x3af81300, 0x3af8fd00, 0x3af9e700, 0x3afad100, 0x3afbbb00, 0x3afca500, 0x3afd8f00, 0x3afe7900, 0x3aff6300, 0x3b004e00, 0x3b013800, 0x3b022200, 0x3b030c00, 0x3b03f600, 0x3b04e000,
    0x3b05ca00, 0x3b06b400, 0x3b079e00, 0x3b088800, 0x3b097200, 0x3b0a5c00, 0x3b0b4600, 0x3b0c3000, 0x3b0d1a00, 0x3b0e0400, 0x3b0eee00, 0x3b0fd800, 0x3b10c200, 0x3b11ac00, 0x3b129600, 0x3b138000,
    0x3b146a00, 0x3b155400, 0x3b163e00, 0x3b172800, 0x3b181200, 0x3b18fc00, 0x3b19e600, 0x3b1ad000, 0x3b1bba00, 0x3b1ca400, 0x3b1d8e00, 0x3b1e7800, 0x3b1f6200, 0x3b204c00, 0x3b213600, 0x3b222000,
    0x3b230a00, 0x3b23f400, 0x3b24de00, 0x3b25c800, 0x3b26b200, 0x3b279c00, 0x3b288600, 0x3b297000, 0x3b2a5a00, 0x3b2b4400, 0x3b2c2e00, 0x3b2d1800, 0x3b2e0200, 0x3b2eec00, 0x3b2fd600, 0x3b30c000,
    0x3b31aa00, 0x3b329400, 0x3b337e00, 0x3b346800, 0x3b355200, 0x3b363c00, 0x3b372600, 0x3b381000, 0x3b38fa00, 0x3b39e400, 0x3b3ace00, 0x3b3bb800, 0x3b3ca200, 0x3b3d8c00, 0x3b3e7600, 0x3b3f6000,
    0x3b404a00, 0x3b413400, 0x3b421e00, 0x3b430800, 0x3b43f200, 0x3b44dc00, 0x3b45c600, 0x3b46b000, 0x3b479a00, 0x3b488400, 0x3b496e00, 0x3b4a5800, 0x3b4b4200, 0x3b4c2c00, 0x3b4d1600, 0x3b4e0000,
    0x3b4f0000, 0x3b500000, 0x3b510000, 0x3b520000, 0x3b530000, 0x3b540000, 0x3b550000, 0x3b560000, 0x3b570000, 0x3b580000, 0x3b590000, 0x3b5a0000, 0x3b5b0000, 0x3b5c0000, 0x3b5d0000, 0x3b5e0000,
    0x3b5f0000, 0x3b600000, 0x3b610000, 0x3b620000, 0x3b630000, 0x3b640000, 0x3b650000, 0x3b660000, 0x3b670000, 0x3b680000, 0x3b690000, 0x3b6a0000, 0x3b6b0000, 0x3b6c0000, 0x3b6d0000, 0x3b6e0000,
    0x3b6f0000, 0x3b700000, 0x3b710000, 0x3b720000, 0x3b730000, 0x3b740000, 0x3b750000, 0x3b760000, 0x3b770000, 0x3b780000, 0x3b790000, 0x3b7a0000, 0x3b7b0000, 0x3b7c0000, 0x3b7d0000, 0x3b7e0000,
    0x3b7f0000, 0x3b800000, 0x3b810000, 0x3b820000, 0x3b830000, 0x3b840000, 0x3b850000, 0x3b860000, 0x3b870000, 0x3b880000, 0x3b890000, 0x3b8a0000, 0x3b8b0000, 0x3b8c0000, 0x3b8d0000, 0x3b8e0000,
    0x3b8f0000, 0x3b900000, 0x3b910000, 0x3b920000, 0x3b930000, 0x3b940000, 0x3b950000, 0x3b960000, 0x3b970000, 0x3b980000, 0x3b990000, 0x3b9a0000, 0x3b9b0000, 0x3b9c0000, 0x3b9d0000, 0x3b9e0000,
    0x3b9f0000, 0x3ba00000, 0x3ba10000, 0x3ba20000, 0x3ba30000, 0x3ba40000, 0x3ba50000, 0x3ba60000, 0x3ba70000, 0x3ba80000, 0x3ba90000, 0x3baa0000, 0x3bab0000, 0x3bac0000, 0x3bad0000, 0x3bae0000,
    0x3baf0000, 0x3bb00000, 0x3bb10000, 0x3bb20000, 0x3bb30000, 0x3bb40000, 0x3bb50000, 0x3bb60000, 0x3bb70000, 0x3bb80000, 0x3bb90000, 0x3bba0000, 0x3bbb0000, 0x3bbc0000, 0x3bbd0000, 0x3bbe0000,
    0x3bbf0000, 0x3bc00000, 0x3bc10000, 0x3bc20000, 0x3bc30000, 0x3bc40000, 0x3bc50000, 0x3bc60000, 0x3bc70000, 0x3bc80000, 0x3bc90000, 0x3bca0000, 0x3bcb0000, 0x3bcc0000, 0x3bcd0000, 0x3bce0000,
    0x3bcf0000, 0x3bd00000, 0x3bd10000, 0x3bd20000, 0x3bd30000, 0x3bd40000, 0x3bd50000, 0x3bd60000, 0x3bd70000, 0x3bd80000, 0x3bd90000, 0x3bda0000, 0x3bdb0000, 0x3bdc0000, 0x3bdd0000, 0x3bde0000,
    0x3bdf0000, 0x3be00000, 0x3be10000, 0x3be20000, 0x3be30000, 0x3be40000, 0x3be50000, 0x3be60000, 0x3be70000, 0x3be80000, 0x3be90000, 0x3bea0000, 0x3beb0000, 0x3bec0000, 0x3bed0000, 0x3bee0000,
    0x3bef0000, 0x3bf00000, 0x3bf10000, 0x3bf20000, 0x3bf30000, 0x3bf40000, 0x3bf50000, 0x3bf60000, 0x3bf70000, 0x3bf80000, 0x3bf90000, 0x3bfa0000, 0x3bfb0000, 0x3bfc0000, 0x3bfd0000, 0x3bfe0000,
    0x3bff0000, 0x3c000000, 0x3c010000, 0x3c020000, 0x3c030000, 0x3c040000, 0x3c050000, 0x3c060000, 0x3c070000, 0x3c080000, 0x3c090000, 0x3c0a0000, 0x3c0b0000, 0x3c0c0000, 0x3c0d0000, 0x3c0e0000,
    0x3c0f0000, 0x3c100000, 0x3c110000, 0x3c120000, 0x3c130000, 0x3c140000, 0x3c150000, 0x3c160000, 0x3c170000, 0x3c180000, 0x3c190000, 0x3c1a0000, 0x3c1b0000, 0x3c1c0000, 0x3c1d0000, 0x3c1e0000,
    0x3c1f0000, 0x3c200000, 0x3c210000, 0x3c220000, 0x3c230000, 0x3c240000, 0x3c250000, 0x3c260000, 0x3c270000, 0x3c280000, 0x3c290000, 0x3c2a0000, 0x3c2b0000, 0x3c2c0000, 0x3c2d0000, 0x3c2e0000,
    0x3c2f0000, 0x3c300000, 0x3c310000, 0x3c320000, 0x3c330000, 0x3c340000, 0x3c350000, 0x3c360000, 0x3c370000, 0x3c380000, 0x3c390000, 0x3c3a0000, 0x3c3b0000, 0x3c3c0000, 0x3c3d0000, 0x3c3e0000,
    0x3c3f0000, 0x3c400000, 0x3c410000, 0x3c420000, 0x3c430000, 0x3c440000, 0x3c450000, 0x3c460000, 0x3c470000, 0x3c480000, 0x3c490000, 0x3c4a0000, 0x3c4b0000, 0x3c4c0000, 0x3c4d0000, 0x3c4e0000,
    0x3c4f0000, 0x3c500000, 0x3c510000, 0x3c520000, 0x3c530000, 0x3c540000, 0x3c550000, 0x3c560000, 0x3c570000, 0x3c580000, 0x3c590000, 0x3c5a0000, 0x3c5b0000, 0x3c5c0000, 0x3c5d0000, 0x3c5e0000,
    0x3c5f0000, 0x3c600000, 0x3c610000, 0x3c620000, 0x3c630000, 0x3c640000, 0x3c650000, 0x3c660000, 0x3c670000, 0x3c680000, 0x3c690000, 0x3c6a0000, 0x3c6b0000, 0x3c6c0000, 0x3c6d0000, 0x3c6e0000,
    0x3c6f0000, 0x3c700000, 0x3c710000, 0x3c720000, 0x3c730000, 0x3c740000, 0x3c750000, 0x3c760000, 0x3c770000, 0x3c780000, 0x3c790000, 0x3c7a0000, 0x3c7b0000, 0x3c7c0000, 0x3c7d0000, 0x3c7e0000,
    0x3c7f0000, 0x3c800000, 0x3c810000, 0x3c820000, 0x3c830000, 0x3c840000, 0x3c850000, 0x3c860000, 0x3c870000, 0x3c880000, 0x3c890000, 0x3c8a0000, 0x3c8b0000, 0x3c8c0000, 0x3c8d0000, 0x3c8e0000,
    0x3c8f0000, 0x3c900000, 0x3c910000, 0x3c920000, 0x3c930000, 0x3c940000, 0x3c950000, 0x3c960000, 0x3c970000, 0x3c980000, 0x3c990000, 0x3c9a0000, 0x3c9b0000, 0x3c9c0000, 0x3c9d0000, 0x3c9e0000,
    0x3c9f0000, 0x3ca00000, 0x3ca10000, 0x3ca20000, 0x3ca30000, 0x3ca40000, 0x3ca50000, 0x3ca60000, 0x3ca70000, 0x3ca80000, 0x3ca90000, 0x3caa0000, 0x3cab0000, 0x3cac0000, 0x3cad0000, 0x3cae0000,
    0x3caf0000, 0x3cb00000, 0x3cb10000, 0x3cb20000, 0x3cb30000, 0x3cb40000, 0x3cb50000, 0x3cb60000, 0x3cb70000, 0x3cb80000, 0x3cb90000, 0x3cba0000, 0x3cbb0000, 0x3cbc0000, 0x3cbd0000, 0x3cbe0000,
    0x3cbf0000, 0x3cc00000, 0x3cc10000, 0x3cc20000, 0x3cc30000, 0x3cc40000, 0x3cc50000, 0x3cc60000, 0x3cc70000, 0x3cc80000, 0x3cc90000, 0x3cca0000, 0x3ccb0000, 0x3ccc0000, 0x3ccd0000, 0x3cce0000,
    0x3ccf0000, 0x3cd00000, 0x3cd10000, 0x3cd20000, 0x3cd30000, 0x3cd40000, 0x3cd50000, 0x3cd60000, 0x3cd70000, 0x3cd80000, 0x3cd90000, 0x3cda0000, 0x3cdb0000, 0x3cdc0000, 0x3cdd0000, 0x3cde0000,
    0x3cdf0000, 0x3ce00000, 0x3ce10000, 0x3ce20000, 0x3ce30000, 0x3ce40000, 0x3ce50000, 0x3ce60000, 0x3ce70000, 0x3ce80000, 0x3ce90000, 0x3cea0000, 0x3ceb0000, 0x3cec0000, 0x3ced0000, 0x3cee0000,
    0x3cef0000, 0x3cf00000, 0x3cf10000, 0x3cf20000, 0x3cf30000, 0x3cf40000, 0x3cf50000, 0x3cf60000, 0x3cf70000, 0x3cf80000, 0x3cf90000, 0x3cfa0000, 0x3cfb0000, 0x3cfc0000, 0x3cfd0000, 0x3cfe0000,
    0x3cff0000, 0x3d000000, 0x3d010000, 0x3d020000, 0x3d030000, 0x3d040000, 0x3d050000, 0x3d060000, 0x3d070000, 0x3d080000, 0x3d090000, 0x3d0a0000, 0x3d0b0000, 0x3d0c0000, 0x3d0d0000, 0x3d0e0000,
    0x3d0f0000, 0x3d100000, 0x3d110000, 0x3d120000, 0x3d130000, 0x3d140000, 0x3d150000, 0x3d160000, 0x3d170000, 0x3d180000, 0x3d190000, 0x3d1a0000, 0x3d1b0000, 0x3d1c0000, 0x3d1d0000, 0x3d1e0000,
    0x3d1f0000, 0x3d200000, 0x3d210000, 0x3d220000, 0x3d230000, 0x3d240000, 0x3d250000, 0x3d260000, 0x3d270000, 0x3d280000, 0x3d290000, 0x3d2a0000, 0x3d2b0000, 0x3d2c0000, 0x3d2d0000, 0x3d2e0000,
    0x3d2f0000, 0x3d300000, 0x3d310000, 0x3d320000, 0x3d330000, 0x3d340000, 0x3d350000, 0x3d360000, 0x3d370000, 0x3d380000, 0x3d390000, 0x3d3a0000, 0x3d3b0000, 0x3d3c0000, 0x3d3d0000, 0x3d3e0000,
    0x3d3f0000, 0x3d400000, 0x3d410000, 0x3d420000, 0x3d430000, 0x3d440000, 0x3d450000, 0x3d460000, 0x3d470000, 0x3d480000, 0x3d490000, 0x3d4a0000, 0x3d4b0000, 0x3d4c0000, 0x3d4d0000, 0x3d4e0000,
    0x3d4f2200, 0x3d504400, 0x3d516600, 0x3d528800, 0x3d53aa00, 0x3d54cc00, 0x3d55ee00, 0x3d571000, 0x3d583200, 0x3d595400, 0x3d5a7600, 0x3d5b9800, 0x3d5cba00, 0x3d5ddc00, 0x3d5efe00, 0x3d602000,
    0x3d614200, 0x3d626400, 0x3d638600, 0x3d64a800, 0x3d65ca00, 0x3d66ec00, 0x3d680e00, 0x3d693000, 0x3d6a5200, 0x3d6b7400, 0x3d6c9600, 0x3d6db800, 0x3d6eda00, 0x3d6ffc00, 0x3d711e00, 0x3d724000,
    0x3d736200, 0x3d748400, 0x3d75a600, 0x3d76c800, 0x3d77ea00, 0x3d790c00, 0x3d7a2e00, 0x3d7b5000, 0x3d7c7200, 0x3d7d9400, 0x3d7eb600, 0x3d7fd800, 0x3d80fa00, 0x3d821c00, 0x3d833e00, 0x3d846000,
    0x3d858200, 0x3d86a400, 0x3d87c600, 0x3d88e800, 0x3d8a0a00, 0x3d8b2c00, 0x3d8c4e00, 0x3d8d7000, 0x3d8e9200, 0x3d8fb400, 0x3d90d600, 0x3d91f800, 0x3d931a00, 0x3d943c00, 0x3d955e00, 0x3d968000,
    0x3d97a200, 0x3d98c400, 0x3d99e600, 0x3d9b0800, 0x3d9c2a00, 0x3d9d4c00, 0x3d9e6e00, 0x3d9f9000, 0x3da0b200, 0x3da1d400, 0x3da2f600, 0x3da41800, 0x3da53a00, 0x3da65c00, 0x3da77e00, 0x3da8a000,
    0x3da9c200, 0x3daae400, 0x3dac0600, 0x3dad2800, 0x3dae4a00, 0x3daf6c00, 0x3db08e00, 0x3db1b000, 0x3db2d200, 0x3db3f400, 0x3db51600, 0x3db63800, 0x3db75a00, 0x3db87c00, 0x3db99e00, 0x3dbac000,
    0x3dbbe200, 0x3dbd0400, 0x3dbe2600, 0x3dbf4800, 0x3dc06a00, 0x3dc18c00, 0x3dc2ae00, 0x3dc3d000, 0x3dc4f200, 0x3dc61400, 0x3dc73600, 0x3dc85800, 0x3dc97a00, 0x3dca9c00, 0x3dcbbe00, 0x3dcce000,
    0x3dce0200, 0x3dcf2400, 0x3dd04600, 0x3dd16800, 0x3dd28a00, 0x3dd3ac00, 0x3dd4ce00, 0x3dd5f000, 0x3dd71200, 0x3dd83400, 0x3dd95600, 0x3dda7800, 0x3ddb9a00, 0x3ddcbc00, 0x3dddde00, 0x3ddf0000,
    0x3de02200, 0x3de14400, 0x3de26600, 0x3de38800, 0x3de4aa00, 0x3de5cc00, 0x3de6ee00, 0x3de81000, 0x3de93200, 0x3dea5400, 0x3deb7600, 0x3dec9800, 0x3dedba00, 0x3deedc00, 0x3deffe00, 0x3df12000,
    0x3df24200, 0x3df36400, 0x3df48600, 0x3df5a800, 0x3df6ca00, 0x3df7ec00, 0x3df90e00, 0x3dfa3000, 0x3dfb5200, 0x3dfc7400, 0x3dfd9600, 0x3dfeb800, 0x3dffda00, 0x3e00fc00, 0x3e021e00, 0x3e034000,
    0x3e046200, 0x3e058400, 0x3e06a600, 0x3e07c800, 0x3e08ea00, 0x3e0a0c00, 0x3e0b2e00, 0x3e0c5000, 0x3e0d7200, 0x3e0e9400, 0x3e0fb600, 0x3e10d800, 0x3e11fa00, 0x3e131c00, 0x3e143e00, 0x3e156000,
    0x3e168200, 0x3e17a400, 0x3e18c600, 0x3e19e800, 0x3e1b0a00, 0x3e1c2c00, 0x3e1d4e00, 0x3e1e7000, 0x3e1f9200, 0x3e20b400, 0x3e21d600, 0x3e22f800, 0x3e241a00, 0x3e253c00, 0x3e265e00, 0x3e278000,
    0x3e28a200, 0x3e29c400, 0x3e2ae600, 0x3e2c0800, 0x3e2d2a00, 0x3e2e4c00, 0x3e2f6e00, 0x3e309000, 0x3e31b200, 0x3e32d400, 0x3e33f600, 0x3e351800, 0x3e363a00, 0x3e375c00, 0x3e387e00, 0x3e39a000,
    0x3e3ac200, 0x3e3be400, 0x3e3d0600, 0x3e3e2800, 0x3e3f4a00, 0x3e406c00, 0x3e418e00, 0x3e42b000, 0x3e43d200, 0x3e44f400, 0x3e461600, 0x3e473800, 0x3e485a00, 0x3e497c00, 0x3e4a9e00, 0x3e4bc000,
    0x3e4ce200, 0x3e4e0400, 0x3e4f2600, 0x3e504800, 0x3e516a00, 0x3e528c00, 0x3e53ae00, 0x3e54d000, 0x3e55f200, 0x3e571400, 0x3e583600, 0x3e595800, 0x3e5a7a00, 0x3e5b9c00, 0x3e5cbe00, 0x3e5de000,
    0x3e5f0200, 0x3e602400, 0x3e614600, 0x3e626800, 0x3e638a00, 0x3e64ac00, 0x3e65ce00, 0x3e66f000, 0x3e681200, 0x3e693400, 0x3e6a5600, 0x3e6b7800, 0x3e6c9a00, 0x3e6dbc00, 0x3e6ede00, 0x3e700000,
    0x3e712100, 0x3e724300, 0x3e736500, 0x3e748700, 0x3e75a900, 0x3e76cb00, 0x3e77ed00, 0x3e790f00, 0x3e7a3100, 0x3e7b5300, 0x3e7c7500, 0x3e7d9700, 0x3e7eb900, 0x3e7fdb00, 0x3e80fd00, 0x3e821f00,
    0x3e834100, 0x3e846300, 0x3e858500, 0x3e86a700, 0x3e87c900, 0x3e88eb00, 0x3e8a0d00, 0x3e8b2f00, 0x3e8c5100, 0x3e8d7300, 0x3e8e9500, 0x3e8fb700, 0x3e90d900, 0x3e91fb00, 0x3e931d00, 0x3e943f00,
    0x3e956100, 0x3e968300, 0x3e97a500, 0x3e98c700, 0x3e99e900, 0x3e9b0b00, 0x3e9c2d00, 0x3e9d4f00, 0x3e9e7100, 0x3e9f9300, 0x3ea0b500, 0x3ea1d700, 0x3ea2f900, 0x3ea41b00, 0x3ea53d00, 0x3ea65f00,
    0x3ea78100, 0x3ea8a300, 0x3ea9c500, 0x3eaae700, 0x3eac0900, 0x3ead2b00, 0x3eae4d00, 0x3eaf6f00, 0x3eb09100, 0x3eb1b300, 0x3eb2d500, 0x3eb3f700, 0x3eb51900, 0x3eb63b00, 0x3eb75d00, 0x3eb87f00,
    0x3eb9a100, 0x3ebac300, 0x3ebbe500, 0x3ebd0700, 0x3ebe2900, 0x3ebf4b00, 0x3ec06d00, 0x3ec18f00, 0x3ec2b100, 0x3ec3d300, 0x3ec4f500, 0x3ec61700, 0x3ec73900, 0x3ec85b00, 0x3ec97d00, 0x3eca9f00,
    0x3ecbc100, 0x3ecce300, 0x3ece0500, 0x3ecf2700, 0x3ed04900, 0x3ed16b00, 0x3ed28d00, 0x3ed3af00, 0x3ed4d100, 0x3ed5f300, 0x3ed71500, 0x3ed83700, 0x3ed95900, 0x3eda7b00, 0x3edb9d00, 0x3edcbf00,
    0x3edde100, 0x3edf0300, 0x3ee02500, 0x3ee14700, 0x3ee26900, 0x3ee38b00, 0x3ee4ad00, 0x3ee5cf00, 0x3ee6f100, 0x3ee81300, 0x3ee93500, 0x3eea5700, 0x3eeb7900, 0x3eec9b00, 0x3eedbd00, 0x3eeedf00,
    0x3ef00100, 0x3ef12300, 0x3ef24500, 0x3ef36700, 0x3ef48900, 0x3ef5ab00, 0x3ef6cd00, 0x3ef7ef00, 0x3ef91100, 0x3efa3300, 0x3efb5500, 0x3efc7700, 0x3efd9900, 0x3efebb00, 0x3effdd00, 0x3f00ff00,
    0x3f022100, 0x3f034300, 0x3f046500, 0x3f058700, 0x3f06a900, 0x3f07cb00, 0x3f08ed00, 0x3f0a0f00, 0x3f0b3100, 0x3f0c5300, 0x3f0d7500, 0x3f0e9700, 0x3f0fb900, 0x3f10db00, 0x3f11fd00, 0x3f131f00,
    0x3f144100, 0x3f156300, 0x3f168500, 0x3f17a700, 0x3f18c900, 0x3f19eb00, 0x3f1b0d00, 0x3f1c2f00, 0x3f1d5100, 0x3f1e7300, 0x3f1f9500, 0x3f20b700, 0x3f21d900, 0x3f22fb00, 0x3f241d00, 0x3f253f00,
    0x3f266100, 0x3f278300, 0x3f28a500, 0x3f29c700, 0x3f2ae900, 0x3f2c0b00, 0x3f2d2d00, 0x3f2e4f00, 0x3f2f7100, 0x3f309300, 0x3f31b500, 0x3f32d700, 0x3f33f900, 0x3f351b00, 0x3f363d00, 0x3f375f00,
    0x3f388100, 0x3f39a300, 0x3f3ac500, 0x3f3be700, 0x3f3d0900, 0x3f3e2b00, 0x3f3f4d00, 0x3f406f00, 0x3f419100, 0x3f42b300, 0x3f43d500, 0x3f44f700, 0x3f461900, 0x3f473b00, 0x3f485d00, 0x3f497f00,
    0x3f4aa100, 0x3f4bc300, 0x3f4ce500, 0x3f4e0700, 0x3f4f2900, 0x3f504b00, 0x3f516d00, 0x3f528f00, 0x3f53b100, 0x3f54d300, 0x3f55f500, 0x3f571700, 0x3f583900, 0x3f595b00, 0x3f5a7d00, 0x3f5b9f00,
    0x3f5cc100, 0x3f5de300, 0x3f5f0500, 0x3f602700, 0x3f614900, 0x3f626b00, 0x3f638d00, 0x3f64af00, 0x3f65d100, 0x3f66f300, 0x3f681500, 0x3f693700, 0x3f6a5900, 0x3f6b7b00, 0x3f6c9d00, 0x3f6dbf00,
    0x3f6ee100, 0x3f700300, 0x3f712500, 0x3f724700, 0x3f736900, 0x3f748b00, 0x3f75ad00, 0x3f76cf00, 0x3f77f100, 0x3f791300, 0x3f7a3500, 0x3f7b5700, 0x3f7c7900, 0x3f7d9b00, 0x3f7ebd00, 0x3f7fdf00,
    0x3f810100, 0x3f822300, 0x3f834500, 0x3f846700, 0x3f858900, 0x3f86ab00, 0x3f87cd00, 0x3f88ef00, 0x3f8a1100, 0x3f8b3300, 0x3f8c5500, 0x3f8d7700, 0x3f8e9900, 0x3f8fbb00, 0x3f90dd00, 0x3f91ff00,
    0x3f935300, 0x3f94a700, 0x3f95fb00, 0x3f974f00, 0x3f98a300, 0x3f99f700, 0x3f9b4b00, 0x3f9c9f00, 0x3f9df300, 0x3f9f4700, 0x3fa09b00, 0x3fa1ef00, 0x3fa34300, 0x3fa49700, 0x3fa5eb00, 0x3fa73f00,
    0x3fa89300, 0x3fa9e700, 0x3fab3b00, 0x3fac8f00, 0x3fade300, 0x3faf3700, 0x3fb08b00, 0x3fb1df00, 0x3fb33300, 0x3fb48700, 0x3fb5db00, 0x3fb72f00, 0x3fb88300, 0x3fb9d700, 0x3fbb2b00, 0x3fbc7f00,
    0x3fbdd300, 0x3fbf2700, 0x3fc07b00, 0x3fc1cf00, 0x3fc32300, 0x3fc47700, 0x3fc5cb00, 0x3fc71f00, 0x3fc87300, 0x3fc9c700, 0x3fcb1b00, 0x3fcc6f00, 0x3fcdc300, 0x3fcf1700, 0x3fd06b00, 0x3fd1bf00,
    0x3fd31300, 0x3fd46700, 0x3fd5bb00, 0x3fd70f00, 0x3fd86300, 0x3fd9b700, 0x3fdb0b00, 0x3fdc5f00, 0x3fddb300, 0x3fdf0700, 0x3fe05b00, 0x3fe1af00, 0x3fe30300, 0x3fe45700, 0x3fe5ab00, 0x3fe6ff00,
    0x3fe85300, 0x3fe9a700, 0x3feafb00, 0x3fec4f00, 0x3feda300, 0x3feef700, 0x3ff04b00, 0x3ff19f00, 0x3ff2f300, 0x3ff44700, 0x3ff59b00, 0x3ff6ef00, 0x3ff84300, 0x3ff99700, 0x3ffaeb00, 0x3ffc3f00,
    0x3ffd9300, 0x3ffee700, 0x40003b00, 0x40018f00, 0x4002e300, 0x40043700, 0x40058b00, 0x4006df00, 0x40083300, 0x40098700, 0x400adb00, 0x400c2f00, 0x400d8300, 0x400ed700, 0x40102b00, 0x40117f00,
    0x4012d300, 0x40142700, 0x40157b00, 0x4016cf00, 0x40182300, 0x40197700, 0x401acb00, 0x401c1f00, 0x401d7300, 0x401ec700, 0x40201b00, 0x40216f00, 0x4022c300, 0x40241700, 0x40256b00, 0x4026bf00,
    0x40281300, 0x40296700, 0x402abb00, 0x402c0f00, 0x402d6300, 0x402eb700, 0x40300b00, 0x40315f00, 0x4032b300, 0x40340700, 0x40355b00, 0x4036af00, 0x40380300, 0x40395700, 0x403aab00, 0x403bff00,
    0x403d5300, 0x403ea700, 0x403ffb00, 0x40414f00, 0x4042a300, 0x4043f700, 0x40454b00, 0x40469f00, 0x4047f300, 0x40494700, 0x404a9b00, 0x404bef00, 0x404d4300, 0x404e9700, 0x404feb00, 0x40513f00,
    0x40529300, 0x4053e700, 0x40553b00, 0x40568f00, 0x4057e300, 0x40593700, 0x405a8b00, 0x405bdf00, 0x405d3300, 0x405e8700, 0x405fdb00, 0x40612f00, 0x40628300, 0x4063d700, 0x40652b00, 0x40667f00,
    0x4067d300, 0x40692700, 0x406a7b00, 0x406bcf00, 0x406d2300, 0x406e7700, 0x406fcb00, 0x40711f00, 0x40727300, 0x4073c700, 0x40751b00, 0x40766f00, 0x4077c300, 0x40791700, 0x407a6b00, 0x407bbf00,
    0x407d1300, 0x407e6700, 0x407fbb00, 0x40810f00, 0x40826300, 0x4083b700, 0x40850b00, 0x40865f00, 0x4087b300, 0x40890700, 0x408a5b00, 0x408baf00, 0x408d0300, 0x408e5700, 0x408fab00, 0x4090ff00,
    0x40925300, 0x4093a700, 0x4094fb00, 0x40964f00, 0x4097a300, 0x4098f700, 0x409a4b00, 0x409b9f00, 0x409cf300, 0x409e4700, 0x409f9b00, 0x40a0ef00, 0x40a24300, 0x40a39700, 0x40a4eb00, 0x40a63f00,
    0x40a79300, 0x40a8e700, 0x40aa3b00, 0x40ab8f00, 0x40ace300, 0x40ae3700, 0x40af8b00, 0x40b0df00, 0x40b23300, 0x40b38700, 0x40b4db00, 0x40b62f00, 0x40b78300, 0x40b8d700, 0x40ba2b00, 0x40bb7f00,
    0x40bcd300, 0x40be2700, 0x40bf7b00, 0x40c0cf00, 0x40c22300, 0x40c37700, 0x40c4cb00, 0x40c61f00, 0x40c77300, 0x40c8c700, 0x40ca1b00, 0x40cb6f00, 0x40ccc300, 0x40ce1700, 0x40cf6b00, 0x40d0bf00,
    0x40d21300, 0x40d36700, 0x40d4bb00, 0x40d60f00, 0x40d76300, 0x40d8b700, 0x40da0b00, 0x40db5f00, 0x40dcb300, 0x40de0700, 0x40df5b00, 0x40e0af00, 0x40e20300, 0x40e35700, 0x40e4ab00, 0x40e5ff00,
    0x40e75300, 0x40e8a700, 0x40e9fb00, 0x40eb4f00, 0x40eca300, 0x40edf700, 0x40ef4b00, 0x40f09f00, 0x40f1f300, 0x40f34700, 0x40f49b00, 0x40f5ef00, 0x40f74300, 0x40f89700, 0x40f9eb00, 0x40fb3f00,
    0x40fc9300, 0x40fde700, 0x40ff3b00, 0x41008f00, 0x4101e300, 0x41033700, 0x41048b00, 0x4105df00, 0x41073300, 0x41088700, 0x4109db00, 0x410b2f00, 0x410c8300, 0x410dd700, 0x410f2b00, 0x41107f00,
    0x4111d300, 0x41132700, 0x41147b00, 0x4115cf00, 0x41172300, 0x41187700, 0x4119cb00, 0x411b1f00, 0x411c7300, 0x411dc700, 0x411f1b00, 0x41206f00, 0x4121c300, 0x41231700, 0x41246b00, 0x4125bf00,
    0x41271300, 0x41286700, 0x4129bb00, 0x412b0f00, 0x412c6300, 0x412db700, 0x412f0b00, 0x41305f00, 0x4131b300, 0x41330700, 0x41345b00, 0x4135af00, 0x41370300, 0x41385700, 0x4139ab00, 0x413aff00,
    0x413c5300, 0x413da700, 0x413efb00, 0x41404f00, 0x4141a300, 0x4142f700, 0x41444b00, 0x41459f00, 0x4146f300, 0x41484700, 0x41499b00, 0x414aef00, 0x414c4300, 0x414d9700, 0x414eeb00, 0x41503f00,
    0x41519300, 0x4152e700, 0x41543b00, 0x41558f00, 0x4156e300, 0x41583700, 0x41598b00, 0x415adf00, 0x415c3300, 0x415d8700, 0x415edb00, 0x41602f00, 0x41618300, 0x4162d700, 0x41642b00, 0x41657f00,
    0x4166d300, 0x41682700, 0x41697b00, 0x416acf00, 0x416c2300, 0x416d7700, 0x416ecb00, 0x41701f00, 0x41717300, 0x4172c700, 0x41741b00, 0x41756f00, 0x4176c300, 0x41781700, 0x41796b00, 0x417abf00,
    0x417c1300, 0x417d6700, 0x417ebb00, 0x41800f00, 0x41816300, 0x4182b700, 0x41840b00, 0x41855f00, 0x4186b300, 0x41880700, 0x41895b00, 0x418aaf00, 0x418c0300, 0x418d5700, 0x418eab00, 0x418fff00,
    0x41915300, 0x4192a700, 0x4193fb00, 0x41954f00, 0x4196a300, 0x4197f700, 0x41994b00, 0x419a9f00, 0x419bf300, 0x419d4700, 0x419e9b00, 0x419fef00, 0x41a14300, 0x41a29700, 0x41a3eb00, 0x41a53f00,
    0x41a69300, 0x41a7e700, 0x41a93b00, 0x41aa8f00, 0x41abe300, 0x41ad3700, 0x41ae8b00, 0x41afdf00, 0x41b13300, 0x41b28700, 0x41b3db00, 0x41b52f00, 0x41b68300, 0x41b7d700, 0x41b92b00, 0x41ba7f00,
    0x41bbd300, 0x41bd2700, 0x41be7b00, 0x41bfcf00, 0x41c12300, 0x41c27700, 0x41c3cb00, 0x41c51f00, 0x41c67300, 0x41c7c700, 0x41c91b00, 0x41ca6f00, 0x41cbc300, 0x41cd1700, 0x41ce6b00, 0x41cfbf00,
    0x41d11300, 0x41d26700, 0x41d3bb00, 0x41d50f00, 0x41d66300, 0x41d7b700, 0x41d90b00, 0x41da5f00, 0x41dbb300, 0x41dd0700, 0x41de5b00, 0x41dfaf00, 0x41e10300, 0x41e25700, 0x41e3ab00, 0x41e4ff00,
    0x41e65300, 0x41e7a700, 0x41e8fb00, 0x41ea4f00, 0x41eba300, 0x41ecf700, 0x41ee4b00, 0x41ef9f00, 0x41f0f300, 0x41f24700, 0x41f39b00, 0x41f4ef00, 0x41f64300, 0x41f79700, 0x41f8eb00, 0x41fa3f00,
    0x41fb9300, 0x41fce700, 0x41fe3b00, 0x41ff8f00, 0x4200e300, 0x42023700, 0x42038b00, 0x4204df00, 0x42063300, 0x42078700, 0x4208db00, 0x420a2f00, 0x420b8300, 0x420cd700, 0x420e2b00, 0x420f7f00,
    0x4210d300, 0x42122700, 0x42137b00, 0x4214cf00, 0x42162300, 0x42177700, 0x4218cb00, 0x421a1f00, 0x421b7300, 0x421cc700, 0x421e1b00, 0x421f6f00, 0x4220c300, 0x42221700, 0x42236b00, 0x4224bf00,
    0x42261300, 0x42276700, 0x4228bb00, 0x422a0f00, 0x422b6300, 0x422cb700, 0x422e0b00, 0x422f5f00, 0x4230b300, 0x42320700, 0x42335b00, 0x4234af00, 0x42360300, 0x42375700, 0x4238ab00, 0x4239ff00,
    0x423b9d00, 0x423d3b00, 0x423ed900, 0x42407700, 0x42421500, 0x4243b300, 0x42455100, 0x4246ef00, 0x42488d00, 0x424a2b00, 0x424bc900, 0x424d6700, 0x424f0500, 0x4250a300, 0x42524100, 0x4253df00,
    0x42557d00, 0x42571b00, 0x4258b900, 0x425a5700, 0x425bf500, 0x425d9300, 0x425f3100, 0x4260cf00, 0x42626d00, 0x42640b00, 0x4265a900, 0x42674700, 0x4268e500, 0x426a8300, 0x426c2100, 0x426dbf00,
    0x426f5d00, 0x4270fb00, 0x42729900, 0x42743700, 0x4275d500, 0x42777300, 0x42791100, 0x427aaf00, 0x427c4d00, 0x427deb00, 0x427f8900, 0x42812700, 0x4282c500, 0x42846300, 0x42860100, 0x42879f00,
    0x42893d00, 0x428adb00, 0x428c7900, 0x428e1700, 0x428fb500, 0x42915300, 0x4292f100, 0x42948f00, 0x42962d00, 0x4297cb00, 0x42996900, 0x429b0700, 0x429ca500, 0x429e4300, 0x429fe100, 0x42a17f00,
    0x42a31d00, 0x42a4bb00, 0x42a65900, 0x42a7f700, 0x42a99500, 0x42ab3300, 0x42acd100, 0x42ae6f00, 0x42b00d00, 0x42b1ab00, 0x42b34900, 0x42b4e700, 0x42b68500, 0x42b82300, 0x42b9c100, 0x42bb5f00,
    0x42bcfd00, 0x42be9b00, 0x42c03900, 0x42c1d700, 0x42c37500, 0x42c51300, 0x42c6b100, 0x42c84f00, 0x42c9ed00, 0x42cb8b00, 0x42cd2900, 0x42cec700, 0x42d06500, 0x42d20300, 0x42d3a100, 0x42d53f00,
    0x42d6dd00, 0x42d87b00, 0x42da1900, 0x42dbb700, 0x42dd5500, 0x42def300, 0x42e09100, 0x42e22f00, 0x42e3cd00, 0x42e56b00, 0x42e70900, 0x42e8a700, 0x42ea4500, 0x42ebe300, 0x42ed8100, 0x42ef1f00,
    0x42f0bd00, 0x42f25b00, 0x42f3f900, 0x42f59700, 0x42f73500, 0x42f8d300, 0x42fa7100, 0x42fc0f00, 0x42fdad00, 0x42ff4b00, 0x4300e900, 0x43028700, 0x43042500, 0x4305c300, 0x43076100, 0x4308ff00,
    0x430a9d00, 0x430c3b00, 0x430dd900, 0x430f7700, 0x43111500, 0x4312b300, 0x43145100, 0x4315ef00, 0x43178d00, 0x43192b00, 0x431ac900, 0x431c6700, 0x431e0500, 0x431fa300, 0x43214100, 0x4322df00,
    0x43247d00, 0x43261b00, 0x4327b900, 0x43295700, 0x432af500, 0x432c9300, 0x432e3100, 0x432fcf00, 0x43316d00, 0x43330b00, 0x4334a900, 0x43364700, 0x4337e500, 0x43398300, 0x433b2100, 0x433cbf00,
    0x433e5d00, 0x433ffb00, 0x43419900, 0x43433700, 0x4344d500, 0x43467300, 0x43481100, 0x4349af00, 0x434b4d00, 0x434ceb00, 0x434e8900, 0x43502700, 0x4351c500, 0x43536300, 0x43550100, 0x43569f00,
    0x43583d00, 0x4359db00, 0x435b7900, 0x435d1700, 0x435eb500, 0x43605300, 0x4361f100, 0x43638f00, 0x43652d00, 0x4366cb00, 0x43686900, 0x436a0700, 0x436ba500, 0x436d4300, 0x436ee100, 0x43707f00,
    0x43721d00, 0x4373bb00, 0x43755900, 0x4376f700, 0x43789500, 0x437a3300, 0x437bd100, 0x437d6f00, 0x437f0d00, 0x4380ab00, 0x43824900, 0x4383e700, 0x43858500, 0x43872300, 0x4388c100, 0x438a5f00,
    0x438bfd00, 0x438d9b00, 0x438f3900, 0x4390d700, 0x43927500, 0x43941300, 0x4395b100, 0x43974f00, 0x4398ed00, 0x439a8b00, 0x439c2900, 0x439dc700, 0x439f6500, 0x43a10300, 0x43a2a100, 0x43a43f00,
    0x43a5dd00, 0x43a77b00, 0x43a91900, 0x43aab700, 0x43ac5500, 0x43adf300, 0x43af9100, 0x43b12f00, 0x43b2cd00, 0x43b46b00, 0x43b60900, 0x43b7a700, 0x43b94500, 0x43bae300, 0x43bc8100, 0x43be1f00,
    0x43bfbd00, 0x43c15b00, 0x43c2f900, 0x43c49700, 0x43c63500, 0x43c7d300, 0x43c97100, 0x43cb0f00, 0x43ccad00, 0x43ce4b00, 0x43cfe900, 0x43d18700, 0x43d32500, 0x43d4c300, 0x43d66100, 0x43d7ff00,
    0x43d99d00, 0x43db3b00, 0x43dcd900, 0x43de7700, 0x43e01500, 0x43e1b300, 0x43e35100, 0x43e4ef00, 0x43e68d00, 0x43e82b00, 0x43e9c900, 0x43eb6700, 0x43ed0500, 0x43eea300, 0x43f04100, 0x43f1df00,
    0x43f37d00, 0x43f51b00, 0x43f6b900, 0x43f85700, 0x43f9f500, 0x43fb9300, 0x43fd3100, 0x43fecf00, 0x44006d00, 0x44020b00, 0x4403a900, 0x44054700, 0x4406e500, 0x44088300, 0x440a2100, 0x440bbf00,
    0x440d5d00, 0x440efb00, 0x44109900, 0x44123700, 0x4413d500, 0x44157300, 0x44171100, 0x4418af00, 0x441a4d00, 0x441beb00, 0x441d8900, 0x441f2700, 0x4420c500, 0x44226300, 0x44240100, 0x44259f00,
    0x44273d00, 0x4428db00, 0x442a7900, 0x442c1700, 0x442db500, 0x442f5300, 0x4430f100, 0x44328f00, 0x44342d00, 0x4435cb00, 0x44376900, 0x44390700, 0x443aa500, 0x443c4300, 0x443de100, 0x443f7f00,
    0x44411d00, 0x4442bb00, 0x44445900, 0x4445f700, 0x44479500, 0x44493300, 0x444ad100, 0x444c6f00, 0x444e0d00, 0x444fab00, 0x44514900, 0x4452e700, 0x44548500, 0x44562300, 0x4457c100, 0x44595f00,
    0x445afd00, 0x445c9b00, 0x445e3900, 0x445fd700, 0x44617500, 0x44631300, 0x4464b100, 0x44664f00, 0x4467ed00, 0x44698b00, 0x446b2900, 0x446cc700, 0x446e6500, 0x44700300, 0x4471a100, 0x44733f00,
    0x4474dd00, 0x44767b00, 0x44781900, 0x4479b700, 0x447b5500, 0x447cf300, 0x447e9100, 0x44802f00, 0x4481cd00, 0x44836b00, 0x44850900, 0x4486a700, 0x44884500, 0x4489e300, 0x448b8100, 0x448d1f00,
    0x448ebd00, 0x44905b00, 0x4491f900, 0x44939700, 0x44953500, 0x4496d300, 0x44987100, 0x449a0f00, 0x449bad00, 0x449d4b00, 0x449ee900, 0x44a08700, 0x44a22500, 0x44a3c300, 0x44a56100, 0x44a6ff00,
    0x44a89d00, 0x44aa3b00, 0x44abd900, 0x44ad7700, 0x44af1500, 0x44b0b300, 0x44b25100, 0x44b3ef00, 0x44b58d00, 0x44b72b00, 0x44b8c900, 0x44ba6700, 0x44bc0500, 0x44bda300, 0x44bf4100, 0x44c0df00,
    0x44c27d00, 0x44c41b00, 0x44c5b900, 0x44c75700, 0x44c8f500, 0x44ca9300, 0x44cc3100, 0x44cdcf00, 0x44cf6d00, 0x44d10b00, 0x44d2a900, 0x44d44700, 0x44d5e500, 0x44d78300, 0x44d92100, 0x44dabf00,
    0x44dc5d00, 0x44ddfb00, 0x44df9900, 0x44e13700, 0x44e2d500, 0x44e47300, 0x44e61100, 0x44e7af00, 0x44e94d00, 0x44eaeb00, 0x44ec8900, 0x44ee2700, 0x44efc500, 0x44f16300, 0x44f30100, 0x44f49f00,
    0x44f63d00, 0x44f7db00, 0x44f97900, 0x44fb1700, 0x44fcb500, 0x44fe5300, 0x44fff100, 0x45018f00, 0x45032d00, 0x4504cb00, 0x45066900, 0x45080700, 0x4509a500, 0x450b4300, 0x450ce100, 0x450e7f00,
    0x45101d00, 0x4511bb00, 0x45135900, 0x4514f700, 0x45169500, 0x45183300, 0x4519d100, 0x451b6f00, 0x451d0d00, 0x451eab00, 0x45204900, 0x4521e700, 0x45238500, 0x45252300, 0x4526c100, 0x45285f00,
    0x4529fd00, 0x452b9b00, 0x452d3900, 0x452ed700, 0x45307500, 0x45321300, 0x4533b100, 0x45354f00, 0x4536ed00, 0x45388b00, 0x453a2900, 0x453bc700, 0x453d6500, 0x453f0300, 0x4540a100, 0x45423f00,
    0x4543dd00, 0x45457b00, 0x45471900, 0x4548b700, 0x454a5500, 0x454bf300, 0x454d9100, 0x454f2f00, 0x4550cd00, 0x45526b00, 0x45540900, 0x4555a700, 0x45574500, 0x4558e300, 0x455a8100, 0x455c1f00,
    0x455dbd00, 0x455f5b00, 0x4560f900, 0x45629700, 0x45643500, 0x4565d300, 0x45677100, 0x45690f00, 0x456aad00, 0x456c4b00, 0x456de900, 0x456f8700, 0x45712500, 0x4572c300, 0x45746100, 0x4575ff00,
    0x4577e300, 0x4579c700, 0x457bab00, 0x457d8f00, 0x457f7300, 0x45815700, 0x45833b00, 0x45851f00, 0x45870300, 0x4588e700, 0x458acb00, 0x458caf00, 0x458e9300, 0x45907700, 0x45925b00, 0x45943f00,
    0x45962300, 0x45980700, 0x4599eb00, 0x459bcf00, 0x459db300, 0x459f9700, 0x45a17b00, 0x45a35f00, 0x45a54300, 0x45a72700, 0x45a90b00, 0x45aaef00, 0x45acd300, 0x45aeb700, 0x45b09b00, 0x45b27f00,
    0x45b46300, 0x45b64700, 0x45b82b00, 0x45ba0f00, 0x45bbf300, 0x45bdd700, 0x45bfbb00, 0x45c19f00, 0x45c38300, 0x45c56700, 0x45c74b00, 0x45c92f00, 0x45cb1300, 0x45ccf700, 0x45cedb00, 0x45d0bf00,
    0x45d2a300, 0x45d48700, 0x45d66b00, 0x45d84f00, 0x45da3300, 0x45dc1700, 0x45ddfb00, 0x45dfdf00, 0x45e1c300, 0x45e3a700, 0x45e58b00, 0x45e76f00, 0x45e95300, 0x45eb3700, 0x45ed1b00, 0x45eeff00,
    0x45f0e300, 0x45f2c700, 0x45f4ab00, 0x45f68f00, 0x45f87300, 0x45fa5700, 0x45fc3b00, 0x45fe1f00, 0x46000300, 0x4601e700, 0x4603cb00, 0x4605af00, 0x46079300, 0x46097700, 0x460b5b00, 0x460d3f00,
    0x460f2300, 0x46110700, 0x4612eb00, 0x4614cf00, 0x4616b300, 0x46189700, 0x461a7b00, 0x461c5f00, 0x461e4300, 0x46202700, 0x46220b00, 0x4623ef00, 0x4625d300, 0x4627b700, 0x46299b00, 0x462b7f00,
    0x462d6300, 0x462f4700, 0x46312b00, 0x46330f00, 0x4634f300, 0x4636d700, 0x4638bb00, 0x463a9f00, 0x463c8300, 0x463e6700, 0x46404b00, 0x46422f00, 0x46441300, 0x4645f700, 0x4647db00, 0x4649bf00,
    0x464ba300, 0x464d8700, 0x464f6b00, 0x46514f00, 0x46533300, 0x46551700, 0x4656fb00, 0x4658df00, 0x465ac300, 0x465ca700, 0x465e8b00, 0x46606f00, 0x46625300, 0x46643700, 0x46661b00, 0x4667ff00,
    0x4669e300, 0x466bc700, 0x466dab00, 0x466f8f00, 0x46717300, 0x46735700, 0x46753b00, 0x46771f00, 0x46790300, 0x467ae700, 0x467ccb00, 0x467eaf00, 0x46809300, 0x46827700, 0x46845b00, 0x46863f00,
    0x46882300, 0x468a0700, 0x468beb00, 0x468dcf00, 0x468fb300, 0x46919700, 0x46937b00, 0x46955f00, 0x46974300, 0x46992700, 0x469b0b00, 0x469cef00, 0x469ed300, 0x46a0b700, 0x46a29b00, 0x46a47f00,
    0x46a66300, 0x46a84700, 0x46aa2b00, 0x46ac0f00, 0x46adf300, 0x46afd700, 0x46b1bb00, 0x46b39f00, 0x46b58300, 0x46b76700, 0x46b94b00, 0x46bb2f00, 0x46bd1300, 0x46bef700, 0x46c0db00, 0x46c2bf00,
    0x46c4a300, 0x46c68700, 0x46c86b00, 0x46ca4f00, 0x46cc3300, 0x46ce1700, 0x46cffb00, 0x46d1df00, 0x46d3c300, 0x46d5a700, 0x46d78b00, 0x46d96f00, 0x46db5300, 0x46dd3700, 0x46df1b00, 0x46e0ff00,
    0x46e2e300, 0x46e4c700, 0x46e6ab00, 0x46e88f00, 0x46ea7300, 0x46ec5700, 0x46ee3b00, 0x46f01f00, 0x46f20300, 0x46f3e700, 0x46f5cb00, 0x46f7af00, 0x46f99300, 0x46fb7700, 0x46fd5b00, 0x46ff3f00,
    0x47012300, 0x47030700, 0x4704eb00, 0x4706cf00, 0x4708b300, 0x470a9700, 0x470c7b00, 0x470e5f00, 0x47104300, 0x47122700, 0x47140b00, 0x4715ef00, 0x4717d300, 0x4719b700, 0x471b9b00, 0x471d7f00,
    0x471f6300, 0x47214700, 0x47232b00, 0x47250f00, 0x4726f300, 0x4728d700, 0x472abb00, 0x472c9f00, 0x472e8300, 0x47306700, 0x47324b00, 0x47342f00, 0x47361300, 0x4737f700, 0x4739db00, 0x473bbf00,
    0x473da300, 0x473f8700, 0x47416b00, 0x47434f00, 0x47453300, 0x47471700, 0x4748fb00, 0x474adf00, 0x474cc300, 0x474ea700, 0x47508b00, 0x47526f00, 0x47545300, 0x47563700, 0x47581b00, 0x4759ff00,
    0x475c3f00, 0x475e7f00, 0x4760bf00, 0x4762ff00, 0x47653f00, 0x47677f00, 0x4769bf00, 0x476bff00, 0x476e3f00, 0x47707f00, 0x4772bf00, 0x4774ff00, 0x47773f00, 0x47797f00, 0x477bbf00, 0x477dff00,
    0x47803f00, 0x47827f00, 0x4784bf00, 0x4786ff00, 0x47893f00, 0x478b7f00, 0x478dbf00, 0x478fff00, 0x47923f00, 0x47947f00, 0x4796bf00, 0x4798ff00, 0x479b3f00, 0x479d7f00, 0x479fbf00, 0x47a1ff00,
    0x47a43f00, 0x47a67f00, 0x47a8bf00, 0x47aaff00, 0x47ad3f00, 0x47af7f00, 0x47b1bf00, 0x47b3ff00, 0x47b63f00, 0x47b87f00, 0x47babf00, 0x47bcff00, 0x47bf3f00, 0x47c17f00, 0x47c3bf00, 0x47c5ff00,
    0x47c83f00, 0x47ca7f00, 0x47ccbf00, 0x47ceff00, 0x47d13f00, 0x47d37f00, 0x47d5bf00, 0x47d7ff00, 0x47da3f00, 0x47dc7f00, 0x47debf00, 0x47e0ff00, 0x47e33f00, 0x47e57f00, 0x47e7bf00, 0x47e9ff00,
    0x47ec3f00, 0x47ee7f00, 0x47f0bf00, 0x47f2ff00, 0x47f53f00, 0x47f77f00, 0x47f9bf00, 0x47fbff00, 0x47fe3f00, 0x48007f00, 0x4802bf00, 0x4804ff00, 0x48073f00, 0x48097f00, 0x480bbf00, 0x480dff00,
    0x48103f00, 0x48127f00, 0x4814bf00, 0x4816ff00, 0x48193f00, 0x481b7f00, 0x481dbf00, 0x481fff00, 0x48223f00, 0x48247f00, 0x4826bf00, 0x4828ff00, 0x482b3f00, 0x482d7f00, 0x482fbf00, 0x4831ff00,
    0x48343f00, 0x48367f00, 0x4838bf00, 0x483aff00, 0x483d3f00, 0x483f7f00, 0x4841bf00, 0x4843ff00, 0x48463f00, 0x48487f00, 0x484abf00, 0x484cff00, 0x484f3f00, 0x48517f00, 0x4853bf00, 0x4855ff00,
    0x48583f00, 0x485a7f00, 0x485cbf00, 0x485eff00, 0x48613f00, 0x48637f00, 0x4865bf00, 0x4867ff00, 0x486a3f00, 0x486c7f00, 0x486ebf00, 0x4870ff00, 0x48733f00, 0x48757f00, 0x4877bf00, 0x4879ff00,
    0x487c3f00, 0x487e7f00, 0x4880bf00, 0x4882ff00, 0x48853f00, 0x48877f00, 0x4889bf00, 0x488bff00, 0x488e3f00, 0x48907f00, 0x4892bf00, 0x4894ff00, 0x48973f00, 0x48997f00, 0x489bbf00, 0x489dff00,
    0x48a03f00, 0x48a27f00, 0x48a4bf00, 0x48a6ff00, 0x48a93f00, 0x48ab7f00, 0x48adbf00, 0x48afff00, 0x48b23f00, 0x48b47f00, 0x48b6bf00, 0x48b8ff00, 0x48bb3f00, 0x48bd7f00, 0x48bfbf00, 0x48c1ff00,
    0x48c43f00, 0x48c67f00, 0x48c8bf00, 0x48caff00, 0x48cd3f00, 0x48cf7f00, 0x48d1bf00, 0x48d3ff00, 0x48d63f00, 0x48d87f00, 0x48dabf00, 0x48dcff00, 0x48df3f00, 0x48e17f00, 0x48e3bf00, 0x48e5ff00,
    0x48e83f00, 0x48ea7f00, 0x48ecbf00, 0x48eeff00, 0x48f13f00, 0x48f37f00, 0x48f5bf00, 0x48f7ff00, 0x48fa3f00, 0x48fc7f00, 0x48febf00, 0x4900ff00, 0x49033f00, 0x49057f00, 0x4907bf00, 0x4909ff00,
    0x490c3f00, 0x490e7f00, 0x4910bf00, 0x4912ff00, 0x49153f00, 0x49177f00, 0x4919bf00, 0x491bff00, 0x491e3f00, 0x49207f00, 0x4922bf00, 0x4924ff00, 0x49273f00, 0x49297f00, 0x492bbf00, 0x492dff00,
    0x49303f00, 0x49327f00, 0x4934bf00, 0x4936ff00, 0x49393f00, 0x493b7f00, 0x493dbf00, 0x493fff00, 0x49423f00, 0x49447f00, 0x4946bf00, 0x4948ff00, 0x494b3f00, 0x494d7f00, 0x494fbf00, 0x4951ff00,
    0x49543f00, 0x49567f00, 0x4958bf00, 0x495aff00, 0x495d3f00, 0x495f7f00, 0x4961bf00, 0x4963ff00, 0x49663f00, 0x49687f00, 0x496abf00, 0x496cff00, 0x496f3f00, 0x49717f00, 0x4973bf00, 0x4975ff00,
    0x49783f00, 0x497a7f00, 0x497cbf00, 0x497eff00, 0x49813f00, 0x49837f00, 0x4985bf00, 0x4987ff00, 0x498a3f00, 0x498c7f00, 0x498ebf00, 0x4990ff00, 0x49933f00, 0x49957f00, 0x4997bf00, 0x4999ff00,
    0x499cb300, 0x499f6700, 0x49a21b00, 0x49a4cf00, 0x49a78300, 0x49aa3700, 0x49aceb00, 0x49af9f00, 0x49b25300, 0x49b50700, 0x49b7bb00, 0x49ba6f00, 0x49bd2300, 0x49bfd700, 0x49c28b00, 0x49c53f00,
    0x49c7f300, 0x49caa700, 0x49cd5b00, 0x49d00f00, 0x49d2c300, 0x49d57700, 0x49d82b00, 0x49dadf00, 0x49dd9300, 0x49e04700, 0x49e2fb00, 0x49e5af00, 0x49e86300, 0x49eb1700, 0x49edcb00, 0x49f07f00,
    0x49f33300, 0x49f5e700, 0x49f89b00, 0x49fb4f00, 0x49fe0300, 0x4a00b700, 0x4a036b00, 0x4a061f00, 0x4a08d300, 0x4a0b8700, 0x4a0e3b00, 0x4a10ef00, 0x4a13a300, 0x4a165700, 0x4a190b00, 0x4a1bbf00,
    0x4a1e7300, 0x4a212700, 0x4a23db00, 0x4a268f00, 0x4a294300, 0x4a2bf700, 0x4a2eab00, 0x4a315f00, 0x4a341300, 0x4a36c700, 0x4a397c00, 0x4a3c3000, 0x4a3ee400, 0x4a419800, 0x4a444c00, 0x4a470000,
    0x4a49b400, 0x4a4c6800, 0x4a4f1c00, 0x4a51d000, 0x4a548400, 0x4a573800, 0x4a59ec00, 0x4a5ca000, 0x4a5f5400, 0x4a620800, 0x4a64bc00, 0x4a677000, 0x4a6a2400, 0x4a6cd800, 0x4a6f8c00, 0x4a724000,
    0x4a74f400, 0x4a77a800, 0x4a7a5c00, 0x4a7d1000, 0x4a7fc400, 0x4a827800, 0x4a852c00, 0x4a87e000, 0x4a8a9400, 0x4a8d4800, 0x4a8ffc00, 0x4a92b000, 0x4a956400, 0x4a981800, 0x4a9acc00, 0x4a9d8000,
    0x4aa03400, 0x4aa2e800, 0x4aa59c00, 0x4aa85000, 0x4aab0400, 0x4aadb800, 0x4ab06c00, 0x4ab32000, 0x4ab5d400, 0x4ab88800, 0x4abb3c00, 0x4abdf000, 0x4ac0a400, 0x4ac35800, 0x4ac60c00, 0x4ac8c000,
    0x4acb7400, 0x4ace2800, 0x4ad0dc00, 0x4ad39000, 0x4ad64400, 0x4ad8f800, 0x4adbac00, 0x4ade6000, 0x4ae11400, 0x4ae3c800, 0x4ae67c00, 0x4ae93000, 0x4aebe400, 0x4aee9800, 0x4af14c00, 0x4af40000,
    0x4af6cc00, 0x4af99800, 0x4afc6400, 0x4aff3000, 0x4b01fc00, 0x4b04c800, 0x4b079400, 0x4b0a6000, 0x4b0d2c00, 0x4b0ff800, 0x4b12c400, 0x4b159000, 0x4b185c00, 0x4b1b2800, 0x4b1df400, 0x4b20c000,
    0x4b238c00, 0x4b265800, 0x4b292400, 0x4b2bf000, 0x4b2ebc00, 0x4b318800, 0x4b345400, 0x4b372000, 0x4b39ec00, 0x4b3cb800, 0x4b3f8400, 0x4b425000, 0x4b451c00, 0x4b47e800, 0x4b4ab400, 0x4b4d8000,
    0x4b504c00, 0x4b531800, 0x4b55e400, 0x4b58b000, 0x4b5b7c00, 0x4b5e4800, 0x4b611400, 0x4b63e000, 0x4b66ac00, 0x4b697800, 0x4b6c4400, 0x4b6f1000, 0x4b71dc00, 0x4b74a800, 0x4b777400, 0x4b7a4000,
    0x4b7d0c00, 0x4b7fd800, 0x4b82a400, 0x4b857000, 0x4b883c00, 0x4b8b0800, 0x4b8dd400, 0x4b90a000, 0x4b936c00, 0x4b963800, 0x4b990400, 0x4b9bd000, 0x4b9e9c00, 0x4ba16800, 0x4ba43400, 0x4ba70000,
    0x4ba9cc00, 0x4bac9800, 0x4baf6400, 0x4bb23000, 0x4bb4fc00, 0x4bb7c700, 0x4bba9300, 0x4bbd5f00, 0x4bc02b00, 0x4bc2f700, 0x4bc5c300, 0x4bc88f00, 0x4bcb5b00, 0x4bce2700, 0x4bd0f300, 0x4bd3bf00,
    0x4bd68b00, 0x4bd95700, 0x4bdc2300, 0x4bdeef00, 0x4be1bb00, 0x4be48700, 0x4be75300, 0x4bea1f00, 0x4beceb00, 0x4befb700, 0x4bf28300, 0x4bf54f00, 0x4bf81b00, 0x4bfae700, 0x4bfdb300, 0x4c007f00,
    0x4c034b00, 0x4c061700, 0x4c08e300, 0x4c0baf00, 0x4c0e7b00, 0x4c114700, 0x4c141300, 0x4c16df00, 0x4c19ab00, 0x4c1c7700, 0x4c1f4300, 0x4c220f00, 0x4c24db00, 0x4c27a700, 0x4c2a7300, 0x4c2d3f00,
    0x4c300b00, 0x4c32d700, 0x4c35a300, 0x4c386f00, 0x4c3b3b00, 0x4c3e0700, 0x4c40d300, 0x4c439f00, 0x4c466b00, 0x4c493700, 0x4c4c0300, 0x4c4ecf00, 0x4c519b00, 0x4c546700, 0x4c573300, 0x4c59ff00,
    0x4c5d7700, 0x4c60ef00, 0x4c646700, 0x4c67df00, 0x4c6b5700, 0x4c6ecf00, 0x4c724700, 0x4c75bf00, 0x4c793700, 0x4c7caf00, 0x4c802700, 0x4c839f00, 0x4c871700, 0x4c8a8f00, 0x4c8e0700, 0x4c917f00,
    0x4c94f700, 0x4c986f00, 0x4c9be700, 0x4c9f5f00, 0x4ca2d700, 0x4ca64f00, 0x4ca9c700, 0x4cad3f00, 0x4cb0b700, 0x4cb42f00, 0x4cb7a700, 0x4cbb1f00, 0x4cbe9700, 0x4cc20f00, 0x4cc58700, 0x4cc8ff00,
    0x4ccc7700, 0x4ccfef00, 0x4cd36700, 0x4cd6df00, 0x4cda5700, 0x4cddcf00, 0x4ce14700, 0x4ce4bf00, 0x4ce83700, 0x4cebaf00, 0x4cef2700, 0x4cf29f00, 0x4cf61700, 0x4cf98f00, 0x4cfd0700, 0x4d007f00,
    0x4d03f700, 0x4d076f00, 0x4d0ae700, 0x4d0e5f00, 0x4d11d700, 0x4d154f00, 0x4d18c700, 0x4d1c3f00, 0x4d1fb700, 0x4d232f00, 0x4d26a700, 0x4d2a1f00, 0x4d2d9700, 0x4d310f00, 0x4d348700, 0x4d37ff00,
    0x4d3b7700, 0x4d3eef00, 0x4d426700, 0x4d45df00, 0x4d495700, 0x4d4ccf00, 0x4d504700, 0x4d53bf00, 0x4d573700, 0x4d5aaf00, 0x4d5e2700, 0x4d619f00, 0x4d651700, 0x4d688f00, 0x4d6c0700, 0x4d6f7f00,
    0x4d72f700, 0x4d766f00, 0x4d79e700, 0x4d7d5f00, 0x4d80d700, 0x4d844f00, 0x4d87c700, 0x4d8b3f00, 0x4d8eb700, 0x4d922f00, 0x4d95a700, 0x4d991f00, 0x4d9c9700, 0x4da00f00, 0x4da38700, 0x4da6ff00,
    0x4daa7700, 0x4dadef00, 0x4db16700, 0x4db4df00, 0x4db85700, 0x4dbbcf00, 0x4dbf4700, 0x4dc2bf00, 0x4dc63700, 0x4dc9af00, 0x4dcd2700, 0x4dd09f00, 0x4dd41700, 0x4dd78f00, 0x4ddb0700, 0x4dde7f00,
    0x4de1f700, 0x4de56f00, 0x4de8e700, 0x4dec5f00, 0x4defd700, 0x4df34f00, 0x4df6c700, 0x4dfa3f00, 0x4dfdb700, 0x4e012f00, 0x4e04a700, 0x4e081f00, 0x4e0b9700, 0x4e0f0f00, 0x4e128700, 0x4e15ff00,
    0x4e19ff00, 0x4e1dff00, 0x4e21ff00, 0x4e25ff00, 0x4e29ff00, 0x4e2dff00, 0x4e31ff00, 0x4e35ff00, 0x4e39ff00, 0x4e3dff00, 0x4e41ff00, 0x4e45ff00, 0x4e49ff00, 0x4e4dff00, 0x4e51ff00, 0x4e55ff00,
    0x4e59ff00, 0x4e5dff00, 0x4e61ff00, 0x4e65ff00, 0x4e69ff00, 0x4e6dff00, 0x4e71ff00, 0x4e75ff00, 0x4e79ff00, 0x4e7dff00, 0x4e81ff00, 0x4e85ff00, 0x4e89ff00, 0x4e8dff00, 0x4e91ff00, 0x4e95ff00,
    0x4e99ff00, 0x4e9dff00, 0x4ea1ff00, 0x4ea5ff00, 0x4ea9ff00, 0x4eadff00, 0x4eb1ff00, 0x4eb5ff00, 0x4eb9ff00, 0x4ebdff00, 0x4ec1ff00, 0x4ec5ff00, 0x4ec9ff00, 0x4ecdff00, 0x4ed1ff00, 0x4ed5ff00,
    0x4ed9ff00, 0x4eddff00, 0x4ee1ff00, 0x4ee5ff00, 0x4ee9ff00, 0x4eedff00, 0x4ef1ff00, 0x4ef5ff00, 0x4ef9ff00, 0x4efdff00, 0x4f01ff00, 0x4f05ff00, 0x4f09ff00, 0x4f0dff00, 0x4f11ff00, 0x4f15ff00,
    0x4f19ff00, 0x4f1dff00, 0x4f21ff00, 0x4f25ff00, 0x4f29ff00, 0x4f2dff00, 0x4f31ff00, 0x4f35ff00, 0x4f39ff00, 0x4f3dff00, 0x4f41ff00, 0x4f45ff00, 0x4f49ff00, 0x4f4dff00, 0x4f51ff00, 0x4f55ff00,
    0x4f59ff00, 0x4f5dff00, 0x4f61ff00, 0x4f65ff00, 0x4f69ff00, 0x4f6dff00, 0x4f71ff00, 0x4f75ff00, 0x4f79ff00, 0x4f7dff00, 0x4f81ff00, 0x4f85ff00, 0x4f89ff00, 0x4f8dff00, 0x4f91ff00, 0x4f95ff00,
    0x4f99ff00, 0x4f9dff00, 0x4fa1ff00, 0x4fa5ff00, 0x4fa9ff00, 0x4fadff00, 0x4fb1ff00, 0x4fb5ff00, 0x4fb9ff00, 0x4fbdff00, 0x4fc1ff00, 0x4fc5ff00, 0x4fc9ff00, 0x4fcdff00, 0x4fd1ff00, 0x4fd5ff00,
    0x4fd9ff00, 0x4fddff00, 0x4fe1ff00, 0x4fe5ff00, 0x4fe9ff00, 0x4fedff00, 0x4ff1ff00, 0x4ff5ff00, 0x4ff9ff00, 0x4ffdff00, 0x5001ff00, 0x5005ff00, 0x5009ff00, 0x500dff00, 0x5011ff00, 0x5015ff00,
    0x501a7700, 0x501eef00, 0x50236700, 0x5027df00, 0x502c5700, 0x5030cf00, 0x50354700, 0x5039bf00, 0x503e3700, 0x5042af00, 0x50472700, 0x504b9f00, 0x50501700, 0x50548f00, 0x50590700, 0x505d7f00,
    0x5061f700, 0x50666f00, 0x506ae700, 0x506f5f00, 0x5073d700, 0x50785000, 0x507cc800, 0x50814000, 0x5085b800, 0x508a3000, 0x508ea800, 0x50932000, 0x50979800, 0x509c1000, 0x50a08800, 0x50a50000,
    0x50a97800, 0x50adf000, 0x50b26800, 0x50b6e000, 0x50bb5800, 0x50bfd000, 0x50c44800, 0x50c8c000, 0x50cd3800, 0x50d1b000, 0x50d62800, 0x50daa000, 0x50df1800, 0x50e39000, 0x50e80800, 0x50ec8000,
    0x50f0f800, 0x50f57000, 0x50f9e800, 0x50fe6000, 0x5102d800, 0x51075000, 0x510bc800, 0x51104000, 0x5114b800, 0x51193000, 0x511da800, 0x51222000, 0x51269800, 0x512b1000, 0x512f8800, 0x51340000,
    0x51396800, 0x513ed000, 0x51443800, 0x5149a000, 0x514f0800, 0x51547000, 0x5159d800, 0x515f4000, 0x5164a800, 0x516a1000, 0x516f7800, 0x5174e000, 0x517a4800, 0x517fb000, 0x51851800, 0x518a8000,
    0x518fe800, 0x51955000, 0x519ab800, 0x51a02000, 0x51a58800, 0x51aaf000, 0x51b05800, 0x51b5c000, 0x51bb2800, 0x51c09000, 0x51c5f800, 0x51cb6000, 0x51d0c800, 0x51d63000, 0x51db9800, 0x51e10000,
    0x51e66800, 0x51ebd000, 0x51f13800, 0x51f6a000, 0x51fc0800, 0x52017000, 0x5206d800, 0x520c4000, 0x5211a800, 0x52171000, 0x521c7800, 0x5221e000, 0x52274800, 0x522cb000, 0x52321800, 0x52378000,
    0x523ce800, 0x52425000, 0x5247b800, 0x524d2000, 0x52528800, 0x5257f000, 0x525d5800, 0x5262c000, 0x52682800, 0x526d9000, 0x5272f800, 0x52786000, 0x527dc800, 0x52833000, 0x52889800, 0x528e0000,
    0x5293c000, 0x52998000, 0x529f4000, 0x52a50000, 0x52aac000, 0x52b08000, 0x52b64000, 0x52bc0000, 0x52c1bf00, 0x52c77f00, 0x52cd3f00, 0x52d2ff00, 0x52d8bf00, 0x52de7f00, 0x52e43f00, 0x52e9ff00,
    0x52efbf00, 0x52f57f00, 0x52fb3f00, 0x5300ff00, 0x5306bf00, 0x530c7f00, 0x53123f00, 0x5317ff00, 0x531dbf00, 0x53237f00, 0x53293f00, 0x532eff00, 0x5334bf00, 0x533a7f00, 0x53403f00, 0x5345ff00,
    0x534bbf00, 0x53517f00, 0x53573f00, 0x535cff00, 0x5362bf00, 0x53687f00, 0x536e3f00, 0x5373ff00, 0x5379bf00, 0x537f7f00, 0x53853f00, 0x538aff00, 0x5390bf00, 0x53967f00, 0x539c3f00, 0x53a1ff00,
    0x53a7bf00, 0x53ad7f00, 0x53b33f00, 0x53b8ff00, 0x53bebf00, 0x53c47f00, 0x53ca3f00, 0x53cfff00, 0x53d5bf00, 0x53db7f00, 0x53e13f00, 0x53e6ff00, 0x53ecbf00, 0x53f27f00, 0x53f83f00, 0x53fdff00,
    0x54055f00, 0x540cbf00, 0x54141f00, 0x541b7f00, 0x5422df00, 0x542a3f00, 0x54319f00, 0x5438ff00, 0x54405f00, 0x5447bf00, 0x544f1f00, 0x54567f00, 0x545ddf00, 0x54653f00, 0x546c9f00, 0x5473ff00,
    0x547b5f00, 0x5482bf00, 0x548a1f00, 0x54917f00, 0x5498df00, 0x54a03f00, 0x54a79f00, 0x54aeff00, 0x54b65f00, 0x54bdbf00, 0x54c51f00, 0x54cc7f00, 0x54d3df00, 0x54db3f00, 0x54e29f00, 0x54e9ff00,
    0x54f15f00, 0x54f8bf00, 0x55001f00, 0x55077f00, 0x550edf00, 0x55163f00, 0x551d9f00, 0x5524ff00, 0x552c5f00, 0x5533bf00, 0x553b1f00, 0x55427f00, 0x5549df00, 0x55513f00, 0x55589f00, 0x555fff00,
    0x55675f00, 0x556ebf00, 0x55761f00, 0x557d7f00, 0x5584df00, 0x558c3f00, 0x55939f00, 0x559aff00, 0x55a25f00, 0x55a9bf00, 0x55b11f00, 0x55b87f00, 0x55bfdf00, 0x55c73f00, 0x55ce9f00, 0x55d5ff00,
    0x55de9f00, 0x55e73f00, 0x55efdf00, 0x55f87f00, 0x56011f00, 0x5609bf00, 0x56125f00, 0x561aff00, 0x56239f00, 0x562c3f00, 0x5634df00, 0x563d7f00, 0x56461f00, 0x564ebf00, 0x56575f00, 0x565fff00,
    0x56689f00, 0x56713f00, 0x5679df00, 0x56827f00, 0x568b1f00, 0x5693bf00, 0x569c5f00, 0x56a4ff00, 0x56ad9f00, 0x56b63f00, 0x56bedf00, 0x56c77f00, 0x56d01f00, 0x56d8bf00, 0x56e15f00, 0x56e9ff00,
    0x56f29f00, 0x56fb3f00, 0x5703df00, 0x570c7f00, 0x57151f00, 0x571dbf00, 0x57265f00, 0x572eff00, 0x57379f00, 0x57403f00, 0x5748df00, 0x57517f00, 0x575a1f00, 0x5762bf00, 0x576b5f00, 0x5773ff00,
    0x577c9f00, 0x57853f00, 0x578ddf00, 0x57967f00, 0x579f1f00, 0x57a7bf00, 0x57b05f00, 0x57b8ff00, 0x57c19f00, 0x57ca3f00, 0x57d2df00, 0x57db7f00, 0x57e41f00, 0x57ecbf00, 0x57f55f00, 0x57fdff00,
    0x58087f00, 0x5812ff00, 0x581d7f00, 0x5827ff00, 0x58327f00, 0x583cff00, 0x58477f00, 0x5851ff00, 0x585c7f00, 0x5866ff00, 0x58717f00, 0x587bff00, 0x58867f00, 0x5890ff00, 0x589b7f00, 0x58a5ff00,
    0x58b07f00, 0x58baff00, 0x58c57f00, 0x58cfff00, 0x58da7f00, 0x58e4ff00, 0x58ef7f00, 0x58f9ff00, 0x59047f00, 0x590eff00, 0x59197f00, 0x5923ff00, 0x592e7f00, 0x5938ff00, 0x59437f00, 0x594dff00,
    0x59587f00, 0x5962ff00, 0x596d7f00, 0x5977ff00, 0x59827f00, 0x598cff00, 0x59977f00, 0x59a1ff00, 0x59ac7f00, 0x59b6ff00, 0x59c17f00, 0x59cbff00, 0x59d67f00, 0x59e0ff00, 0x59eb7f00, 0x59f5ff00,
    0x5a007f00, 0x5a0aff00, 0x5a157f00, 0x5a1fff00, 0x5a2a7f00, 0x5a34ff00, 0x5a3f7f00, 0x5a49ff00, 0x5a547f00, 0x5a5eff00, 0x5a697f00, 0x5a73ff00, 0x5a7e7f00, 0x5a88ff00, 0x5a937f00, 0x5a9dff00,
    0x5aaa0700, 0x5ab60f00, 0x5ac21700, 0x5ace1f00, 0x5ada2700, 0x5ae62f00, 0x5af23700, 0x5afe3f00, 0x5b0a4700, 0x5b164f00, 0x5b225700, 0x5b2e5f00, 0x5b3a6700, 0x5b466f00, 0x5b527700, 0x5b5e7f00,
    0x5b6a8700, 0x5b768f00, 0x5b829700, 0x5b8e9f00, 0x5b9aa700, 0x5ba6af00, 0x5bb2b700, 0x5bbebf00, 0x5bcac700, 0x5bd6cf00, 0x5be2d700, 0x5beedf00, 0x5bfae700, 0x5c06ef00, 0x5c12f700, 0x5c1eff00,
    0x5c2b0700, 0x5c370f00, 0x5c431700, 0x5c4f1f00, 0x5c5b2700, 0x5c672f00, 0x5c733700, 0x5c7f3f00, 0x5c8b4700, 0x5c974f00, 0x5ca35700, 0x5caf5f00, 0x5cbb6700, 0x5cc76f00, 0x5cd37700, 0x5cdf7f00,
    0x5ceb8700, 0x5cf78f00, 0x5d039700, 0x5d0f9f00, 0x5d1ba700, 0x5d27af00, 0x5d33b700, 0x5d3fbf00, 0x5d4bc700, 0x5d57cf00, 0x5d63d700, 0x5d6fdf00, 0x5d7be700, 0x5d87ef00, 0x5d93f700, 0x5da00000,
    0x5dac8000, 0x5db90000, 0x5dc58000, 0x5dd20000, 0x5dde8000, 0x5deb0000, 0x5df78000, 0x5e040000, 0x5e108000, 0x5e1d0000, 0x5e298000, 0x5e360000, 0x5e428000, 0x5e4f0000, 0x5e5b8000, 0x5e680000,
    0x5e748000, 0x5e810000, 0x5e8d8000, 0x5e9a0000, 0x5ea68000, 0x5eb30000, 0x5ebf8000, 0x5ecc0000, 0x5ed88000, 0x5ee50000, 0x5ef18000, 0x5efe0000, 0x5f0a8000, 0x5f170000, 0x5f238000, 0x5f300000,
    0x5f3c8000, 0x5f490000, 0x5f558000, 0x5f620000, 0x5f6e8000, 0x5f7b0000, 0x5f878000, 0x5f940000, 0x5fa08000, 0x5fad0000, 0x5fb98000, 0x5fc60000, 0x5fd28000, 0x5fdf0000, 0x5feb8000, 0x5ff80000,
    0x60048000, 0x60110000, 0x601d8000, 0x602a0000, 0x60368000, 0x60430000, 0x604f8000, 0x605c0000, 0x60688000, 0x60750000, 0x60818000, 0x608e0000, 0x609a8000, 0x60a70000, 0x60b38000, 0x60c00000,
    0x60cc8000, 0x60d90000, 0x60e58000, 0x60f20000, 0x60fe8000, 0x610b0000, 0x61178000, 0x61240000, 0x61308000, 0x613d0000, 0x61498000, 0x61560000, 0x61628000, 0x616f0000, 0x617b8000, 0x61880000,
    0x61948000, 0x61a10000, 0x61ad8000, 0x61ba0000, 0x61c68000, 0x61d30000, 0x61df8000, 0x61ec0000, 0x61f88000, 0x62050000, 0x62118000, 0x621e0000, 0x622a8000, 0x62370000, 0x62438000, 0x62500000,
    0x625c8000, 0x62690000, 0x62758000, 0x62820000, 0x628e8000, 0x629b0000, 0x62a78000, 0x62b40000, 0x62c08000, 0x62cd0000, 0x62d98000, 0x62e60000, 0x62f28000, 0x62ff0000, 0x630b8000, 0x63180000,
    0x63248000, 0x63310000, 0x633d8000, 0x634a0000, 0x63568000, 0x63630000, 0x636f8000, 0x637c0000, 0x63888000, 0x63950000, 0x63a18000, 0x63ae0000, 0x63ba8000, 0x63c70000, 0x63d38000, 0x63e00000,
    0x63ec8000, 0x63f90000, 0x64058000, 0x64120000, 0x641e8000, 0x642b0000, 0x64378000, 0x64440000, 0x64508000, 0x645d0000, 0x64698000, 0x64760000, 0x64828000, 0x648f0000, 0x649b8000, 0x64a80000,
    0x64b48000, 0x64c10000, 0x64cd8000, 0x64da0000, 0x64e68000, 0x64f30000, 0x64ff8000, 0x650c0000, 0x65188000, 0x65250000, 0x65318000, 0x653e0000, 0x654a8000, 0x65570000, 0x65638000, 0x65700000,
    0x657c8000, 0x65890000, 0x65958000, 0x65a20000, 0x65ae8000, 0x65bb0000, 0x65c78000, 0x65d40000, 0x65e08000, 0x65ed0000, 0x65f98000, 0x66060000, 0x66128000, 0x661f0000, 0x662b8000, 0x66380000,
    0x66448000, 0x66510000, 0x665d8000, 0x666a0000, 0x66768000, 0x66830000, 0x668f8000, 0x669c0000, 0x66a88000, 0x66b50000, 0x66c18000, 0x66ce0000, 0x66da8000, 0x66e70000, 0x66f38000, 0x67000000,
    0x670c8000, 0x67190000, 0x67258000, 0x67320000, 0x673e8000, 0x674b0000, 0x67578000, 0x67640000, 0x67708000, 0x677d0000, 0x67898000, 0x67960000, 0x67a28000, 0x67af0000, 0x67bb8000, 0x67c80000,
    0x67d48000, 0x67e10000, 0x67ed8000, 0x67fa0000, 0x68068000, 0x68130000, 0x681f8000, 0x682c0000, 0x68388000, 0x68450000, 0x68518000, 0x685e0000, 0x686a8000, 0x68770000, 0x68838000, 0x68900000,
    0x689c8000, 0x68a90000, 0x68b58000, 0x68c20000, 0x68ce8000, 0x68db0000, 0x68e78000, 0x68f40000, 0x69008000, 0x690d0000, 0x69198000, 0x69260000, 0x69328000, 0x693f0000, 0x694b8000, 0x69580000,
    0x69648000, 0x69710000, 0x697d8000, 0x698a0000, 0x69968000, 0x69a30000, 0x69af8000, 0x69bc0000, 0x69c88000, 0x69d50000, 0x69e18000, 0x69ee0000, 0x69fa8000, 0x6a070000, 0x6a138000, 0x6a200000,
    0x6a2c8000, 0x6a390000, 0x6a458000, 0x6a520000, 0x6a5e8000, 0x6a6b0000, 0x6a778000, 0x6a840000, 0x6a908000, 0x6a9d0000, 0x6aa98000, 0x6ab60000, 0x6ac28000, 0x6acf0000, 0x6adb8000, 0x6ae80000,
    0x6af48000, 0x6b010000, 0x6b0d8000, 0x6b1a0000, 0x6b268000, 0x6b330000, 0x6b3f8000, 0x6b4c0000, 0x6b588000, 0x6b650000, 0x6b718000, 0x6b7e0000, 0x6b8a8000, 0x6b970000, 0x6ba38000, 0x6bb00000,
    0x6bbc8000, 0x6bc90000, 0x6bd58000, 0x6be20000, 0x6bee8000, 0x6bfb0000, 0x6c078000, 0x6c140000, 0x6c208000, 0x6c2d0000, 0x6c398000, 0x6c460000, 0x6c528000, 0x6c5f0000, 0x6c6b8000, 0x6c780000,
    0x6c848000, 0x6c910000, 0x6c9d8000, 0x6caa0000, 0x6cb68000, 0x6cc30000, 0x6ccf8000, 0x6cdc0000, 0x6ce88000, 0x6cf50000, 0x6d018000, 0x6d0e0000, 0x6d1a8000, 0x6d270000, 0x6d338000, 0x6d400000,
    0x6d4c8000, 0x6d590000, 0x6d658000, 0x6d720000, 0x6d7e8000, 0x6d8b0000, 0x6d978000, 0x6da40000, 0x6db08000, 0x6dbd0000, 0x6dc98000, 0x6dd60000, 0x6de28000, 0x6def0000, 0x6dfb8000, 0x6e080000,
    0x6e148000, 0x6e210000, 0x6e2d8000, 0x6e3a0000, 0x6e468000, 0x6e530000, 0x6e5f8000, 0x6e6c0000, 0x6e788000, 0x6e850000, 0x6e918000, 0x6e9e0000, 0x6eaa8000, 0x6eb70000, 0x6ec38000, 0x6ed00000,
    0x6edc8000, 0x6ee90000, 0x6ef58000, 0x6f020000, 0x6f0e8000, 0x6f1b0000, 0x6f278000, 0x6f340000, 0x6f408000, 0x6f4d0000, 0x6f598000, 0x6f660000, 0x6f728000, 0x6f7f0000, 0x6f8b8000, 0x6f980000,
    0x6fa48000, 0x6fb10000, 0x6fbd8000, 0x6fca0000, 0x6fd68000, 0x6fe30000, 0x6fef8000, 0x6ffc0000, 0x70088000, 0x70150000, 0x70218000, 0x702e0000, 0x703a8000, 0x70470000, 0x70538000, 0x70600000,
    0x706c8000, 0x70790000, 0x70858000, 0x70920000, 0x709e8000, 0x70ab0000, 0x70b78000, 0x70c40000, 0x70d08000, 0x70dd0000, 0x70e98000, 0x70f60000, 0x71028000, 0x710f0000, 0x711b8000, 0x71280000,
    0x71348000, 0x71410000, 0x714d8000, 0x715a0000, 0x71668000, 0x71730000, 0x717f8000, 0x718c0000, 0x71988000, 0x71a50000, 0x71b18000, 0x71be0000, 0x71ca8000, 0x71d70000, 0x71e38000, 0x71f00000,
    0x71fc8000, 0x72090000, 0x72158000, 0x72220000, 0x722e8000, 0x723b0000, 0x72478000, 0x72540000, 0x72608000, 0x726d0000, 0x72798000, 0x72860000, 0x72928000, 0x729f0000, 0x72ab8000, 0x72b80000,
    0x72c48000, 0x72d10000, 0x72dd8000, 0x72ea0000, 0x72f68000, 0x73030000, 0x730f8000, 0x731c0000, 0x73288000, 0x73350000, 0x73418000, 0x734e0000, 0x735a8000, 0x73670000, 0x73738000, 0x73800000,
    0x738c8000, 0x73990000, 0x73a58000, 0x73b20000, 0x73be8000, 0x73cb0000, 0x73d78000, 0x73e40000, 0x73f08000, 0x73fd0000, 0x74098000, 0x74160000, 0x74228000, 0x742f0000, 0x743b8000, 0x74480000,
    0x74548000, 0x74610000, 0x746d8000, 0x747a0000, 0x74868000, 0x74930000, 0x749f8000, 0x74ac0000, 0x74b88000, 0x74c50000, 0x74d18000, 0x74de0000, 0x74ea8000, 0x74f70000, 0x75038000, 0x75100000,
    0x751c8000, 0x75290000, 0x75358000, 0x75420000, 0x754e8000, 0x755b0000, 0x75678000, 0x75740000, 0x75808000, 0x758d0000, 0x75998000, 0x75a60000, 0x75b28000, 0x75bf0000, 0x75cb8000, 0x75d80000,
    0x75e48000, 0x75f10000, 0x75fd8000, 0x760a0000, 0x76168000, 0x76230000, 0x762f8000, 0x763c0000, 0x76488000, 0x76550000, 0x76618000, 0x766e0000, 0x767a8000, 0x76870000, 0x76938000, 0x76a00000,
    0x76ac8000, 0x76b90000, 0x76c58000, 0x76d20000, 0x76de8000, 0x76eb0000, 0x76f78000, 0x77040000, 0x77108000, 0x771d0000, 0x77298000, 0x77360000, 0x77428000, 0x774f0000, 0x775b8000, 0x77680000,
    0x77748000, 0x77810000, 0x778d8000, 0x779a0000, 0x77a68000, 0x77b30000, 0x77bf8000, 0x77cc0000, 0x77d88000, 0x77e50000, 0x77f18000, 0x77fe0000, 0x780a8000, 0x78170000, 0x78238000, 0x78300000,
    0x783c8000, 0x78490000, 0x78558000, 0x78620000, 0x786e8000, 0x787b0000, 0x78878000, 0x78940000, 0x78a08000, 0x78ad0000, 0x78b98000, 0x78c60000, 0x78d28000, 0x78df0000, 0x78eb8000, 0x78f80000,
    0x79048000, 0x79110000, 0x791d8000, 0x792a0000, 0x79368000, 0x79430000, 0x794f8000, 0x795c0000, 0x79688000, 0x79750000, 0x79818000, 0x798e0000, 0x799a8000, 0x79a70000, 0x79b38000, 0x79c00000,
    0x79cc8000, 0x79d90000, 0x79e58000, 0x79f20000, 0x79fe8000, 0x7a0b0000, 0x7a178000, 0x7a240000, 0x7a308000, 0x7a3d0000, 0x7a498000, 0x7a560000, 0x7a628000, 0x7a6f0000, 0x7a7b8000, 0x7a880000,
    0x7a948000, 0x7aa10000, 0x7aad8000, 0x7aba0000, 0x7ac68000, 0x7ad30000, 0x7adf8000, 0x7aec0000, 0x7af88000, 0x7b050000, 0x7b118000, 0x7b1e0000, 0x7b2a8000, 0x7b370000, 0x7b438000, 0x7b500000,
    0x7b5c8000, 0x7b690000, 0x7b758000, 0x7b820000, 0x7b8e8000, 0x7b9b0000, 0x7ba78000, 0x7bb40000, 0x7bc08000, 0x7bcd0000, 0x7bd98000, 0x7be60000, 0x7bf28000, 0x7bff0000, 0x7c0b8000, 0x7c180000,
    0x7c248000, 0x7c310000, 0x7c3d8000, 0x7c4a0000, 0x7c568000, 0x7c630000, 0x7c6f8000, 0x7c7c0000, 0x7c888000, 0x7c950000, 0x7ca18000, 0x7cae0000, 0x7cba8000, 0x7cc70000, 0x7cd38000, 0x7ce00000,
    0x7cec8000, 0x7cf90000, 0x7d058000, 0x7d120000, 0x7d1e8000, 0x7d2b0000, 0x7d378000, 0x7d440000, 0x7d508000, 0x7d5d0000, 0x7d698000, 0x7d760000, 0x7d828000, 0x7d8f0000, 0x7d9b8000, 0x7da80000,
    0x7db48000, 0x7dc10000, 0x7dcd8000, 0x7dda0000, 0x7de68000, 0x7df30000, 0x7dff8000, 0x7e0c0000, 0x7e188000, 0x7e250000, 0x7e318000, 0x7e3e0000, 0x7e4a8000, 0x7e570000, 0x7e638000, 0x7e700000,
    0x7e7c8000, 0x7e890000, 0x7e958000, 0x7ea20000, 0x7eae8000, 0x7ebb0000, 0x7ec78000, 0x7ed40000, 0x7ee08000, 0x7eed0000, 0x7ef98000, 0x7f060000, 0x7f128000, 0x7f1f0000, 0x7f2b8000, 0x7f380000,
    0x7f448000, 0x7f510000, 0x7f5d8000, 0x7f6a0000, 0x7f768000, 0x7f830000, 0x7f8f8000, 0x7f9c0000, 0x7fa88000, 0x7fb50000, 0x7fc18000, 0x7fce0000, 0x7fda8000, 0x7fe70000, 0x7ff38000, 0x80000000
};

static const uint8_t readaheadtab[] = {
    0x03, 0x02, 0x01, 0x01, 0x1f, 0x1e, 0x1f, 0x11, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f,
    0x10, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e,
    0x1f, 0x0f, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f,
    0x1e, 0x1f, 0x1b, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d,
    0x1f, 0x1e, 0x0e, 0x19, 0x07, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f,
    0x1d, 0x1f, 0x1e, 0x1f, 0x1b, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e,
    0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1a, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f,
    0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1b, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c,
    0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x0d, 0x18, 0x20, 0x06, 0x1e, 0x1f, 0x12, 0x1f, 0x1e, 0x1f,
    0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1b, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e,
    0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1a, 0x08, 0x1e, 0x1f, 0x1d, 0x1f,
    0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1b, 0x1f, 0x1e, 0x1f, 0x1d,
    0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x19, 0x1f, 0x13, 0x1f,
    0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1b, 0x09, 0x1e,
    0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x1f, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1a, 0x14,
    0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1c, 0x0a, 0x1e, 0x1f, 0x1d, 0x1f, 0x1e, 0x1f, 0x1b,
    0x15, 0x1e, 0x1f, 0x1d, 0x0b, 0x1e, 0x1f, 0x1c, 0x16, 0x1e, 0x0c, 0x1d, 0x17, 0x1e, 0x1f,
    0x20
};

//values between 0 and 1 multiplied by 2^23 to avoid floating point numbers.
static const int32_t gaintab[] = {
    0x800000, 0x7ff144, 0x7fe28a, 0x7fd3d2, 0x7fc51b, 0x7fb666, 0x7fa7b3, 0x7f9901, 0x7f8a52, 0x7f7ba3, 0x7f6cf7, 0x7f5e4c, 0x7f4fa3, 0x7f40fc, 0x7f3256,
    0x7f23b2, 0x7f1510, 0x7f066f, 0x7ef7d0, 0x7ee933, 0x7eda97, 0x7ecbfd, 0x7ebd65, 0x7eaece, 0x7ea039, 0x7e91a6, 0x7e8315, 0x7e7485, 0x7e65f6, 0x7e576a,
    0x7e48df, 0x7e3a56, 0x7e2bce, 0x7e1d49, 0x7e0ec5, 0x7e0042, 0x7df1c1, 0x7de342, 0x7dd4c5, 0x7dc649, 0x7db7cf, 0x7da956, 0x7d9adf, 0x7d8c6a, 0x7d7df7,
    0x7d6f85, 0x7d6115, 0x7d52a6, 0x7d443a, 0x7d35ce, 0x7d2765, 0x7d18fd, 0x7d0a97, 0x7cfc32, 0x7cedd0, 0x7cdf6e, 0x7cd10f, 0x7cc2b1, 0x7cb455, 0x7ca5fa,
    0x7c97a1, 0x7c894a, 0x7c7af4, 0x7c6ca0, 0x7c5e4e, 0x7c4ffd, 0x7c41ae, 0x7c3361, 0x7c2515, 0x7c16cb, 0x7c0882, 0x7bfa3b, 0x7bebf6, 0x7bddb3, 0x7bcf71,
    0x7bc131, 0x7bb2f2, 0x7ba4b5, 0x7b967a, 0x7b8840, 0x7b7a08, 0x7b6bd2, 0x7b5d9d, 0x7b4f6a, 0x7b4138, 0x7b3308, 0x7b24da, 0x7b16ad, 0x7b0882, 0x7afa59,
    0x7aec31, 0x7ade0b, 0x7acfe7, 0x7ac1c4, 0x7ab3a3, 0x7aa583, 0x7a9765, 0x7a8949, 0x7a7b2e, 0x7a6d15, 0x7a5efd, 0x7a50e8, 0x7a42d3, 0x7a34c1, 0x7a26b0,
    0x7a18a0, 0x7a0a93, 0x79fc87, 0x79ee7c, 0x79e073, 0x79d26c, 0x79c466, 0x79b662, 0x79a860, 0x799a5f, 0x798c60, 0x797e62, 0x797066, 0x79626c, 0x795473,
    0x79467c, 0x793886, 0x792a92, 0x791ca0, 0x790eaf, 0x7900c0, 0x78f2d3, 0x78e4e7, 0x78d6fc, 0x78c914, 0x78bb2d, 0x78ad47, 0x789f63, 0x789181, 0x7883a0,
    0x7875c1, 0x7867e3, 0x785a07, 0x784c2d, 0x783e54, 0x78307d, 0x7822a8, 0x7814d4, 0x780701, 0x77f931, 0x77eb61, 0x77dd94, 0x77cfc8, 0x77c1fd, 0x77b434,
    0x77a66d, 0x7798a8, 0x778ae3, 0x777d21, 0x776f60, 0x7761a1, 0x7753e3, 0x774627, 0x77386c, 0x772ab3, 0x771cfc, 0x770f46, 0x770192, 0x76f3df, 0x76e62e,
    0x76d87e, 0x76cad0, 0x76bd24, 0x76af79, 0x76a1d0, 0x769428, 0x768682, 0x7678de, 0x766b3b, 0x765d99, 0x764ffa, 0x76425b, 0x7634bf, 0x762723, 0x76198a,
    0x760bf2, 0x75fe5c, 0x75f0c7, 0x75e333, 0x75d5a2, 0x75c811, 0x75ba83, 0x75acf6, 0x759f6a, 0x7591e0, 0x758458, 0x7576d1, 0x75694c, 0x755bc8, 0x754e46,
    0x7540c6, 0x753347, 0x7525c9, 0x75184d, 0x750ad3, 0x74fd5a, 0x74efe3, 0x74e26d, 0x74d4f9, 0x74c786, 0x74ba15, 0x74aca6, 0x749f38, 0x7491cb, 0x748460,
    0x7476f7, 0x74698f, 0x745c29, 0x744ec4, 0x744161, 0x7433ff, 0x74269f, 0x741941, 0x740be4, 0x73fe88, 0x73f12e, 0x73e3d6, 0x73d67f, 0x73c92a, 0x73bbd6,
    0x73ae84, 0x73a133, 0x7393e4, 0x738696, 0x73794a, 0x736bff, 0x735eb6, 0x73516f, 0x734429, 0x7336e4, 0x7329a1, 0x731c60, 0x730f20, 0x7301e1, 0x72f4a5,
    0x72e769, 0x72da2f, 0x72ccf7, 0x72bfc0, 0x72b28b, 0x72a557, 0x729825, 0x728af4, 0x727dc5, 0x727098, 0x72636c, 0x725641, 0x724918, 0x723bf0, 0x722eca,
    0x7221a6, 0x721482, 0x720761, 0x71fa41, 0x71ed22, 0x71e005, 0x71d2ea, 0x71c5d0, 0x71b8b7, 0x71aba0, 0x719e8b, 0x719177, 0x718465, 0x717754, 0x716a44,
    0x715d36, 0x71502a, 0x71431f, 0x713615, 0x71290e, 0x711c07, 0x710f02, 0x7101ff, 0x70f4fd, 0x70e7fc, 0x70dafd, 0x70ce00, 0x70c104, 0x70b40a, 0x70a711,
    0x709a19, 0x708d23, 0x70802f, 0x70733c, 0x70664a, 0x70595a, 0x704c6c, 0x703f7f, 0x703293, 0x7025a9, 0x7018c0, 0x700bd9, 0x6ffef4, 0x6ff20f, 0x6fe52d,
    0x6fd84c, 0x6fcb6c, 0x6fbe8e, 0x6fb1b1, 0x6fa4d6, 0x6f97fc, 0x6f8b24, 0x6f7e4d, 0x6f7178, 0x6f64a4, 0x6f57d2, 0x6f4b01, 0x6f3e31, 0x6f3163, 0x6f2497,
    0x6f17cc, 0x6f0b02, 0x6efe3a, 0x6ef174, 0x6ee4af, 0x6ed7eb, 0x6ecb29, 0x6ebe68, 0x6eb1a9, 0x6ea4eb, 0x6e982f, 0x6e8b74, 0x6e7ebb, 0x6e7203, 0x6e654c,
    0x6e5897, 0x6e4be4, 0x6e3f32, 0x6e3281, 0x6e25d2, 0x6e1924, 0x6e0c78, 0x6dffcd, 0x6df324, 0x6de67c, 0x6dd9d6, 0x6dcd31, 0x6dc08e, 0x6db3ec, 0x6da74b,
    0x6d9aac, 0x6d8e0e, 0x6d8172, 0x6d74d7, 0x6d683e, 0x6d5ba6, 0x6d4f10, 0x6d427b, 0x6d35e7, 0x6d2955, 0x6d1cc5, 0x6d1036, 0x6d03a8, 0x6cf71c, 0x6cea91,
    0x6cde07, 0x6cd17f, 0x6cc4f9, 0x6cb874, 0x6cabf0, 0x6c9f6e, 0x6c92ed, 0x6c866e, 0x6c79f0, 0x6c6d74, 0x6c60f9, 0x6c547f, 0x6c4807, 0x6c3b91, 0x6c2f1b,
    0x6c22a8, 0x6c1635, 0x6c09c4, 0x6bfd55, 0x6bf0e7, 0x6be47a, 0x6bd80f, 0x6bcba5, 0x6bbf3d, 0x6bb2d6, 0x6ba670, 0x6b9a0c, 0x6b8daa, 0x6b8148, 0x6b74e9,
    0x6b688a, 0x6b5c2d, 0x6b4fd2, 0x6b4378, 0x6b371f, 0x6b2ac8, 0x6b1e72, 0x6b121d, 0x6b05ca, 0x6af979, 0x6aed29, 0x6ae0da, 0x6ad48d, 0x6ac841, 0x6abbf6,
    0x6aafad, 0x6aa365, 0x6a971f, 0x6a8ada, 0x6a7e97, 0x6a7255, 0x6a6614, 0x6a59d5, 0x6a4d97, 0x6a415b, 0x6a3520, 0x6a28e6, 0x6a1cae, 0x6a1078, 0x6a0442,
    0x69f80e, 0x69ebdc, 0x69dfab, 0x69d37b, 0x69c74d, 0x69bb20, 0x69aef4, 0x69a2ca, 0x6996a1, 0x698a7a, 0x697e54, 0x697230, 0x69660c, 0x6959eb, 0x694dca,
    0x6941ab, 0x69358e, 0x692972, 0x691d57, 0x69113e, 0x690526, 0x68f90f, 0x68ecfa, 0x68e0e6, 0x68d4d4, 0x68c8c3, 0x68bcb3, 0x68b0a5, 0x68a498, 0x68988d,
    0x688c83, 0x68807a, 0x687473, 0x68686d, 0x685c68, 0x685065, 0x684463, 0x683863, 0x682c64, 0x682066, 0x68146a, 0x68086f, 0x67fc76, 0x67f07d, 0x67e487,
    0x67d891, 0x67cc9d, 0x67c0ab, 0x67b4ba, 0x67a8ca, 0x679cdb, 0x6790ee, 0x678502, 0x677918, 0x676d2f, 0x676147, 0x675561, 0x67497c, 0x673d99, 0x6731b7,
    0x6725d6, 0x6719f7, 0x670e19, 0x67023c, 0x66f661, 0x66ea87, 0x66deae, 0x66d2d7, 0x66c701, 0x66bb2d, 0x66af59, 0x66a388, 0x6697b7, 0x668be8, 0x66801a,
    0x66744e, 0x666883, 0x665cba, 0x6650f1, 0x66452a, 0x663965, 0x662da1, 0x6621de, 0x66161c, 0x660a5c, 0x65fe9e, 0x65f2e0, 0x65e724, 0x65db69, 0x65cfb0,
    0x65c3f8, 0x65b841, 0x65ac8c, 0x65a0d8, 0x659525, 0x658974, 0x657dc4, 0x657216, 0x656668, 0x655abc, 0x654f12, 0x654369, 0x6537c1, 0x652c1a, 0x652075,
    0x6514d1, 0x65092f, 0x64fd8d, 0x64f1ee, 0x64e64f, 0x64dab2, 0x64cf16, 0x64c37c, 0x64b7e3, 0x64ac4b, 0x64a0b4, 0x64951f, 0x64898b, 0x647df9, 0x647268,
    0x6466d8, 0x645b49, 0x644fbc, 0x644430, 0x6438a6, 0x642d1d, 0x642195, 0x64160e, 0x640a89, 0x63ff05, 0x63f383, 0x63e802, 0x63dc82, 0x63d103, 0x63c586,
    0x63ba0a, 0x63ae8f, 0x63a316, 0x63979e, 0x638c28, 0x6380b2, 0x63753e, 0x6369cc, 0x635e5a, 0x6352ea, 0x63477b, 0x633c0e, 0x6330a2, 0x632537, 0x6319ce,
    0x630e66, 0x6302ff, 0x62f799, 0x62ec35, 0x62e0d2, 0x62d571, 0x62ca10, 0x62beb1, 0x62b354, 0x62a7f7, 0x629c9c, 0x629142, 0x6285ea, 0x627a93, 0x626f3d,
    0x6263e9, 0x625895, 0x624d43, 0x6241f3, 0x6236a4, 0x622b56, 0x622009, 0x6214bd, 0x620973, 0x61fe2b, 0x61f2e3, 0x61e79d, 0x61dc58, 0x61d114, 0x61c5d2,
    0x61ba91, 0x61af51, 0x61a413, 0x6198d6, 0x618d9a, 0x61825f, 0x617726, 0x616bee, 0x6160b7, 0x615582, 0x614a4e, 0x613f1b, 0x6133ea, 0x6128b9, 0x611d8a,
    0x61125d, 0x610730, 0x60fc05, 0x60f0dc, 0x60e5b3, 0x60da8c, 0x60cf66, 0x60c441, 0x60b91e, 0x60adfc, 0x60a2db, 0x6097bc, 0x608c9d, 0x608180, 0x607665,
    0x606b4a, 0x606031, 0x605519, 0x604a03, 0x603eed, 0x6033d9, 0x6028c7, 0x601db5, 0x6012a5, 0x600796, 0x5ffc88, 0x5ff17c, 0x5fe671, 0x5fdb67, 0x5fd05e,
    0x5fc557, 0x5fba51, 0x5faf4c, 0x5fa449, 0x5f9947, 0x5f8e46, 0x5f8346, 0x5f7848, 0x5f6d4a, 0x5f624e, 0x5f5754, 0x5f4c5a, 0x5f4162, 0x5f366c, 0x5f2b76,
    0x5f2082, 0x5f158f, 0x5f0a9d, 0x5effac, 0x5ef4bd, 0x5ee9cf, 0x5edee2, 0x5ed3f7, 0x5ec90c, 0x5ebe23, 0x5eb33c, 0x5ea855, 0x5e9d70, 0x5e928c, 0x5e87a9,
    0x5e7cc8, 0x5e71e8, 0x5e6709, 0x5e5c2b, 0x5e514f, 0x5e4673, 0x5e3b99, 0x5e30c1, 0x5e25e9, 0x5e1b13, 0x5e103e, 0x5e056a, 0x5dfa98, 0x5defc7, 0x5de4f7,
    0x5dda28, 0x5dcf5a, 0x5dc48e, 0x5db9c3, 0x5daef9, 0x5da431, 0x5d996a, 0x5d8ea4, 0x5d83df, 0x5d791b, 0x5d6e59, 0x5d6398, 0x5d58d8, 0x5d4e19, 0x5d435c,
    0x5d38a0, 0x5d2de5, 0x5d232b, 0x5d1873, 0x5d0dbc, 0x5d0306, 0x5cf851, 0x5ced9d, 0x5ce2eb, 0x5cd83a, 0x5ccd8a, 0x5cc2dc, 0x5cb82e, 0x5cad82, 0x5ca2d7,
    0x5c982e, 0x5c8d85, 0x5c82de, 0x5c7838, 0x5c6d93, 0x5c62f0, 0x5c584e, 0x5c4dad, 0x5c430d, 0x5c386e, 0x5c2dd1, 0x5c2334, 0x5c1899, 0x5c0e00, 0x5c0367,
    0x5bf8d0, 0x5bee3a, 0x5be3a5, 0x5bd911, 0x5bce7f, 0x5bc3ee, 0x5bb95e, 0x5baecf, 0x5ba441, 0x5b99b5, 0x5b8f2a, 0x5b84a0, 0x5b7a17, 0x5b6f90, 0x5b6509,
    0x5b5a84, 0x5b5000, 0x5b457e, 0x5b3afc, 0x5b307c, 0x5b25fd, 0x5b1b7f, 0x5b1103, 0x5b0687, 0x5afc0d, 0x5af194, 0x5ae71c, 0x5adca6, 0x5ad230, 0x5ac7bc,
    0x5abd49, 0x5ab2d7, 0x5aa867, 0x5a9df7, 0x5a9389, 0x5a891c, 0x5a7eb1, 0x5a7446, 0x5a69dd, 0x5a5f74, 0x5a550d, 0x5a4aa8, 0x5a4043, 0x5a35e0, 0x5a2b7e,
    0x5a211d, 0x5a16bd, 0x5a0c5e, 0x5a0201, 0x59f7a5, 0x59ed4a, 0x59e2f0, 0x59d897, 0x59ce40, 0x59c3e9, 0x59b994, 0x59af40, 0x59a4ee, 0x599a9c, 0x59904c,
    0x5985fd, 0x597baf, 0x597162, 0x596717, 0x595ccc, 0x595283, 0x59483b, 0x593df4, 0x5933ae, 0x59296a, 0x591f27, 0x5914e5, 0x590aa4, 0x590064, 0x58f625,
    0x58ebe8, 0x58e1ac, 0x58d771, 0x58cd37, 0x58c2fe, 0x58b8c7, 0x58ae90, 0x58a45b, 0x589a27, 0x588ff5, 0x5885c3, 0x587b93, 0x587163, 0x586735, 0x585d08,
    0x5852dc, 0x5848b2, 0x583e88, 0x583460, 0x582a39, 0x582013, 0x5815ee, 0x580bcb, 0x5801a9, 0x57f787, 0x57ed67, 0x57e348, 0x57d92b, 0x57cf0e, 0x57c4f3,
    0x57bad8, 0x57b0bf, 0x57a6a7, 0x579c91, 0x57927b, 0x578866, 0x577e53, 0x577441, 0x576a30, 0x576020, 0x575612, 0x574c04, 0x5741f8, 0x5737ed, 0x572de3,
    0x5723da, 0x5719d2, 0x570fcc, 0x5705c6, 0x56fbc2, 0x56f1bf, 0x56e7bd, 0x56ddbc, 0x56d3bc, 0x56c9be, 0x56bfc1, 0x56b5c4, 0x56abc9, 0x56a1cf, 0x5697d7,
    0x568ddf, 0x5683e9, 0x5679f3, 0x566fff, 0x56660c, 0x565c1a, 0x56522a, 0x56483a, 0x563e4c, 0x56345e, 0x562a72, 0x562087, 0x56169d, 0x560cb5, 0x5602cd,
    0x55f8e7, 0x55ef01, 0x55e51d, 0x55db3a, 0x55d158, 0x55c777, 0x55bd98, 0x55b3b9, 0x55a9dc, 0x55a000, 0x559625, 0x558c4b, 0x558272, 0x55789a, 0x556ec4,
    0x5564ee, 0x555b1a, 0x555147, 0x554775, 0x553da4, 0x5533d4, 0x552a06, 0x552038, 0x55166c, 0x550ca1, 0x5502d7, 0x54f90e, 0x54ef46, 0x54e57f, 0x54dbba,
    0x54d1f5, 0x54c832, 0x54be6f, 0x54b4ae, 0x54aaee, 0x54a130, 0x549772, 0x548db5, 0x5483fa, 0x547a3f, 0x547086, 0x5466ce, 0x545d17, 0x545361, 0x5449ac,
    0x543ff9, 0x543646, 0x542c95, 0x5422e4, 0x541935, 0x540f87, 0x5405da, 0x53fc2e, 0x53f283, 0x53e8da, 0x53df31, 0x53d58a, 0x53cbe4, 0x53c23e, 0x53b89a,
    0x53aef7, 0x53a555, 0x539bb5, 0x539215, 0x538877, 0x537ed9, 0x53753d, 0x536ba2, 0x536208, 0x53586f, 0x534ed7, 0x534540, 0x533baa, 0x533216, 0x532882,
    0x531ef0, 0x53155e, 0x530bce, 0x53023f, 0x52f8b1, 0x52ef24, 0x52e599, 0x52dc0e, 0x52d284, 0x52c8fc, 0x52bf74, 0x52b5ee, 0x52ac69, 0x52a2e5, 0x529962,
    0x528fe0, 0x52865f, 0x527cdf, 0x527361, 0x5269e3, 0x526067, 0x5256eb, 0x524d71, 0x5243f8, 0x523a80, 0x523109, 0x522793, 0x521e1e, 0x5214ab, 0x520b38,
    0x5201c6, 0x51f856, 0x51eee7, 0x51e578, 0x51dc0b, 0x51d29f, 0x51c934, 0x51bfca, 0x51b661, 0x51acf9, 0x51a393, 0x519a2d, 0x5190c9, 0x518765, 0x517e03,
    0x5174a1, 0x516b41, 0x5161e2, 0x515884, 0x514f27, 0x5145cb, 0x513c70, 0x513317, 0x5129be, 0x512066, 0x511710, 0x510dba, 0x510466, 0x50fb13, 0x50f1c1,
    0x50e86f, 0x50df1f, 0x50d5d0, 0x50cc82, 0x50c336, 0x50b9ea, 0x50b09f, 0x50a755, 0x509e0d, 0x5094c5, 0x508b7f, 0x50823a, 0x5078f5, 0x506fb2, 0x506670,
    0x505d2f, 0x5053ef, 0x504ab0, 0x504172, 0x503835, 0x502ef9, 0x5025be, 0x501c85, 0x50134c, 0x500a15, 0x5000de, 0x4ff7a9, 0x4fee74, 0x4fe541, 0x4fdc0f,
    0x4fd2de, 0x4fc9ae, 0x4fc07e, 0x4fb750, 0x4fae23, 0x4fa4f8, 0x4f9bcd, 0x4f92a3, 0x4f897a, 0x4f8053, 0x4f772c, 0x4f6e06, 0x4f64e2, 0x4f5bbe, 0x4f529c,
    0x4f497b, 0x4f405a, 0x4f373b, 0x4f2e1d, 0x4f2500, 0x4f1be4, 0x4f12c9, 0x4f09af, 0x4f0096, 0x4ef77e, 0x4eee67, 0x4ee551, 0x4edc3c, 0x4ed328, 0x4eca16,
    0x4ec104, 0x4eb7f3, 0x4eaee4, 0x4ea5d5, 0x4e9cc8, 0x4e93bc, 0x4e8ab0, 0x4e81a6, 0x4e789c, 0x4e6f94, 0x4e668d, 0x4e5d87, 0x4e5482, 0x4e4b7e, 0x4e427a,
    0x4e3978, 0x4e3077, 0x4e2777, 0x4e1e79, 0x4e157b, 0x4e0c7e, 0x4e0382, 0x4dfa87, 0x4df18d, 0x4de895, 0x4ddf9d, 0x4dd6a6, 0x4dcdb1, 0x4dc4bc, 0x4dbbc9,
    0x4db2d6, 0x4da9e5, 0x4da0f4, 0x4d9805, 0x4d8f16, 0x4d8629, 0x4d7d3c, 0x4d7451, 0x4d6b67, 0x4d627e, 0x4d5995, 0x4d50ae, 0x4d47c8, 0x4d3ee3, 0x4d35ff,
    0x4d2d1b, 0x4d2439, 0x4d1b58, 0x4d1278, 0x4d0999, 0x4d00bb, 0x4cf7de, 0x4cef02, 0x4ce627, 0x4cdd4d, 0x4cd474, 0x4ccb9c, 0x4cc2c5, 0x4cb9f0, 0x4cb11b,
    0x4ca847, 0x4c9f74, 0x4c96a2, 0x4c8dd1, 0x4c8502, 0x4c7c33, 0x4c7365, 0x4c6a98, 0x4c61cd, 0x4c5902, 0x4c5038, 0x4c4770, 0x4c3ea8, 0x4c35e1, 0x4c2d1c,
    0x4c2457, 0x4c1b93, 0x4c12d1, 0x4c0a0f, 0x4c014f, 0x4bf88f, 0x4befd0, 0x4be713, 0x4bde56, 0x4bd59b, 0x4bcce0, 0x4bc426, 0x4bbb6e, 0x4bb2b6, 0x4baa00,
    0x4ba14a, 0x4b9896, 0x4b8fe2, 0x4b8730, 0x4b7e7e, 0x4b75cd, 0x4b6d1e, 0x4b646f, 0x4b5bc2, 0x4b5315, 0x4b4a6a, 0x4b41bf, 0x4b3916, 0x4b306d, 0x4b27c6,
    0x4b1f1f, 0x4b1679, 0x4b0dd5, 0x4b0531, 0x4afc8f, 0x4af3ed, 0x4aeb4c, 0x4ae2ad, 0x4ada0e, 0x4ad171, 0x4ac8d4, 0x4ac038, 0x4ab79e, 0x4aaf04, 0x4aa66b,
    0x4a9dd4, 0x4a953d, 0x4a8ca7, 0x4a8413, 0x4a7b7f, 0x4a72ec, 0x4a6a5a, 0x4a61ca, 0x4a593a, 0x4a50ab, 0x4a481d, 0x4a3f91, 0x4a3705, 0x4a2e7a, 0x4a25f0,
    0x4a1d67, 0x4a14df, 0x4a0c58, 0x4a03d2, 0x49fb4d, 0x49f2c9, 0x49ea46, 0x49e1c4, 0x49d943, 0x49d0c3, 0x49c844, 0x49bfc6, 0x49b749, 0x49aecd, 0x49a652,
    0x499dd7, 0x49955e, 0x498ce6, 0x49846f, 0x497bf8, 0x497383, 0x496b0f, 0x49629b, 0x495a29, 0x4951b8, 0x494947, 0x4940d8, 0x493869, 0x492ffc, 0x49278f,
    0x491f23, 0x4916b9, 0x490e4f, 0x4905e6, 0x48fd7f, 0x48f518, 0x48ecb2, 0x48e44d, 0x48dbe9, 0x48d386, 0x48cb25, 0x48c2c4, 0x48ba64, 0x48b205, 0x48a9a6,
    0x48a149, 0x4898ed, 0x489092, 0x488838, 0x487fdf, 0x487786, 0x486f2f, 0x4866d8, 0x485e83, 0x48562f, 0x484ddb, 0x484589, 0x483d37, 0x4834e6, 0x482c97,
    0x482448, 0x481bfa, 0x4813ad, 0x480b62, 0x480317, 0x47facd, 0x47f284, 0x47ea3c, 0x47e1f5, 0x47d9ae, 0x47d169, 0x47c925, 0x47c0e2, 0x47b89f, 0x47b05e,
    0x47a81e, 0x479fde, 0x4797a0, 0x478f62, 0x478725, 0x477eea, 0x4776af, 0x476e75, 0x47663c, 0x475e05, 0x4755ce, 0x474d98, 0x474563, 0x473d2f, 0x4734fb,
    0x472cc9, 0x472498, 0x471c68, 0x471438, 0x470c0a, 0x4703dc, 0x46fbb0, 0x46f384, 0x46eb59, 0x46e330, 0x46db07, 0x46d2df, 0x46cab8, 0x46c292, 0x46ba6d,
    0x46b249, 0x46aa26, 0x46a203, 0x4699e2, 0x4691c2, 0x4689a2, 0x468184, 0x467966, 0x46714a, 0x46692e, 0x466113, 0x4658f9, 0x4650e0, 0x4648c9, 0x4640b1,
    0x46389b, 0x463086, 0x462872, 0x46205f, 0x46184c, 0x46103b, 0x46082a, 0x46001b, 0x45f80c, 0x45effe, 0x45e7f2, 0x45dfe6, 0x45d7db, 0x45cfd1, 0x45c7c8,
    0x45bfbf, 0x45b7b8, 0x45afb2, 0x45a7ac, 0x459fa8, 0x4597a4, 0x458fa2, 0x4587a0, 0x457f9f, 0x45779f, 0x456fa0, 0x4567a2, 0x455fa5, 0x4557a9, 0x454fae,
    0x4547b3, 0x453fba, 0x4537c1, 0x452fca, 0x4527d3, 0x451fdd, 0x4517e8, 0x450ff5, 0x450802, 0x45000f, 0x44f81e, 0x44f02e, 0x44e83f, 0x44e050, 0x44d863,
    0x44d076, 0x44c88a, 0x44c09f, 0x44b8b6, 0x44b0cd, 0x44a8e4, 0x44a0fd, 0x449917, 0x449132, 0x44894d, 0x44816a, 0x447987, 0x4471a5, 0x4469c5, 0x4461e5,
    0x445a06, 0x445228, 0x444a4b, 0x44426e, 0x443a93, 0x4432b8, 0x442adf, 0x442306, 0x441b2e, 0x441358, 0x440b82, 0x4403ad, 0x43fbd8, 0x43f405, 0x43ec33,
    0x43e461, 0x43dc91, 0x43d4c1, 0x43ccf3, 0x43c525, 0x43bd58, 0x43b58c, 0x43adc1, 0x43a5f6, 0x439e2d, 0x439664, 0x438e9d, 0x4386d6, 0x437f10, 0x43774c,
    0x436f88, 0x4367c5, 0x436002, 0x435841, 0x435081, 0x4348c1, 0x434102, 0x433945, 0x433188, 0x4329cc, 0x432211, 0x431a57, 0x43129d, 0x430ae5, 0x43032e,
    0x42fb77, 0x42f3c1, 0x42ec0c, 0x42e458, 0x42dca5, 0x42d4f3, 0x42cd42, 0x42c591, 0x42bde2, 0x42b633, 0x42ae85, 0x42a6d9, 0x429f2d, 0x429781, 0x428fd7,
    0x42882e, 0x428085, 0x4278de, 0x427137, 0x426991, 0x4261ec, 0x425a48, 0x4252a5, 0x424b03, 0x424361, 0x423bc1, 0x423421, 0x422c82, 0x4224e5, 0x421d48,
    0x4215ab, 0x420e10, 0x420676, 0x41fedc, 0x41f744, 0x41efac, 0x41e815, 0x41e07f, 0x41d8ea, 0x41d155, 0x41c9c2, 0x41c22f, 0x41ba9e, 0x41b30d, 0x41ab7d,
    0x41a3ee, 0x419c60, 0x4194d2, 0x418d46, 0x4185ba, 0x417e30, 0x4176a6, 0x416f1d, 0x416795, 0x41600d, 0x415887, 0x415102, 0x41497d, 0x4141f9, 0x413a76,
    0x4132f4, 0x412b73, 0x4123f3, 0x411c73, 0x4114f5, 0x410d77, 0x4105fa, 0x40fe7e, 0x40f703, 0x40ef89, 0x40e80f, 0x40e097, 0x40d91f, 0x40d1a8, 0x40ca32,
    0x40c2bd, 0x40bb49, 0x40b3d5, 0x40ac63, 0x40a4f1, 0x409d80, 0x409610, 0x408ea1, 0x408733, 0x407fc5, 0x407859, 0x4070ed, 0x406982, 0x406218, 0x405aaf,
    0x405347, 0x404bdf, 0x404479, 0x403d13, 0x4035ae, 0x402e4a, 0x4026e7, 0x401f85, 0x401823, 0x4010c3, 0x400963, 0x400204, 0x3ffaa6, 0x3ff348, 0x3febec,
    0x3fe490, 0x3fdd36, 0x3fd5dc, 0x3fce83, 0x3fc72b, 0x3fbfd3, 0x3fb87d, 0x3fb127, 0x3fa9d3, 0x3fa27f, 0x3f9b2c, 0x3f93d9, 0x3f8c88, 0x3f8537, 0x3f7de8,
    0x3f7699, 0x3f6f4b, 0x3f67fd, 0x3f60b1, 0x3f5966, 0x3f521b, 0x3f4ad1, 0x3f4388, 0x3f3c40, 0x3f34f9, 0x3f2db2, 0x3f266c, 0x3f1f28, 0x3f17e4, 0x3f10a1,
    0x3f095e, 0x3f021d, 0x3efadc, 0x3ef39c, 0x3eec5d, 0x3ee51f, 0x3edde2, 0x3ed6a6, 0x3ecf6a, 0x3ec82f, 0x3ec0f5, 0x3eb9bc, 0x3eb284, 0x3eab4c, 0x3ea416,
    0x3e9ce0, 0x3e95ab, 0x3e8e77, 0x3e8743, 0x3e8011, 0x3e78df, 0x3e71ae, 0x3e6a7e, 0x3e634f, 0x3e5c21, 0x3e54f3, 0x3e4dc7, 0x3e469b, 0x3e3f70, 0x3e3845,
    0x3e311c, 0x3e29f3, 0x3e22cc, 0x3e1ba5, 0x3e147f, 0x3e0d59, 0x3e0635, 0x3dff11, 0x3df7ef, 0x3df0cd, 0x3de9ab, 0x3de28b, 0x3ddb6b, 0x3dd44d, 0x3dcd2f,
    0x3dc612, 0x3dbef6, 0x3db7da, 0x3db0c0, 0x3da9a6, 0x3da28d, 0x3d9b75, 0x3d945d, 0x3d8d47, 0x3d8631, 0x3d7f1c, 0x3d7808, 0x3d70f5, 0x3d69e2, 0x3d62d1,
    0x3d5bc0, 0x3d54b0, 0x3d4da1, 0x3d4692, 0x3d3f85, 0x3d3878, 0x3d316c, 0x3d2a61, 0x3d2356, 0x3d1c4d, 0x3d1544, 0x3d0e3c, 0x3d0735, 0x3d002f, 0x3cf929,
    0x3cf225, 0x3ceb21, 0x3ce41e, 0x3cdd1c, 0x3cd61a, 0x3ccf1a, 0x3cc81a, 0x3cc11b, 0x3cba1c, 0x3cb31f, 0x3cac22, 0x3ca527, 0x3c9e2c, 0x3c9731, 0x3c9038,
    0x3c893f, 0x3c8248, 0x3c7b51, 0x3c745b, 0x3c6d65, 0x3c6671, 0x3c5f7d, 0x3c588a, 0x3c5198, 0x3c4aa6, 0x3c43b6, 0x3c3cc6, 0x3c35d7, 0x3c2ee9, 0x3c27fb,
    0x3c210f, 0x3c1a23, 0x3c1338, 0x3c0c4e, 0x3c0564, 0x3bfe7c, 0x3bf794, 0x3bf0ad, 0x3be9c7, 0x3be2e1, 0x3bdbfd, 0x3bd519, 0x3bce36, 0x3bc753, 0x3bc072,
    0x3bb991, 0x3bb2b1, 0x3babd2, 0x3ba4f4, 0x3b9e17, 0x3b973a, 0x3b905e, 0x3b8983, 0x3b82a8, 0x3b7bcf, 0x3b74f6, 0x3b6e1e, 0x3b6747, 0x3b6070, 0x3b599b,
    0x3b52c6, 0x3b4bf2, 0x3b451f, 0x3b3e4c, 0x3b377b, 0x3b30aa, 0x3b29da, 0x3b230a, 0x3b1c3c, 0x3b156e, 0x3b0ea1, 0x3b07d5, 0x3b0109, 0x3afa3f, 0x3af375,
    0x3aecac, 0x3ae5e3, 0x3adf1c, 0x3ad855, 0x3ad18f, 0x3acaca, 0x3ac406, 0x3abd42, 0x3ab67f, 0x3aafbd, 0x3aa8fc, 0x3aa23b, 0x3a9b7c, 0x3a94bd, 0x3a8dfe,
    0x3a8741, 0x3a8084, 0x3a79c9, 0x3a730d, 0x3a6c53, 0x3a659a, 0x3a5ee1, 0x3a5829, 0x3a5172, 0x3a4abb, 0x3a4406, 0x3a3d51, 0x3a369d, 0x3a2fe9, 0x3a2937,
    0x3a2285, 0x3a1bd4, 0x3a1524, 0x3a0e74, 0x3a07c5, 0x3a0118, 0x39fa6a, 0x39f3be, 0x39ed12, 0x39e667, 0x39dfbd, 0x39d914, 0x39d26b, 0x39cbc4, 0x39c51d,
    0x39be76, 0x39b7d1, 0x39b12c, 0x39aa88, 0x39a3e5, 0x399d42, 0x3996a1, 0x399000, 0x398960, 0x3982c0, 0x397c22, 0x397584, 0x396ee7, 0x39684a, 0x3961af,
    0x395b14, 0x39547a, 0x394de0, 0x394748, 0x3940b0, 0x393a19, 0x393383, 0x392ced, 0x392658, 0x391fc4, 0x391931, 0x39129f, 0x390c0d, 0x39057c, 0x38feec,
    0x38f85c, 0x38f1ce, 0x38eb40, 0x38e4b2, 0x38de26, 0x38d79a, 0x38d10f, 0x38ca85, 0x38c3fc, 0x38bd73, 0x38b6eb, 0x38b064, 0x38a9de, 0x38a358, 0x389cd3,
    0x38964f, 0x388fcb, 0x388949, 0x3882c7, 0x387c46, 0x3875c5, 0x386f45, 0x3868c7, 0x386248, 0x385bcb, 0x38554e, 0x384ed2, 0x384857, 0x3841dd, 0x383b63,
    0x3834ea, 0x382e72, 0x3827fa, 0x382184, 0x381b0e, 0x381498, 0x380e24, 0x3807b0, 0x38013d, 0x37facb, 0x37f459, 0x37ede9, 0x37e778, 0x37e109, 0x37da9b,
    0x37d42d, 0x37cdc0, 0x37c753, 0x37c0e8, 0x37ba7d, 0x37b413, 0x37ada9, 0x37a741, 0x37a0d9, 0x379a72, 0x37940b, 0x378da6, 0x378741, 0x3780dc, 0x377a79,
    0x377416, 0x376db4, 0x376753, 0x3760f2, 0x375a93, 0x375433, 0x374dd5, 0x374777, 0x37411b, 0x373abe, 0x373463, 0x372e08, 0x3727ae, 0x372155, 0x371afd,
    0x3714a5, 0x370e4e, 0x3707f8, 0x3701a2, 0x36fb4d, 0x36f4f9, 0x36eea6, 0x36e853, 0x36e201, 0x36dbb0, 0x36d55f, 0x36cf10, 0x36c8c1, 0x36c272, 0x36bc25,
    0x36b5d8, 0x36af8c, 0x36a940, 0x36a2f6, 0x369cac, 0x369663, 0x36901a, 0x3689d2, 0x36838b, 0x367d45, 0x3676ff, 0x3670ba, 0x366a76, 0x366433, 0x365df0,
    0x3657ae, 0x36516d, 0x364b2c, 0x3644ec, 0x363ead, 0x36386f, 0x363231, 0x362bf4, 0x3625b8, 0x361f7c, 0x361942, 0x361308, 0x360cce, 0x360695, 0x36005e,
    0x35fa26
};

#define HDCD_PROCESS_STEREO_DEFAULT 1
#define HDCD_MAX_CHANNELS 2

/** convert to float from 4-bit (3.1) fixed-point
 *  the always-negative value is stored positive, so make it negative */
#define GAINTOFLOAT(g) (g) ? -(float)(g>>1) - ((g & 1) ? 0.5 : 0.0) : 0.0

/** apply gain, 11-bit (3.8) fixed point,
 *  always negative but stored positive. */
#define APPLY_GAIN(s,g) do{int64_t s64 = s; s64 *= gaintab[g]; s = (int32_t)(s64 >> 23); }while(0);

/** tone generator: sample_number, frequency, sample_rate, amplitude */
#define TONEGEN16(sn, f, sr, a) (int16_t)(sin((6.28318530718 * (sn) * (f)) /(sr)) * (a) * 0x7fff)

typedef struct hdcd_state {
    uint64_t window;
    unsigned char readahead;

    /** arg is set when a packet prefix is found.
     *  control is the active control code, where
     *  bit 0-3: target_gain, 4-bit (3.1) fixed-point value
     *  bit 4  : peak_extend
     *  bit 5  : transient_filter
     *  bit 6,7: always zero */
    uint8_t arg, control;
    unsigned int sustain, sustain_reset; /**< code detect timer */

    int running_gain; /**< 11-bit (3.8) fixed point, extended from target_gain */

    /* counters */
    int code_counterA;            /**< 8-bit format packet */
    int code_counterA_almost;     /**< looks like an A code, but a bit expected to be 0 is 1 */
    int code_counterB;            /**< 16-bit format packet, 8-bit code, 8-bit XOR of code */
    int code_counterB_checkfails; /**< looks like a B code, but doesn't pass the XOR check */
    int code_counterC;            /**< packet prefix was found, expect a code */
    int code_counterC_unmatched;  /**< told to look for a code, but didn't find one */
    int count_peak_extend;        /**< valid packets where peak_extend was enabled */
    int count_transient_filter;   /**< valid packets where filter was detected */
    /** target_gain is a 4-bit (3.1) fixed-point value, always
     *  negative, but stored positive.
     *  The 16 possible values range from -7.5 to 0.0 dB in
     *  steps of 0.5, but no value below -6.0 dB should appear. */
    int gain_counts[16];
    int max_gain;
    /** occurrences of code detect timer expiring without detecting
     *  a code. -1 for timer never set. */
    int count_sustain_expired;

    int rate;                   /**< sampling rate */
    int _ana_snb;               /**< used in the analyze mode tone generator */
} hdcd_state;

typedef enum {
    HDCD_PE_NEVER        = 0, /**< All valid packets have PE set to off */
    HDCD_PE_INTERMITTENT = 1, /**< Some valid packets have PE set to on */
    HDCD_PE_PERMANENT    = 2, /**< All valid packets have PE set to on  */
} hdcd_pe;

static const char * const pe_str[] = {
    "never enabled",
    "enabled intermittently",
    "enabled permanently"
};

typedef enum {
    HDCD_NONE            = 0,  /**< HDCD packets do not (yet) appear  */
    HDCD_NO_EFFECT       = 1,  /**< HDCD packets appear, but all control codes are NOP */
    HDCD_EFFECTUAL       = 2,  /**< HDCD packets appear, and change the output in some way */
} hdcd_dv;

typedef enum {
    HDCD_PVER_NONE       = 0, /**< No packets (yet) discovered */
    HDCD_PVER_A          = 1, /**< Packets of type A (8-bit control) discovered */
    HDCD_PVER_B          = 2, /**< Packets of type B (8-bit control, 8-bit XOR) discovered */
    HDCD_PVER_MIX        = 3, /**< Packets of type A and B discovered, most likely an encoding error */
} hdcd_pf;

static const char * const pf_str[] = {
    "?", "A", "B", "A+B"
};

typedef struct hdcd_detection_data {
    hdcd_dv hdcd_detected;
    hdcd_pf packet_type;
    int total_packets;         /**< valid packets */
    int errors;                /**< detectable errors */
    hdcd_pe peak_extend;
    int uses_transient_filter;
    float max_gain_adjustment; /**< in dB, expected in the range -7.5 to 0.0 */
    int cdt_expirations;       /**< -1 for never set, 0 for set but never expired */

    int _active_count;         /**< used internally */
} hdcd_detection_data;

typedef enum {
    HDCD_ANA_OFF    = 0,
    HDCD_ANA_LLE    = 1,
    HDCD_ANA_PE     = 2,
    HDCD_ANA_CDT    = 3,
    HDCD_ANA_TGM    = 4,
    HDCD_ANA_TOP    = 5, /**< used in max value of AVOption */
} hdcd_ana_mode;

/** analyze mode descriptions: macro for AVOption definitions, array of const char for mapping mode to string */
#define HDCD_ANA_OFF_DESC "disabled"
#define HDCD_ANA_LLE_DESC "gain adjustment level at each sample"
#define HDCD_ANA_PE_DESC  "samples where peak extend occurs"
#define HDCD_ANA_CDT_DESC "samples where the code detect timer is active"
#define HDCD_ANA_TGM_DESC "samples where the target gain does not match between channels"
static const char * const ana_mode_str[] = {
    HDCD_ANA_OFF_DESC,
    HDCD_ANA_LLE_DESC,
    HDCD_ANA_PE_DESC,
    HDCD_ANA_CDT_DESC,
    HDCD_ANA_TGM_DESC,
};

typedef struct HDCDContext {
    const AVClass *class;
    hdcd_state state[HDCD_MAX_CHANNELS];

    /* AVOption members */
    /** use hdcd_*_stereo() functions to process both channels together.
     *  -af hdcd=process_stereo=0 for off
     *  -af hdcd=process_stereo=1 for on
     *  default is HDCD_PROCESS_STEREO_DEFAULT */
    int process_stereo;
    /** always extend peaks above -3dBFS even if PE isn't signaled
     *  -af hdcd=force_pe=0 for off
     *  -af hdcd=force_pe=1 for on
     *  default is off */
    int force_pe;

    /** analyze mode replaces the audio with a solid tone and adjusts
     *  the amplitude to signal some specific aspect of the decoding
     *  process. See docs or HDCD_ANA_* defines. */
    int analyze_mode;

    int cdt_ms;               /**< code detect timer period in ms */

    int disable_autoconvert;  /**< disable any format conversion or resampling in the filter graph */

    int bits_per_sample;      /**< bits per sample 16, 20, or 24 */
    /* end AVOption members */

    /** config_input() and config_output() scan links for any resampling
     *  or format changes. If found, warnings are issued and bad_config
     *  is set. */
    int bad_config;

    AVFilterContext *fctx; /**< filter context for logging errors */
    int sample_count;      /**< used in error logging */
    int val_target_gain;   /**< last matching target_gain in both channels */

    /* User information/stats */
    hdcd_detection_data detect;
} HDCDContext;

#define OFFSET(x) offsetof(HDCDContext, x)
#define A AV_OPT_FLAG_AUDIO_PARAM|AV_OPT_FLAG_FILTERING_PARAM
static const AVOption hdcd_options[] = {
    { "disable_autoconvert", "Disable any format conversion or resampling in the filter graph.",
        OFFSET(disable_autoconvert), AV_OPT_TYPE_BOOL, { .i64 = 1 }, 0, 1, A },
    { "process_stereo", "Process stereo channels together. Only apply target_gain when both channels match.",
        OFFSET(process_stereo), AV_OPT_TYPE_BOOL, { .i64 = HDCD_PROCESS_STEREO_DEFAULT }, 0, 1, A },
    { "cdt_ms", "Code detect timer period in ms.",
        OFFSET(cdt_ms), AV_OPT_TYPE_INT, { .i64 = 2000 }, 100, 60000, A },
    { "force_pe", "Always extend peaks above -3dBFS even when PE is not signaled.",
        OFFSET(force_pe), AV_OPT_TYPE_BOOL, { .i64 = 0 }, 0, 1, A },
    { "analyze_mode",  "Replace audio with solid tone and signal some processing aspect in the amplitude.",
        OFFSET(analyze_mode), AV_OPT_TYPE_INT, { .i64=HDCD_ANA_OFF }, 0, HDCD_ANA_TOP-1, A, "analyze_mode"},
        { "off", HDCD_ANA_OFF_DESC, 0, AV_OPT_TYPE_CONST, {.i64=HDCD_ANA_OFF}, 0, 0, A, "analyze_mode" },
        { "lle", HDCD_ANA_LLE_DESC, 0, AV_OPT_TYPE_CONST, {.i64=HDCD_ANA_LLE}, 0, 0, A, "analyze_mode" },
        { "pe",  HDCD_ANA_PE_DESC,  0, AV_OPT_TYPE_CONST, {.i64=HDCD_ANA_PE},  0, 0, A, "analyze_mode" },
        { "cdt", HDCD_ANA_CDT_DESC, 0, AV_OPT_TYPE_CONST, {.i64=HDCD_ANA_CDT}, 0, 0, A, "analyze_mode" },
        { "tgm", HDCD_ANA_TGM_DESC, 0, AV_OPT_TYPE_CONST, {.i64=HDCD_ANA_TGM}, 0, 0, A, "analyze_mode" },
    { "bits_per_sample",  "Valid bits per sample (location of the true LSB).",
        OFFSET(bits_per_sample), AV_OPT_TYPE_INT, { .i64=16 }, 16, 24, A, "bits_per_sample"},
        { "16", "16-bit (in s32 or s16)", 0, AV_OPT_TYPE_CONST, {.i64=16}, 0, 0, A, "bits_per_sample" },
        { "20", "20-bit (in s32)", 0, AV_OPT_TYPE_CONST, {.i64=20}, 0, 0, A, "bits_per_sample" },
        { "24", "24-bit (in s32)", 0, AV_OPT_TYPE_CONST, {.i64=24},  0, 0, A, "bits_per_sample" },
    {NULL}
};

AVFILTER_DEFINE_CLASS(hdcd);

static void hdcd_reset(hdcd_state *state, unsigned rate, unsigned cdt_ms)
{
    int i;
    uint64_t sustain_reset = (uint64_t)cdt_ms * rate / 1000;

    state->window = 0;
    state->readahead = 32;
    state->arg = 0;
    state->control = 0;
    state->running_gain = 0;
    state->sustain_reset = sustain_reset;
    state->sustain = 0;

    state->code_counterA = 0;
    state->code_counterA_almost = 0;
    state->code_counterB = 0;
    state->code_counterB_checkfails = 0;
    state->code_counterC = 0;
    state->code_counterC_unmatched = 0;
    state->count_peak_extend = 0;
    state->count_transient_filter = 0;
    for(i = 0; i < 16; i++) state->gain_counts[i] = 0;
    state->max_gain = 0;
    state->count_sustain_expired = -1;

    state->rate = rate;
    state->_ana_snb = 0;
}

static int hdcd_integrate(HDCDContext *ctx, hdcd_state *states, int channels, int *flag, const int32_t *samples, int count, int stride)
{
    uint32_t bits[HDCD_MAX_CHANNELS];
    int result = count;
    int i, j, f;
    *flag = 0;

    memset(bits, 0, sizeof(bits));
    if (stride < channels) stride = channels;

    for (i = 0; i < channels; i++)
        result = FFMIN(states[i].readahead, result);

    for (j = result - 1; j >= 0; j--) {
        for (i = 0; i < channels; i++)
            bits[i] |= (*(samples++) & 1U) << j;
        samples += stride - channels;
    }

    for (i = 0; i < channels; i++) {
        states[i].window = (states[i].window << result) | bits[i];
        states[i].readahead -= result;

        if (states[i].readahead == 0) {
            uint32_t wbits = (uint32_t)(states[i].window ^ states[i].window >> 5 ^ states[i].window >> 23);
            if (states[i].arg) {
                f = 0;
                if ((wbits & 0x0fa00500) == 0x0fa00500) {
                    /* A: 8-bit code  0x7e0fa005[..] */
                    if ((wbits & 0xc8) == 0) {
                        /*                   [..pt gggg]
                         * 0x0fa005[..] -> 0b[00.. 0...], gain part doubled (shifted left 1) */
                        states[i].control = (wbits & 255) + (wbits & 7);
                        f = 1;
                        states[i].code_counterA++;
                    } else {
                        /* one of bits 3, 6, or 7 was not 0 */
                        states[i].code_counterA_almost++;
                        av_log(ctx->fctx, AV_LOG_VERBOSE,
                               "hdcd error: Control A almost: 0x%02"PRIx32" near %d\n",
                               wbits & 0xff, ctx->sample_count);
                    }
                } else if ((wbits & 0xa0060000) == 0xa0060000) {
                    /* B: 8-bit code, 8-bit XOR check, 0x7e0fa006[....] */
                    if (((wbits ^ (~wbits >> 8 & 255)) & 0xffff00ff) == 0xa0060000) {
                        /*          check:   [..pt gggg ~(..pt gggg)]
                         * 0xa006[....] -> 0b[.... ....   .... .... ] */
                        states[i].control = wbits >> 8 & 255;
                        f = 1;
                        states[i].code_counterB++;
                    } else {
                        /* XOR check failed */
                        states[i].code_counterB_checkfails++;
                        av_log(ctx->fctx, AV_LOG_VERBOSE,
                               "hdcd error: Control B check failed: 0x%04"PRIx32
                               " (0x%02"PRIx32" vs 0x%02"PRIx32") near %d\n",
                               wbits & 0xffff, (wbits & 0xff00) >> 8, ~wbits & 0xff, ctx->sample_count);
                    }
                }
                if (f) {
                    *flag |= (1<<i);
                    /* update counters */
                    if (states[i].control & 16) states[i].count_peak_extend++;
                    if (states[i].control & 32) states[i].count_transient_filter++;
                    states[i].gain_counts[states[i].control & 15]++;
                    states[i].max_gain = FFMAX(states[i].max_gain, (states[i].control & 15));
                }
                states[i].arg = 0;
            }
            if (wbits == 0x7e0fa005 || wbits == 0x7e0fa006) {
                /* 0x7e0fa00[.]-> [0b0101 or 0b0110] */
                states[i].readahead = (wbits & 3) * 8;
                states[i].arg = 1;
                states[i].code_counterC++;
            } else {
                if (wbits)
                    states[i].readahead = readaheadtab[wbits & 0xff];
                else
                    states[i].readahead = 31; /* ffwd over digisilence */
            }
        }
    }
    return result;
}

static int hdcd_scan(HDCDContext *ctx, hdcd_state *states, int channels, const int32_t *samples, int max, int stride)
{
    int result;
    int i;
    int cdt_active[HDCD_MAX_CHANNELS];
    memset(cdt_active, 0, sizeof(cdt_active));

    if (stride < channels) stride = channels;

    /* code detect timers for each channel */
    for(i = 0; i < channels; i++) {
        if (states[i].sustain > 0) {
            cdt_active[i] = 1;
            if (states[i].sustain <=  (unsigned)max) {
                states[i].control = 0;
                max = states[i].sustain;
            }
            states[i].sustain -= max;
        }
    }

    result = 0;
    while (result < max) {
        int flag;
        int consumed = hdcd_integrate(ctx, states, channels, &flag, samples, max - result, stride);
        result += consumed;
        if (flag) {
            /* reset timer if code detected in a channel */
            for(i = 0; i < channels; i++) {
                if (flag & (1<<i)) {
                    states[i].sustain = states[i].sustain_reset;
                    /* if this is the first reset then change
                     * from never set, to never expired */
                    if (states[i].count_sustain_expired == -1)
                        states[i].count_sustain_expired = 0;
                }
            }
            break;
        }
        samples += consumed * stride;
    }

    for(i = 0; i < channels; i++) {
        /* code detect timer expired */
        if (cdt_active[i] && states[i].sustain == 0)
            states[i].count_sustain_expired++;
    }

    return result;
}

/** replace audio with solid tone, but save LSBs */
static void hdcd_analyze_prepare(hdcd_state *state, int32_t *samples, int count, int stride) {
    int n, f = 300;
    int so = state->rate / f;
    for (n = 0; n < count * stride; n += stride) {
        /* in analyze mode, the audio is replaced by a solid tone, and
         * amplitude is changed to signal when the specified feature is
         * used.
         * bit 0: HDCD signal preserved
         * bit 1: Original sample was above PE level */
        int32_t save = (abs(samples[n]) - PEAK_EXT_LEVEL >= 0) ? 2 : 0; /* above PE level */
        save |= samples[n] & 1;                      /* save LSB for HDCD packets */
        samples[n] = TONEGEN16(state->_ana_snb, f, state->rate, 0.1);
        samples[n] = (samples[n] | 3) ^ ((~save) & 3);
        if (++state->_ana_snb > so) state->_ana_snb = 0;
    }
}

/** encode a value in the given sample by adjusting the amplitude */
static int32_t hdcd_analyze_gen(int32_t sample, unsigned int v, unsigned int maxv)
{
    static const int r = 18, m = 1024;
    int64_t s64 = sample;
    v = m + (v * r * m / maxv);
    return (int32_t)(s64 * v / m);
}

/** behaves like hdcd_envelope(), but encodes processing information in
 *  a way that is audible (and visible in an audio editor) to aid analysis. */
static int hdcd_analyze(int32_t *samples, int count, int stride, int gain, int target_gain, int extend, int mode, int cdt_active, int tg_mismatch)
{
    static const int maxg = 0xf << 7;
    int i;
    int32_t *samples_end = samples + stride * count;

    for (i = 0; i < count; i++) {
        samples[i * stride] *= 1 << 15;
        if (mode == HDCD_ANA_PE) {
            int pel = (samples[i * stride] >> 16) & 1;
            int32_t sample = samples[i * stride];
            samples[i * stride] = hdcd_analyze_gen(sample, !!(pel && extend), 1);
        } else if (mode == HDCD_ANA_TGM && tg_mismatch > 0)
            samples[i * stride] = hdcd_analyze_gen(samples[i * stride], 1, 1);
          else if (mode == HDCD_ANA_CDT && cdt_active)
            samples[i * stride] = hdcd_analyze_gen(samples[i * stride], 1, 1);
    }

    if (gain <= target_gain) {
        int len = FFMIN(count, target_gain - gain);
        /* attenuate slowly */
        for (i = 0; i < len; i++) {
            ++gain;
            if (mode == HDCD_ANA_LLE)
                *samples = hdcd_analyze_gen(*samples, gain, maxg);
            samples += stride;
        }
        count -= len;
    } else {
        int len = FFMIN(count, (gain - target_gain) >> 3);
        /* amplify quickly */
        for (i = 0; i < len; i++) {
            gain -= 8;
            if (mode == HDCD_ANA_LLE)
                *samples = hdcd_analyze_gen(*samples, gain, maxg);
            samples += stride;
        }
        if (gain - 8 < target_gain)
            gain = target_gain;
        count -= len;
    }

    /* hold a steady level */
    if (gain == 0) {
        if (count > 0)
            samples += count * stride;
    } else {
        while (--count >= 0) {
            if (mode == HDCD_ANA_LLE)
                *samples = hdcd_analyze_gen(*samples, gain, maxg);
            samples += stride;
        }
    }

    av_assert0(samples == samples_end);

    return gain;
}

/** apply HDCD decoding parameters to a series of samples */
static int hdcd_envelope(int32_t *samples, int count, int stride, int vbits, int gain, int target_gain, int extend)
{
    static const int max_asample = sizeof(peaktab) / sizeof(peaktab[0]) - 1;
    int32_t *samples_end = samples + stride * count;
    int i;

    int pe_level = PEAK_EXT_LEVEL, shft = 15;
    if (vbits != 16) {
        pe_level = (1 << (vbits - 1)) - (0x8000 - PEAK_EXT_LEVEL);
        shft = 32 - vbits - 1;
    }
    av_assert0(PEAK_EXT_LEVEL + max_asample == 0x8000);

    if (extend) {
        for (i = 0; i < count; i++) {
            int32_t sample = samples[i * stride];
            int32_t asample = abs(sample) - pe_level;
            if (asample >= 0) {
                av_assert0(asample <= max_asample);
                sample = sample >= 0 ? peaktab[asample] : -peaktab[asample];
            } else
                sample *= (1 << shft);

            samples[i * stride] = sample;
        }
    } else {
        for (i = 0; i < count; i++)
            samples[i * stride] *= (1 << shft);
    }

    if (gain <= target_gain) {
        int len = FFMIN(count, target_gain - gain);
        /* attenuate slowly */
        for (i = 0; i < len; i++) {
            ++gain;
            APPLY_GAIN(*samples, gain);
            samples += stride;
        }
        count -= len;
    } else {
        int len = FFMIN(count, (gain - target_gain) >> 3);
        /* amplify quickly */
        for (i = 0; i < len; i++) {
            gain -= 8;
            APPLY_GAIN(*samples, gain);
            samples += stride;
        }
        if (gain - 8 < target_gain)
            gain = target_gain;
        count -= len;
    }

    /* hold a steady level */
    if (gain == 0) {
        if (count > 0)
            samples += count * stride;
    } else {
        while (--count >= 0) {
            APPLY_GAIN(*samples, gain);
            samples += stride;
        }
    }

    av_assert0(samples == samples_end);

    return gain;
}

/** extract fields from control code */
static void hdcd_control(HDCDContext *ctx, hdcd_state *state, int *peak_extend, int *target_gain)
{
    *peak_extend = (ctx->force_pe || state->control & 16);
    *target_gain = (state->control & 15) << 7;
}

typedef enum {
    HDCD_OK=0,
    HDCD_TG_MISMATCH
} hdcd_control_result;

static hdcd_control_result hdcd_control_stereo(HDCDContext *ctx, int *peak_extend0, int *peak_extend1)
{
    int target_gain[2];
    hdcd_control(ctx, &ctx->state[0], peak_extend0, &target_gain[0]);
    hdcd_control(ctx, &ctx->state[1], peak_extend1, &target_gain[1]);
    if (target_gain[0] == target_gain[1])
        ctx->val_target_gain = target_gain[0];
    else {
        av_log(ctx->fctx, AV_LOG_VERBOSE,
           "hdcd error: Unmatched target_gain near %d: tg0: %0.1f, tg1: %0.1f, lvg: %0.1f\n",
           ctx->sample_count,
           GAINTOFLOAT(target_gain[0] >>7),
           GAINTOFLOAT(target_gain[1] >>7),
           GAINTOFLOAT(ctx->val_target_gain >>7) );
           return HDCD_TG_MISMATCH;
    }
    return HDCD_OK;
}

static void hdcd_process(HDCDContext *ctx, hdcd_state *state, int32_t *samples, int count, int stride)
{
    int32_t *samples_end = samples + count * stride;
    int gain = state->running_gain;
    int peak_extend, target_gain;
    int lead = 0;

    if (ctx->analyze_mode)
        hdcd_analyze_prepare(state, samples, count, stride);

    hdcd_control(ctx, state, &peak_extend, &target_gain);
    while (count > lead) {
        int envelope_run;
        int run;

        av_assert0(samples + lead * stride + stride * (count - lead) <= samples_end);
        run = hdcd_scan(ctx, state, 1, samples + lead * stride, count - lead, 0) + lead;
        envelope_run = run - 1;

        av_assert0(samples + envelope_run * stride <= samples_end);
        if (ctx->analyze_mode)
            gain = hdcd_analyze(samples, envelope_run, stride, gain, target_gain, peak_extend, ctx->analyze_mode, state->sustain, -1);
        else
            gain = hdcd_envelope(samples, envelope_run, stride, ctx->bits_per_sample, gain, target_gain, peak_extend);

        samples += envelope_run * stride;
        count -= envelope_run;
        lead = run - envelope_run;
        hdcd_control(ctx, state, &peak_extend, &target_gain);
    }
    if (lead > 0) {
        av_assert0(samples + lead * stride <= samples_end);
        if (ctx->analyze_mode)
            gain = hdcd_analyze(samples, lead, stride, gain, target_gain, peak_extend, ctx->analyze_mode, state->sustain, -1);
        else
            gain = hdcd_envelope(samples, lead, stride, ctx->bits_per_sample, gain, target_gain, peak_extend);
    }

    state->running_gain = gain;
}

static void hdcd_process_stereo(HDCDContext *ctx, int32_t *samples, int count)
{
    const int stride = 2;
    int32_t *samples_end = samples + count * stride;
    int gain[2] = {ctx->state[0].running_gain, ctx->state[1].running_gain};
    int peak_extend[2];
    int lead = 0;
    int ctlret;

    if (ctx->analyze_mode) {
        hdcd_analyze_prepare(&ctx->state[0], samples, count, stride);
        hdcd_analyze_prepare(&ctx->state[1], samples + 1, count, stride);
    }

    ctlret = hdcd_control_stereo(ctx, &peak_extend[0], &peak_extend[1]);
    while (count > lead) {
        int envelope_run, run;

        av_assert0(samples + lead * stride + stride * (count - lead) <= samples_end);
        run = hdcd_scan(ctx, ctx->state, 2, samples + lead * stride, count - lead, 0) + lead;
        envelope_run = run - 1;

        av_assert0(samples + envelope_run * stride <= samples_end);

        if (ctx->analyze_mode) {
            gain[0] = hdcd_analyze(samples, envelope_run, stride, gain[0], ctx->val_target_gain, peak_extend[0],
                ctx->analyze_mode,
                ctx->state[0].sustain,
                (ctlret == HDCD_TG_MISMATCH) );
            gain[1] = hdcd_analyze(samples + 1, envelope_run, stride, gain[1], ctx->val_target_gain, peak_extend[1],
                ctx->analyze_mode,
                ctx->state[1].sustain,
                (ctlret == HDCD_TG_MISMATCH) );
        } else {
            gain[0] = hdcd_envelope(samples, envelope_run, stride, ctx->bits_per_sample, gain[0], ctx->val_target_gain, peak_extend[0]);
            gain[1] = hdcd_envelope(samples + 1, envelope_run, stride, ctx->bits_per_sample, gain[1], ctx->val_target_gain, peak_extend[1]);
        }

        samples += envelope_run * stride;
        count -= envelope_run;
        lead = run - envelope_run;

        ctlret = hdcd_control_stereo(ctx, &peak_extend[0], &peak_extend[1]);
    }
    if (lead > 0) {
        av_assert0(samples + lead * stride <= samples_end);
        if (ctx->analyze_mode) {
            gain[0] = hdcd_analyze(samples, lead, stride, gain[0], ctx->val_target_gain, peak_extend[0],
                ctx->analyze_mode,
                ctx->state[0].sustain,
                (ctlret == HDCD_TG_MISMATCH) );
            gain[1] = hdcd_analyze(samples + 1, lead, stride, gain[1], ctx->val_target_gain, peak_extend[1],
                ctx->analyze_mode,
                ctx->state[1].sustain,
                (ctlret == HDCD_TG_MISMATCH) );
        } else {
            gain[0] = hdcd_envelope(samples, lead, stride, ctx->bits_per_sample, gain[0], ctx->val_target_gain, peak_extend[0]);
            gain[1] = hdcd_envelope(samples + 1, lead, stride, ctx->bits_per_sample, gain[1], ctx->val_target_gain, peak_extend[1]);
        }
    }

    ctx->state[0].running_gain = gain[0];
    ctx->state[1].running_gain = gain[1];
}

static void hdcd_detect_reset(hdcd_detection_data *detect) {
    detect->hdcd_detected = HDCD_NONE;
    detect->packet_type = HDCD_PVER_NONE;
    detect->total_packets = 0;
    detect->errors = 0;
    detect->peak_extend = HDCD_PE_NEVER;
    detect->uses_transient_filter = 0;
    detect->max_gain_adjustment = 0.0;
    detect->cdt_expirations = -1;
    detect->_active_count = 0;
}

static void hdcd_detect_start(hdcd_detection_data *detect) {
    detect->errors = 0;          /* re-sum every pass */
    detect->total_packets = 0;
    detect->_active_count = 0;   /* will need to match channels at hdcd_detect_end() */
    detect->cdt_expirations = -1;
}

static void hdcd_detect_onech(hdcd_state *state, hdcd_detection_data *detect) {
    hdcd_pe pe = HDCD_PE_NEVER;
    detect->uses_transient_filter |= !!(state->count_transient_filter);
    detect->total_packets += state->code_counterA + state->code_counterB;
    if (state->code_counterA) detect->packet_type |= HDCD_PVER_A;
    if (state->code_counterB) detect->packet_type |= HDCD_PVER_B;
    if (state->count_peak_extend) {
        /* if every valid packet has used PE, call it permanent */
        if (state->count_peak_extend == state->code_counterA + state->code_counterB)
            pe = HDCD_PE_PERMANENT;
        else
            pe = HDCD_PE_INTERMITTENT;
        if (detect->peak_extend != HDCD_PE_INTERMITTENT)
            detect->peak_extend = pe;
    }
    detect->max_gain_adjustment = FFMIN(detect->max_gain_adjustment, GAINTOFLOAT(state->max_gain));
    detect->errors += state->code_counterA_almost
        + state->code_counterB_checkfails
        + state->code_counterC_unmatched;
    if (state->sustain) detect->_active_count++;
    if (state->count_sustain_expired >= 0) {
        if (detect->cdt_expirations == -1) detect->cdt_expirations = 0;
        detect->cdt_expirations += state->count_sustain_expired;
    }
}

static void hdcd_detect_end(hdcd_detection_data *detect, int channels) {
    /* HDCD is detected if a valid packet is active in all
     * channels at the same time. */
    if (detect->_active_count == channels) {
        if (detect->max_gain_adjustment || detect->peak_extend)
            detect->hdcd_detected = HDCD_EFFECTUAL;
        else
            detect->hdcd_detected = HDCD_NO_EFFECT;
    }
}

static int filter_frame(AVFilterLink *inlink, AVFrame *in)
{
    AVFilterContext *ctx = inlink->dst;
    HDCDContext *s = ctx->priv;
    AVFilterLink *outlink = ctx->outputs[0];
    AVFrame *out;
    const int16_t *in_data;
    const int32_t *in_data32;
    int32_t *out_data;
    int n, c, result;
    int a = 32 - s->bits_per_sample;

    out = ff_get_audio_buffer(outlink, in->nb_samples);
    if (!out) {
        av_frame_free(&in);
        return AVERROR(ENOMEM);
    }
    result = av_frame_copy_props(out, in);
    if (result) {
        av_frame_free(&out);
        av_frame_free(&in);
        return result;
    }
    out->format = outlink->format; // is this needed?

    out_data = (int32_t*)out->data[0];
    switch (inlink->format) {
        case AV_SAMPLE_FMT_S16P:
            for (n = 0; n < in->nb_samples; n++)
                for (c = 0; c < in->channels; c++) {
                    in_data = (int16_t*)in->extended_data[c];
                    out_data[(n * in->channels) + c] = in_data[n];
                }
            break;
        case AV_SAMPLE_FMT_S16:
            in_data  = (int16_t*)in->data[0];
            for (n = 0; n < in->nb_samples * in->channels; n++)
                out_data[n] = in_data[n];
            break;

        case AV_SAMPLE_FMT_S32P:
            for (n = 0; n < in->nb_samples; n++)
                for (c = 0; c < in->channels; c++) {
                    in_data32 = (int32_t*)in->extended_data[c];
                    out_data[(n * in->channels) + c] = in_data32[n] >> a;
                }
            break;
        case AV_SAMPLE_FMT_S32:
            in_data32  = (int32_t*)in->data[0];
            for (n = 0; n < in->nb_samples * in->channels; n++)
                out_data[n] = in_data32[n] >> a;
            break;
    }

    if (s->process_stereo) {
        hdcd_detect_start(&s->detect);
        hdcd_process_stereo(s, out_data, in->nb_samples);
        hdcd_detect_onech(&s->state[0], &s->detect);
        hdcd_detect_onech(&s->state[1], &s->detect);
        hdcd_detect_end(&s->detect, 2);
    } else {
        hdcd_detect_start(&s->detect);
        for (c = 0; c < in->channels; c++) {
            hdcd_process(s, &s->state[c], out_data + c, in->nb_samples, in->channels);
            hdcd_detect_onech(&s->state[c], &s->detect);
        }
        hdcd_detect_end(&s->detect, in->channels);
    }

    s->sample_count += in->nb_samples * in->channels;

    av_frame_free(&in);
    return ff_filter_frame(outlink, out);
}

static int query_formats(AVFilterContext *ctx)
{
    static const int sample_rates[] = {
        44100, 48000,
        88200, 96000,
        176400, 192000,
        -1
    };
    AVFilterFormats *in_formats;
    AVFilterFormats *out_formats;
    AVFilterChannelLayouts *layouts = NULL;
    AVFilterLink *inlink  = ctx->inputs[0];
    AVFilterLink *outlink = ctx->outputs[0];

    static const enum AVSampleFormat sample_fmts_in[] = {
        AV_SAMPLE_FMT_S16,
        AV_SAMPLE_FMT_S16P,
        AV_SAMPLE_FMT_S32,
        AV_SAMPLE_FMT_S32P,
        AV_SAMPLE_FMT_NONE
    };
    static const enum AVSampleFormat sample_fmts_out[] = {
        AV_SAMPLE_FMT_S32,
        AV_SAMPLE_FMT_NONE
    };
    int ret;

    ret = ff_add_channel_layout(&layouts, AV_CH_LAYOUT_MONO);
    if (ret < 0)
        return ret;
    ret = ff_add_channel_layout(&layouts, AV_CH_LAYOUT_STEREO);
    if (ret < 0)
        return ret;

    ret = ff_set_common_channel_layouts(ctx, layouts);
    if (ret < 0)
        return ret;

    in_formats = ff_make_format_list(sample_fmts_in);
    ret = ff_formats_ref(in_formats, &inlink->outcfg.formats);
    if (ret < 0)
        return ret;

    out_formats = ff_make_format_list(sample_fmts_out);
    ret = ff_formats_ref(out_formats, &outlink->incfg.formats);
    if (ret < 0)
        return ret;

    return
        ff_set_common_samplerates(ctx, ff_make_format_list(sample_rates) );
}

static av_cold void uninit(AVFilterContext *ctx)
{
    HDCDContext *s = ctx->priv;
    int i, j;

    /* dump the state for each channel for AV_LOG_VERBOSE */
    for (i = 0; i < HDCD_MAX_CHANNELS; i++) {
        hdcd_state *state = &s->state[i];
        av_log(ctx, AV_LOG_VERBOSE, "Channel %d: counter A: %d, B: %d, C: %d\n", i,
                state->code_counterA, state->code_counterB, state->code_counterC);
        av_log(ctx, AV_LOG_VERBOSE, "Channel %d: pe: %d, tf: %d, almost_A: %d, checkfail_B: %d, unmatched_C: %d, cdt_expired: %d\n", i,
            state->count_peak_extend,
            state->count_transient_filter,
            state->code_counterA_almost,
            state->code_counterB_checkfails,
            state->code_counterC_unmatched,
            state->count_sustain_expired);
        for (j = 0; j <= state->max_gain; j++) {
            av_log(ctx, AV_LOG_VERBOSE, "Channel %d: tg %0.1f: %d\n", i, GAINTOFLOAT(j), state->gain_counts[j]);
        }
    }
    av_log(ctx, AV_LOG_VERBOSE, "Packets: type: %s, total: %d\n",
        pf_str[s->detect.packet_type],
        s->detect.total_packets);

    /* log the HDCD decode information */
    if (s->detect.hdcd_detected)
        av_log(ctx, AV_LOG_INFO,
            "HDCD detected: yes, peak_extend: %s, max_gain_adj: %0.1f dB, transient_filter: %s, detectable errors: %d%s%s\n",
            pe_str[s->detect.peak_extend],
            s->detect.max_gain_adjustment,
            (s->detect.uses_transient_filter) ? "detected" : "not detected",
            s->detect.errors, (s->detect.errors) ? " (try -v verbose)" : "",
            (s->bad_config) ? " (bad_config)" : ""
            );
    else
        av_log(ctx, AV_LOG_INFO, "HDCD detected: no%s\n",
            (s->bad_config) ? " (bad_config)" : ""
            );
}


static av_cold int init(AVFilterContext *ctx)
{
    HDCDContext *s = ctx->priv;

    s->sample_count = 0;
    s->fctx = ctx;
    s->bad_config = 0;

    if (s->disable_autoconvert) {
        av_log(ctx, AV_LOG_VERBOSE, "Disabling automatic format conversion.\n");
        avfilter_graph_set_auto_convert(ctx->graph, AVFILTER_AUTO_CONVERT_NONE);
    }
    return 0;
}

static int config_input(AVFilterLink *inlink) {
    AVFilterContext *ctx = inlink->dst;
    HDCDContext *s = ctx->priv;
    int c;

    av_log(ctx, AV_LOG_VERBOSE, "Auto-convert: %s\n",
        (ctx->graph->disable_auto_convert) ? "disabled" : "enabled");

    if ((inlink->format == AV_SAMPLE_FMT_S16 ||
         inlink->format == AV_SAMPLE_FMT_S16P) &&
         s->bits_per_sample != 16) {
            av_log(ctx, AV_LOG_WARNING, "bits_per_sample %d does not fit into sample format %s, falling back to 16\n",
                s->bits_per_sample, av_get_sample_fmt_name(inlink->format) );
        s->bits_per_sample = 16;
    } else {
        av_log(ctx, AV_LOG_VERBOSE, "Looking for %d-bit HDCD in sample format %s\n",
            s->bits_per_sample, av_get_sample_fmt_name(inlink->format) );
    }

    if (s->bits_per_sample != 16)
        av_log(ctx, AV_LOG_WARNING, "20 and 24-bit HDCD decoding is experimental\n");
    if (inlink->sample_rate != 44100)
        av_log(ctx, AV_LOG_WARNING, "HDCD decoding for sample rates other than 44100 is experimental\n");

    hdcd_detect_reset(&s->detect);
    for (c = 0; c < HDCD_MAX_CHANNELS; c++) {
        hdcd_reset(&s->state[c], inlink->sample_rate, s->cdt_ms);
    }
    av_log(ctx, AV_LOG_VERBOSE, "CDT period: %dms (%u samples @44100Hz)\n",
        s->cdt_ms, s->state[0].sustain_reset );

    if (inlink->channels != 2 && s->process_stereo) {
        av_log(ctx, AV_LOG_WARNING, "process_stereo disabled (channels = %d)\n", inlink->channels);
        s->process_stereo = 0;
    }
    av_log(ctx, AV_LOG_VERBOSE, "Process mode: %s\n",
        (s->process_stereo) ? "process stereo channels together" : "process each channel separately");

    av_log(ctx, AV_LOG_VERBOSE, "Force PE: %s\n",
        (s->force_pe) ? "on" : "off");
    av_log(ctx, AV_LOG_VERBOSE, "Analyze mode: [%d] %s\n",
        s->analyze_mode, ana_mode_str[s->analyze_mode] );

    return 0;
}

static const AVFilterPad avfilter_af_hdcd_inputs[] = {
    {
        .name         = "default",
        .type         = AVMEDIA_TYPE_AUDIO,
        .filter_frame = filter_frame,
        .config_props = config_input,
    },
    { NULL }
};

static const AVFilterPad avfilter_af_hdcd_outputs[] = {
    {
        .name = "default",
        .type = AVMEDIA_TYPE_AUDIO,
    },
    { NULL }
};

const AVFilter ff_af_hdcd = {
    .name          = "hdcd",
    .description   = NULL_IF_CONFIG_SMALL("Apply High Definition Compatible Digital (HDCD) decoding."),
    .priv_size     = sizeof(HDCDContext),
    .priv_class    = &hdcd_class,
    .init          = init,
    .uninit        = uninit,
    .query_formats = query_formats,
    .inputs        = avfilter_af_hdcd_inputs,
    .outputs       = avfilter_af_hdcd_outputs,
};
